/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.filesys.repo.ResultCallback;
import org.alfresco.filesys.repo.rules.Command;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.commands.CompoundCommand;
import org.alfresco.filesys.repo.rules.commands.DeleteFileCommand;
import org.alfresco.filesys.repo.rules.commands.RestoreFileCommand;
import org.alfresco.filesys.repo.rules.operations.CreateFileOperation;
import org.alfresco.filesys.repo.rules.operations.DeleteFileOperation;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioDeleteRestoreInstance
implements ScenarioInstance {
    private static Log logger = LogFactory.getLog(ScenarioDeleteRestoreInstance.class);
    InternalState internalState = InternalState.NONE;
    private Date startTime = new Date();
    private String deleteName;
    private NodeRef originalNodeRef;
    private ScenarioInstance.Ranking ranking;
    private long timeout = 60000L;
    private boolean isComplete;
    private Map<String, String> deletes = new HashMap<String, String>();

    @Override
    public Command evaluate(Operation operation) {
        Date now = new Date();
        if (now.getTime() > this.startTime.getTime() + this.getTimeout() && logger.isDebugEnabled()) {
            logger.debug((Object)("Instance timed out deleteName:" + this.deleteName));
            this.isComplete = true;
            return null;
        }
        switch (this.internalState) {
            case NONE: {
                if (operation instanceof DeleteFileOperation) {
                    DeleteFileOperation d = (DeleteFileOperation)operation;
                    this.deleteName = d.getName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("entering LOOKING_FOR_CREATE state: " + this.deleteName));
                    }
                    this.internalState = InternalState.LOOKING_FOR_CREATE;
                    ArrayList<Command> commands = new ArrayList<Command>();
                    ArrayList<Command> postCommitCommands = new ArrayList<Command>();
                    ArrayList<Command> postErrorCommands = new ArrayList<Command>();
                    commands.add(new DeleteFileCommand(d.getName(), d.getRootNodeRef(), d.getPath()));
                    postCommitCommands.add(this.newDeleteFileCallbackCommand());
                    return new CompoundCommand(commands, postCommitCommands, postErrorCommands);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"State error, expected a DELETE");
                }
                this.isComplete = true;
                break;
            }
            case LOOKING_FOR_CREATE: {
                CreateFileOperation c;
                if (!(operation instanceof CreateFileOperation) || !(c = (CreateFileOperation)operation).getName().equalsIgnoreCase(this.deleteName)) break;
                this.isComplete = true;
                if (this.originalNodeRef != null) {
                    logger.debug((Object)("Scenario fires:" + String.valueOf(this)));
                    return new RestoreFileCommand(c.getName(), c.getRootNodeRef(), c.getPath(), c.getAllocationSize(), this.originalNodeRef);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isComplete() {
        return this.isComplete;
    }

    @Override
    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public String toString() {
        return "ScenarioDeleteRestoreShuffleInstance:" + this.deleteName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    private ResultCallback newDeleteFileCallbackCommand() {
        return new ResultCallback(){

            @Override
            public void execute(Object result) {
                if (result instanceof NodeRef) {
                    logger.debug((Object)"got node ref of deleted node");
                    ScenarioDeleteRestoreInstance.this.originalNodeRef = (NodeRef)result;
                }
            }

            @Override
            public AlfrescoTransactionSupport.TxnReadState getTransactionRequired() {
                return AlfrescoTransactionSupport.TxnReadState.TXN_NONE;
            }
        };
    }

    static enum InternalState {
        NONE,
        LOOKING_FOR_CREATE;

    }
}

