/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyCheck;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class NodeRefPropertyMethodInterceptor
implements MethodInterceptor {
    private boolean filterOnGet = true;
    private boolean filterOnSet = true;
    private transient DictionaryService dictionaryService;
    private transient NodeService nodeService;

    public boolean isFilterOnGet() {
        return this.filterOnGet;
    }

    public void setFilterOnGet(boolean filterOnGet) {
        this.filterOnGet = filterOnGet;
    }

    public boolean isFilterOnSet() {
        return this.filterOnSet;
    }

    public void setFilterOnSet(boolean filterOnSet) {
        this.filterOnSet = filterOnSet;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    private DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    private NodeService getNodeService() {
        return this.nodeService;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        Object[] args = invocation.getArguments();
        Object[] in = new Object[args.length];
        System.arraycopy(args, 0, in, 0, args.length);
        invocation.getStaticPart();
        try {
            if (methodName.equals("addAspect")) {
                if (this.filterOnSet) {
                    NodeRef cfr_ignored_0 = (NodeRef)args[0];
                    QName cfr_ignored_1 = (QName)args[1];
                    Map newProperties = (Map)args[2];
                    if (newProperties == null) {
                        args[2] = newProperties;
                        Object object = invocation.proceed();
                        return object;
                    }
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(newProperties.size() * 2);
                    for (Map.Entry entry : newProperties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        value = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, value);
                    }
                    args[2] = convertedProperties;
                    Object object = invocation.proceed();
                    return object;
                }
                Object object = invocation.proceed();
                return object;
            }
            if (methodName.equals("createNode") && args.length == 5) {
                if (this.filterOnSet) {
                    NodeRef cfr_ignored_2 = (NodeRef)args[0];
                    QName cfr_ignored_3 = (QName)args[1];
                    QName cfr_ignored_4 = (QName)args[2];
                    QName cfr_ignored_5 = (QName)args[3];
                    Map newProperties = (Map)args[4];
                    if (newProperties == null) {
                        args[4] = newProperties;
                        Object object = invocation.proceed();
                        return object;
                    }
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(newProperties.size() * 2);
                    for (Map.Entry entry : newProperties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        value = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, value);
                    }
                    args[4] = newProperties;
                    Object object = invocation.proceed();
                    return object;
                }
                Object object = invocation.proceed();
                return object;
            }
            if (methodName.equals("getProperty")) {
                if (this.filterOnGet) {
                    NodeRef cfr_ignored_6 = (NodeRef)args[0];
                    QName propertyQName = (QName)args[1];
                    Serializable value = (Serializable)invocation.proceed();
                    Serializable serializable = this.getValue(propertyQName, value);
                    return serializable;
                }
                Object object = invocation.proceed();
                return object;
            }
            if (methodName.equals("getProperties")) {
                if (this.filterOnGet) {
                    NodeRef cfr_ignored_7 = (NodeRef)args[0];
                    Map properties = (Map)invocation.proceed();
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(properties.size() * 2);
                    for (Map.Entry entry : properties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        Serializable convertedValue = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, convertedValue);
                    }
                    HashMap<QName, Serializable> hashMap = convertedProperties;
                    return hashMap;
                }
                Object object = invocation.proceed();
                return object;
            }
            if (methodName.equals("setProperties")) {
                if (this.filterOnSet) {
                    NodeRef cfr_ignored_8 = (NodeRef)args[0];
                    Map newProperties = (Map)args[1];
                    HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(newProperties.size() * 2);
                    for (Map.Entry entry : newProperties.entrySet()) {
                        QName propertyQName = (QName)entry.getKey();
                        Serializable value = (Serializable)entry.getValue();
                        value = this.getValue(propertyQName, value);
                        convertedProperties.put(propertyQName, value);
                    }
                    args[1] = convertedProperties;
                    Object object = invocation.proceed();
                    return object;
                }
                Object object = invocation.proceed();
                return object;
            }
            if (methodName.equals("setProperty")) {
                if (this.filterOnSet) {
                    NodeRef cfr_ignored_9 = (NodeRef)args[0];
                    QName propertyQName = (QName)args[1];
                    Serializable value = (Serializable)args[2];
                    value = this.getValue(propertyQName, value);
                    args[2] = value;
                    Object object = invocation.proceed();
                    return object;
                }
                Object object = invocation.proceed();
                return object;
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            System.arraycopy(in, 0, args, 0, in.length);
        }
    }

    private Serializable getValue(QName propertyQName, Serializable inboundValue) {
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyQName);
        if (propertyDef == null) {
            return inboundValue;
        }
        if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.NODE_REF) || propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) {
            block13: {
                NodeRef test;
                block14: {
                    if (inboundValue instanceof Collection) {
                        HashSet<NodeRef> categories = new HashSet<NodeRef>();
                        Collection in = (Collection)((Object)inboundValue);
                        ArrayList<NodeRef> out = new ArrayList<NodeRef>(in.size());
                        for (Object o : in) {
                            Serializable value = (Serializable)o;
                            if (value == null) {
                                out.add(null);
                                continue;
                            }
                            try {
                                NodeRef test2 = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)value);
                                if (!this.getNodeService().exists(test2)) continue;
                                if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) {
                                    QName type = this.getNodeService().getType(test2);
                                    if (!this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CATEGORY) || categories.contains(test2)) continue;
                                    out.add(test2);
                                    categories.add(test2);
                                    continue;
                                }
                                out.add(test2);
                            }
                            catch (TypeConversionException typeConversionException) {}
                        }
                        return out;
                    }
                    if (inboundValue == null) {
                        return inboundValue;
                    }
                    try {
                        test = (NodeRef)DefaultTypeConverter.INSTANCE.convert(NodeRef.class, (Object)inboundValue);
                        if (!this.getNodeService().exists(test)) break block13;
                        if (!propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) break block14;
                        QName type = this.getNodeService().getType(test);
                        if (this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CATEGORY)) {
                            return test;
                        }
                        return null;
                    }
                    catch (TypeConversionException typeConversionException) {
                        return null;
                    }
                }
                return test;
            }
            return null;
        }
        return inboundValue;
    }
}

