/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import org.alfresco.repo.virtual.ref.HierarchicalPathHasher;
import org.apache.commons.lang3.StringUtils;

public class NumericPathHasher
extends HierarchicalPathHasher {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String hashSubpath(String subpath) {
        try {
            int i;
            if (subpath.trim().isEmpty()) {
                return null;
            }
            String[] numericPathElements = subpath.split("/");
            if (numericPathElements == null || numericPathElements.length == 0) {
                return "0";
            }
            long lHash = 0L;
            int n = i = numericPathElements[0].isEmpty() ? 1 : 0;
            while (true) {
                if (i >= numericPathElements.length) {
                    return "" + lHash;
                }
                if (numericPathElements[i].length() != 1) {
                    return null;
                }
                long intPathElement = Long.parseLong(numericPathElements[i]);
                if (intPathElement <= 0L) {
                    return null;
                }
                if ((lHash = lHash * 10L + intPathElement) < 0L) {
                    return null;
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    protected String lookupSubpathHash(String hash) {
        Object[] digits = hash.split("(?<=.)");
        return "/" + StringUtils.join((Object[])digits, (char)'/');
    }
}

