/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.alfresco.util.Pair;

public class AuditQueryParameters {
    private boolean forward = true;
    private String applicationName;
    private String user;
    private Long fromId;
    private Long toId;
    private Long fromTime;
    private Long toTime;
    private List<Pair<String, Serializable>> searchKeyValues = new ArrayList<Pair<String, Serializable>>();

    public boolean isZeroResultQuery() {
        if (this.fromId != null && this.toId != null && this.fromId.compareTo(this.toId) > 0) {
            return true;
        }
        return this.fromTime != null && this.toTime != null && this.fromTime.compareTo(this.toTime) > 0;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public Long getFromId() {
        return this.fromId;
    }

    public void setFromId(Long fromId) {
        this.fromId = fromId;
    }

    public Long getToId() {
        return this.toId;
    }

    public void setToId(Long toId) {
        this.toId = toId;
    }

    public Long getFromTime() {
        return this.fromTime;
    }

    public void setFromTime(Long fromTime) {
        this.fromTime = fromTime;
    }

    public Long getToTime() {
        return this.toTime;
    }

    public void setToTime(Long toTime) {
        this.toTime = toTime;
    }

    public List<Pair<String, Serializable>> getSearchKeyValues() {
        return Collections.unmodifiableList(this.searchKeyValues);
    }

    public void addSearchKey(String searchKey, Serializable searchValue) {
        if (searchKey == null && searchValue == null) {
            throw new IllegalArgumentException("A search key must have a 'searchKey' and/or a 'searchValue'.");
        }
        if (this.searchKeyValues.size() > 0) {
            throw new UnsupportedOperationException("Only one search key-value pair is currently supported.");
        }
        this.searchKeyValues.add((Pair<String, Serializable>)new Pair((Object)searchKey, (Object)searchValue));
    }
}

