/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.transfer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class TransferProgress {
    private static Set<Status> terminalStatuses = Collections.unmodifiableSet(new HashSet<Status>(Arrays.asList(Status.COMPLETE, Status.ERROR, Status.CANCELLED)));
    private Status status;
    private int currentPosition;
    private int endPosition;
    private Throwable error;

    public static Set<Status> getTerminalStatuses() {
        return terminalStatuses;
    }

    public boolean isFinished() {
        return terminalStatuses.contains((Object)this.status);
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void setCurrentPosition(int currentPosition) {
        this.currentPosition = currentPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(int endPosition) {
        this.endPosition = endPosition;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TransferProgress{status=");
        sb.append((Object)this.status);
        sb.append("; currentPosition=");
        sb.append(this.currentPosition);
        sb.append("; endPosition=");
        sb.append(this.endPosition);
        sb.append("; error={");
        sb.append(this.error);
        sb.append("}}");
        return sb.toString();
    }

    public static enum Status {
        PRE_COMMIT,
        COMMIT_REQUESTED,
        COMMITTING,
        COMPLETE,
        ERROR,
        CANCELLED;

    }
}

