/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo.rules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.filesys.repo.rules.EvaluatorContext;
import org.alfresco.filesys.repo.rules.Operation;
import org.alfresco.filesys.repo.rules.Scenario;
import org.alfresco.filesys.repo.rules.ScenarioInstance;
import org.alfresco.filesys.repo.rules.ScenarioRenameDeleteMoveInstance;
import org.alfresco.filesys.repo.rules.operations.RenameFileOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScenarioRenameDeleteMove
implements Scenario {
    private static Log logger = LogFactory.getLog(ScenarioRenameDeleteMove.class);
    private Pattern pattern;
    private String strPattern;
    private long timeout = 30000L;
    private ScenarioInstance.Ranking ranking = ScenarioInstance.Ranking.HIGH;

    @Override
    public ScenarioInstance createInstance(EvaluatorContext ctx, Operation operation) {
        RenameFileOperation r;
        Matcher m;
        if (operation instanceof RenameFileOperation && (m = this.pattern.matcher((r = (RenameFileOperation)operation).getTo())).matches()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("New Scenario ScenarioRenameDeleteMoveInstance strPattern:" + String.valueOf(this.pattern)));
            }
            ScenarioRenameDeleteMoveInstance instance = new ScenarioRenameDeleteMoveInstance();
            instance.setTimeout(this.timeout);
            instance.setRanking(this.ranking);
            return instance;
        }
        return null;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern, 2);
        this.strPattern = pattern;
    }

    public String getPattern() {
        return this.strPattern;
    }

    public void setRanking(ScenarioInstance.Ranking ranking) {
        this.ranking = ranking;
    }

    public ScenarioInstance.Ranking getRanking() {
        return this.ranking;
    }
}

