/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.copy;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class AbstractBaseCopyService {
    private Set<String> systemNamespaces = new HashSet<String>(5);

    public void setSystemNamespaces(List<String> systemNamespaces) {
        this.systemNamespaces.addAll(systemNamespaces);
    }

    public List<String> getSystemNamespaces() {
        return new LinkedList<String>(this.systemNamespaces);
    }

    protected AssociationCopyInfo getAssociationCopyInfo(NodeService nodeService, NodeRef sourceNodeRef, NodeRef sourceParentRef, String newName, boolean nameChanged) {
        boolean copyingFromPrimaryParent;
        ChildAssociationRef primaryAssocRef;
        ChildAssociationRef sourceParentAssocRef = primaryAssocRef = nodeService.getPrimaryParent(sourceNodeRef);
        if (sourceParentRef != null && !(copyingFromPrimaryParent = sourceParentRef.equals((Object)primaryAssocRef.getParentRef()))) {
            List assocList = nodeService.getParentAssocs(sourceNodeRef);
            for (ChildAssociationRef assocListEntry : assocList) {
                if (!sourceParentRef.equals((Object)assocListEntry.getParentRef())) continue;
                sourceParentAssocRef = assocListEntry;
                break;
            }
        }
        QName targetAssocQName = null;
        QName existingQName = sourceParentAssocRef.getQName();
        targetAssocQName = nameChanged && !this.systemNamespaces.contains(existingQName.getNamespaceURI()) ? QName.createQName((String)sourceParentAssocRef.getQName().getNamespaceURI(), (String)QName.createValidLocalName((String)newName)) : existingQName;
        return new AssociationCopyInfo(targetAssocQName, sourceParentAssocRef);
    }

    public static class AssociationCopyInfo {
        private final QName targetAssocQName;
        private final ChildAssociationRef sourceParentAssoc;

        public AssociationCopyInfo(QName targetAssocQName, ChildAssociationRef sourceParentAssoc) {
            this.targetAssocQName = targetAssocQName;
            this.sourceParentAssoc = sourceParentAssoc;
        }

        public QName getTargetAssocQName() {
            return this.targetAssocQName;
        }

        public ChildAssociationRef getSourceParentAssoc() {
            return this.sourceParentAssoc;
        }
    }
}

