/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.util.Date;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPAuthenticationComponentImpl;
import org.alfresco.repo.security.sync.ChainingUserRegistrySynchronizerStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Monitor {
    LDAPAuthenticationComponentImpl component;
    ChainingUserRegistrySynchronizerStatus syncMonitor;
    String id;
    private static Log logger = LogFactory.getLog(Monitor.class);

    public void setLDAPAuthenticationComponent(LDAPAuthenticationComponentImpl component) {
        this.component = component;
    }

    public void setChainingUserRegistrySynchronizerStatus(ChainingUserRegistrySynchronizerStatus syncStatus) {
        this.syncMonitor = syncStatus;
    }

    /*
     * Unable to fully structure code
     */
    public CompositeData testAuthenticate(String userName, String credentials) {
        stepKeys = new String[]{"id", "stepMessage", "success"};
        stepDescriptions = new String[]{"id", "stepMessage", "success"};
        stepTypes = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.BOOLEAN};
        try {
            block5: {
                key = new String[]{"id"};
                sType = new CompositeType("Authentication Step", "Step", stepKeys, stepDescriptions, stepTypes);
                tType = new TabularType("Diagnostic", "Authentication Steps", sType, key);
                table = new TabularDataSupport(tType);
                attributeKeys = new String[]{"authenticationMessage", "success", "diagnostic"};
                attributeDescriptions = new String[]{"authenticationMessage", "success", "diagnostic"};
                attributeTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, tType};
                try {
                    this.component.authenticate(userName, credentials.toCharArray());
                    cType = new CompositeType("Authentication Result", "Result Success", attributeKeys, attributeDescriptions, attributeTypes);
                    value = new HashMap<String, Object>();
                    value.put("authenticationMessage", "Test Passed");
                    value.put("success", true);
                    value.put("diagnostic", table);
                    row = new CompositeDataSupport(cType, value);
                    return row;
                }
                catch (AuthenticationException ae) {
                    cType = new CompositeType("Authentication Result", "Result Failed", attributeKeys, attributeDescriptions, attributeTypes);
                    value = new HashMap<String, Object>();
                    value.put("authenticationMessage", ae.getMessage());
                    value.put("success", false);
                    if (ae.getDiagnostic() == null) break block5;
                    i = 0;
                    ** for (step : ae.getDiagnostic().getSteps())
                }
lbl-1000:
                // 1 sources

                {
                    x = new HashMap<String, Object>();
                    x.put("id", i++);
                    x.put("stepMessage", step.getMessage());
                    x.put("success", step.isSuccess());
                    row = new CompositeDataSupport(sType, x);
                    table.put(row);
                    continue;
                }
            }
            value.put("diagnostic", table);
            row = new CompositeDataSupport(cType, value);
            return row;
        }
        catch (OpenDataException oe) {
            Monitor.logger.error((Object)"", (Throwable)oe);
            return null;
        }
    }

    public int getNumberFailedAuthentications() {
        return this.component.getNumberFailedAuthentications();
    }

    public int getNumberSuccessfulAuthentications() {
        return this.component.getNumberSuccessfulAuthentications();
    }

    public String getSynchronizationStatus() {
        return this.syncMonitor.getSynchronizationStatus(this.getZone(this.component.getId()));
    }

    public String getSynchronizationLastError() {
        return this.syncMonitor.getSynchronizationLastError(this.getZone(this.component.getId()));
    }

    public String getSynchronizationSummary() {
        return this.syncMonitor.getSynchronizationSummary(this.getZone(this.component.getId()));
    }

    public String getLastRunOnServer() {
        return this.syncMonitor.getLastRunOnServer();
    }

    public Date getSyncStartTime() {
        return this.syncMonitor.getSyncStartTime();
    }

    public Date getSyncEndTime() {
        return this.syncMonitor.getSyncEndTime();
    }

    private String getZone(String id) {
        String s = id.replace("[", "");
        String s2 = s.replace("]", "");
        String[] ids = s2.split(",");
        String x = ids[ids.length - 1].trim();
        return x;
    }
}

