/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import java.util.Optional;
import java.util.Set;
import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.serviceaccount.ServiceAccountRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

public class ServiceAccountAuthority
implements DynamicAuthority,
InitializingBean {
    private String authority;
    private ServiceAccountRegistry serviceAccountRegistry;

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setServiceAccountRegistry(ServiceAccountRegistry serviceAccountRegistry) {
        this.serviceAccountRegistry = serviceAccountRegistry;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"authority", (Object)this.authority);
        PropertyCheck.mandatory((Object)this, (String)"serviceAccountRegistry", (Object)this.serviceAccountRegistry);
    }

    @Override
    public boolean hasAuthority(NodeRef nodeRef, String userName) {
        Optional<String> role = this.serviceAccountRegistry.getServiceAccountRole(userName);
        return role.isPresent() && role.get().equals(this.getAuthority());
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public Set<PermissionReference> requiredFor() {
        return null;
    }
}

