/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import jakarta.transaction.RollbackException;
import jakarta.transaction.UserTransaction;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.dialect.Dialect;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.PropertyMap;
import org.junit.Before;
import org.junit.Test;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionServiceImplTest
extends BaseSpringTest {
    private PlatformTransactionManager transactionManager;
    private TransactionServiceImpl transactionService;
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private final QName vetoName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"TransactionServiceImplTest");
    private static final String USER_ALFRESCO = "AlfrescoUser";
    private Dialect dialect;

    @Before
    public void setUp() throws Exception {
        this.transactionManager = (PlatformTransactionManager)this.applicationContext.getBean("transactionManager");
        this.transactionService = new TransactionServiceImpl();
        this.transactionService.setTransactionManager(this.transactionManager);
        this.transactionService.setAllowWrite(true, this.vetoName);
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.dialect = (Dialect)this.applicationContext.getBean("dialect");
    }

    @Test
    public void testPropagatingTxn() throws Exception {
        UserTransaction txnOuter = this.transactionService.getUserTransaction();
        txnOuter.begin();
        String txnIdOuter = AlfrescoTransactionSupport.getTransactionId();
        UserTransaction txnInner = this.transactionService.getUserTransaction();
        txnInner.begin();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        TransactionServiceImplTest.assertEquals((String)"Txn ID not propagated", (String)txnIdOuter, (String)txnIdInner);
        txnInner.rollback();
        TransactionServiceImplTest.assertEquals((String)"Inner txn not marked rolled back", (int)4, (int)txnInner.getStatus());
        TransactionServiceImplTest.assertEquals((String)"Outer txn not marked for rolled back", (int)1, (int)txnOuter.getStatus());
        try {
            txnOuter.commit();
            TransactionServiceImplTest.fail((String)"Outer txn not marked for rollback");
        }
        catch (RollbackException rollbackException) {
            txnOuter.rollback();
        }
    }

    @Test
    public void testNonPropagatingTxn() throws Exception {
        UserTransaction txnOuter = this.transactionService.getUserTransaction();
        txnOuter.begin();
        String txnIdOuter = AlfrescoTransactionSupport.getTransactionId();
        UserTransaction txnInner = this.transactionService.getNonPropagatingUserTransaction();
        txnInner.begin();
        String txnIdInner = AlfrescoTransactionSupport.getTransactionId();
        TransactionServiceImplTest.assertNotSame((String)"Txn ID not propagated", (Object)txnIdOuter, (Object)txnIdInner);
        txnInner.rollback();
        txnOuter.commit();
    }

    /*
     * Exception decompiling
     */
    @Test
    public void testReadOnlyTxn() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testReadOnlyVetoTxn() throws Exception {
        QName v1 = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"V1");
        QName v2 = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"V2");
        QName v3 = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"V2");
        try {
            this.transactionService.setAllowWrite(false, v1);
            this.transactionService.setAllowWrite(false, v2);
            TransactionServiceImplTest.assertFalse((String)"v1 AND v2 veto not read only", (boolean)this.transactionService.getAllowWrite());
            this.transactionService.setAllowWrite(true, v2);
            TransactionServiceImplTest.assertFalse((String)"v1 not read only", (boolean)this.transactionService.getAllowWrite());
            this.transactionService.setAllowWrite(true, v1);
            TransactionServiceImplTest.assertTrue((String)"v1 still read only", (boolean)this.transactionService.getAllowWrite());
            this.transactionService.setAllowWrite(true, v3);
            TransactionServiceImplTest.assertTrue((String)"v3 veto", (boolean)this.transactionService.getAllowWrite());
        }
        finally {
            this.transactionService.setAllowWrite(true, v1);
            this.transactionService.setAllowWrite(true, v2);
            this.transactionService.setAllowWrite(true, v3);
        }
    }

    @Test
    public void testGetRetryingTransactionHelper() {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                return null;
            }
        };
        TransactionServiceImplTest.assertFalse((String)"Retriers must be new instances", (this.transactionService.getRetryingTransactionHelper() == this.transactionService.getRetryingTransactionHelper() ? 1 : 0) != 0);
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        TransactionServiceImplTest.assertFalse((String)"Retriers must be new instance when retrieved from ServiceRegistry", (serviceRegistry.getRetryingTransactionHelper() == serviceRegistry.getRetryingTransactionHelper() ? 1 : 0) != 0);
        this.transactionService.setAllowWrite(true, this.vetoName);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false);
        this.transactionService.setAllowWrite(false, this.vetoName);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false);
            TransactionServiceImplTest.fail((String)"Expected AccessDeniedException when starting to write to a read-only transaction service.");
        }
        catch (AccessDeniedException accessDeniedException) {}
        RetryingTransactionHelper helper = this.transactionService.getRetryingTransactionHelper();
        helper.setForceWritable(true);
        helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, true);
        helper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false);
        this.transactionService.setAllowWrite(true, this.vetoName);
    }

    private void createUser(String userName) {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"First");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"Last");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void testSystemUserHasWritePermissionsInReadOnlyMode() {
        this.createUser(USER_ALFRESCO);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_ALFRESCO);
        this.transactionService.setAllowWrite(false, this.vetoName);
        try {
            Boolean isReadOnly = (Boolean)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Boolean>(){

                public Boolean doWork() throws Exception {
                    return TransactionServiceImplTest.this.transactionService.isReadOnly();
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            TransactionServiceImplTest.assertFalse((String)"SystemUser must has write permissions in read-only mode", (boolean)isReadOnly);
        }
        finally {
            this.transactionService.setAllowWrite(true, this.vetoName);
            AuthenticationUtil.clearCurrentSecurityContext();
        }
    }
}

