/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.alfresco.repo.admin.patch.impl.SchemaUpgradeScriptPatch;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Category(value={OwnJVMTestsCategory.class})
public class SchemaBootstrapTest {
    private static final String BOOTSTRAP_TEST_CONTEXT = "classpath*:alfresco/dbscripts/bootstrap-context-test.xml";
    private static final String MAIN_SCHEMA_REFERENCE_FILE = "classpath:alfresco/dbscripts/create/org.alfresco.repo.domain.dialect.PostgreSQLDialect/Schema-Reference-ALF.xml";
    private static final String TEST_SCHEMA_REFERENCE_FILE = "classpath:alfresco/dbscripts/create/org.alfresco.repo.domain.dialect.PostgreSQLDialect/Test-Schema-Reference-ALF.xml";
    private static final List<String> TEST_SCHEMA_REFERENCE_URLS = Arrays.asList("classpath:alfresco/dbscripts/create/org.alfresco.repo.domain.dialect.PostgreSQLDialect/Test-Schema-Reference-ALF.xml", "classpath:alfresco/dbscripts/create/org.alfresco.repo.domain.dialect.PostgreSQLDialect/Schema-Reference-ACT.xml");
    private static ApplicationContextInit APP_CONTEXT_INIT = ApplicationContextInit.createStandardContextWithOverrides("classpath*:alfresco/dbscripts/bootstrap-context-test.xml");
    @ClassRule
    public static RuleChain staticRuleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT);
    private SchemaBootstrap schemaBootstrap;
    private SchemaUpgradeScriptPatch optionalPatch;

    @BeforeClass
    public static void beforeClass() throws Exception {
        PathMatchingResourcePatternResolver rpr = new PathMatchingResourcePatternResolver(SchemaBootstrapTest.class.getClassLoader());
        Document schemaRefXML = SchemaBootstrapTest.loadXML(rpr.getResource(MAIN_SCHEMA_REFERENCE_FILE));
        Node indexes = SchemaBootstrapTest.getIndexesNode(schemaRefXML);
        indexes.appendChild(SchemaBootstrapTest.createTestIndex(schemaRefXML));
        Resource testSchemaRef = rpr.getResource(TEST_SCHEMA_REFERENCE_FILE);
        SchemaBootstrapTest.updateTestSchemaReferenceFile(testSchemaRef, schemaRefXML);
    }

    @Before
    public void setUp() throws Exception {
        this.schemaBootstrap = (SchemaBootstrap)APP_CONTEXT_INIT.getApplicationContext().getBean("schemaBootstrap");
        this.schemaBootstrap.setSchemaReferenceUrls(TEST_SCHEMA_REFERENCE_URLS);
        this.optionalPatch = (SchemaUpgradeScriptPatch)APP_CONTEXT_INIT.getApplicationContext().getBean("patchDbVOAddIndexTest");
    }

    @Test
    public void shouldSchemaValidationReportProblemsCausedByUnappliedOptionalPatch() {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(buff);
        int numProblems = this.schemaBootstrap.validateSchema(null, out);
        out.flush();
        String problems = buff.toString();
        Assert.assertEquals((String)("Expected 1 problem; but these problems were found instead: \n" + problems + "\n"), (long)1L, (long)numProblems);
        Assert.assertTrue((String)("Missing optional patch-specific problems report: \n" + problems), (boolean)problems.contains("The following problems will be resolved once the long running patch " + this.optionalPatch.getId() + " has been run"));
    }

    private static void updateTestSchemaReferenceFile(Resource testSchemaRef, Document newDoc) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StreamResult result = new StreamResult(testSchemaRef.getFile());
        DOMSource source = new DOMSource(newDoc);
        transformer.transform(source, result);
    }

    private static Element createTestIndex(Document document) {
        Element testIndex = document.createElement("index");
        testIndex.setAttribute("name", "idx_alf_node_test");
        testIndex.setAttribute("unique", "false");
        Element columnNames = document.createElement("columnnames");
        for (String colName : Arrays.asList("acl_id", "audit_creator")) {
            Element columnName = document.createElement("columnname");
            columnName.setNodeValue(colName);
            columnNames.appendChild(columnName);
        }
        testIndex.appendChild(columnNames);
        return testIndex;
    }

    private static Node getIndexesNode(Document document) throws XPathExpressionException {
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile("/schema/objects/table[@name='alf_node']/indexes");
        Node indexes = (Node)expr.evaluate(document, XPathConstants.NODE);
        return indexes;
    }

    private static Document loadXML(Resource resource) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(resource.getInputStream());
    }
}

