/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.locks;

import org.alfresco.util.EqualsHelper;

public class LockEntity {
    public static final Long CONST_LONG_ZERO = 0L;
    private Long id;
    private Long version;
    private Long sharedResourceId;
    private Long exclusiveResourceId;
    private String lockToken;
    private Long startTime;
    private Long expiryTime = Long.MIN_VALUE;

    public int hashCode() {
        return (this.sharedResourceId == null ? 0 : this.sharedResourceId.hashCode()) + (this.exclusiveResourceId == null ? 0 : this.exclusiveResourceId.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LockEntity) {
            LockEntity that = (LockEntity)obj;
            return EqualsHelper.nullSafeEquals((Object)this.sharedResourceId, (Object)that.sharedResourceId) && EqualsHelper.nullSafeEquals((Object)this.exclusiveResourceId, (Object)that.exclusiveResourceId);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append("LockEntity").append("[ ID=").append(this.id).append(", sharedResourceId=").append(this.sharedResourceId).append(", exclusiveResourceId=").append(this.exclusiveResourceId).append("]");
        return sb.toString();
    }

    public boolean isExclusive() {
        if (this.sharedResourceId == null || this.exclusiveResourceId == null) {
            throw new IllegalStateException("LockEntity has not been populated");
        }
        return this.sharedResourceId.equals(this.exclusiveResourceId);
    }

    public boolean hasExpired() {
        return System.currentTimeMillis() > this.expiryTime;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public void incrementVersion() {
        long currentVersion = this.version;
        this.version = (double)currentVersion >= 1.0E7 ? CONST_LONG_ZERO : Long.valueOf(this.version + 1L);
    }

    public Long getSharedResourceId() {
        return this.sharedResourceId;
    }

    public void setSharedResourceId(Long sharedResourceId) {
        this.sharedResourceId = sharedResourceId;
    }

    public Long getExclusiveResourceId() {
        return this.exclusiveResourceId;
    }

    public void setExclusiveResourceId(Long exclusiveResourceId) {
        this.exclusiveResourceId = exclusiveResourceId;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public Long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(Long expiryTime) {
        this.expiryTime = expiryTime;
    }
}

