/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.permissions.Authority;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodePermissionAssessor {
    protected static final Log logger = LogFactory.getLog(NodePermissionAssessor.class);
    private final boolean isSystemReading;
    private final boolean isAdminReading;
    private final boolean isNullReading;
    private final Authority authority;
    private final Map<Long, Boolean> aclReadCache = new HashMap<Long, Boolean>();
    private int checksPerformed;
    private long startTime;
    private int maxPermissionChecks;
    private long maxPermissionCheckTimeMillis;
    private EntityLookupCache<Long, Node, NodeRef> nodesCache;
    private NodeService nodeService;
    private PermissionService permissionService;

    public NodePermissionAssessor(NodeService nodeService, PermissionService permissionService, Authority authority, EntityLookupCache<Long, Node, NodeRef> nodeCache) {
        this.permissionService = permissionService;
        this.nodesCache = nodeCache;
        this.nodeService = nodeService;
        this.checksPerformed = 0;
        this.maxPermissionChecks = Integer.MAX_VALUE;
        this.maxPermissionCheckTimeMillis = Long.MAX_VALUE;
        Set authorisations = permissionService.getAuthorisations();
        this.isSystemReading = AuthenticationUtil.isRunAsUserTheSystemUser();
        this.isAdminReading = authorisations.contains(AuthenticationUtil.getAdminRoleName());
        this.isNullReading = AuthenticationUtil.getRunAsUser() == null;
        this.authority = authority;
    }

    public boolean isIncluded(Node node) {
        if (this.isFirstRecord()) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.checksPerformed;
        return this.isReallyIncluded(node);
    }

    public boolean isFirstRecord() {
        return this.checksPerformed == 0;
    }

    protected boolean isOwnerReading(Node node, Authority authority) {
        if (authority == null) {
            return false;
        }
        String owner = this.getOwner(node);
        return EqualsHelper.nullSafeEquals((Object)authority.getAuthority(), (Object)owner);
    }

    private String getOwner(Node node) {
        this.nodesCache.setValue(node.getId(), node);
        Set nodeAspects = this.nodeService.getAspects(node.getNodeRef());
        String userName = null;
        if (nodeAspects.contains(ContentModel.ASPECT_OWNABLE)) {
            Serializable owner = this.nodeService.getProperty(node.getNodeRef(), ContentModel.PROP_OWNER);
            userName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)owner);
        } else if (nodeAspects.contains(ContentModel.ASPECT_AUDITABLE)) {
            userName = node.getAuditableProperties().getAuditCreator();
        }
        return userName;
    }

    boolean isReallyIncluded(Node node) {
        if (this.isNullReading) {
            return false;
        }
        return this.isSystemReading || this.isAdminReading || this.canRead(node.getAclId()) || this.isOwnerReading(node, this.authority);
    }

    public void setMaxPermissionChecks(int maxPermissionChecks) {
        this.maxPermissionChecks = maxPermissionChecks == Integer.MAX_VALUE ? maxPermissionChecks : maxPermissionChecks + 1;
    }

    public boolean shouldQuitChecks() {
        if (this.checksPerformed >= this.maxPermissionChecks) {
            logger.warn((Object)("Maximum permission checks exceeded (" + this.maxPermissionChecks + ")"));
            return true;
        }
        if (System.currentTimeMillis() - this.startTime >= this.maxPermissionCheckTimeMillis) {
            logger.warn((Object)("Maximum permission checks time exceeded (" + this.maxPermissionCheckTimeMillis + ")"));
            return true;
        }
        return false;
    }

    public void setMaxPermissionCheckTimeMillis(long maxPermissionCheckTimeMillis) {
        this.maxPermissionCheckTimeMillis = maxPermissionCheckTimeMillis;
    }

    protected boolean canRead(Long aclId) {
        Boolean res = this.aclReadCache.get(aclId);
        if (res == null) {
            res = this.canCurrentUserRead(aclId);
            this.aclReadCache.put(aclId, res);
        }
        return res;
    }

    protected boolean canCurrentUserRead(Long aclId) {
        Set authorities = this.permissionService.getAuthorisations();
        Set aclReadersDenied = this.permissionService.getReadersDenied(aclId);
        for (String auth : aclReadersDenied) {
            if (!authorities.contains(auth)) continue;
            return false;
        }
        Set aclReaders = this.permissionService.getReaders(aclId);
        for (String auth : aclReaders) {
            if (!authorities.contains(auth)) continue;
            return true;
        }
        return false;
    }
}

