/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr.facet;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.alfresco.repo.search.impl.solr.facet.FacetQNameUtils;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class FacetQNameUtilsTest {
    private final NamespacePrefixResolver resolver = new NamespacePrefixResolver(){
        private final List<String> uris = Arrays.asList("http://www.alfresco.org/model/foo/1.0");
        private final List<String> prefixes = Arrays.asList("foo");

        public Collection<String> getURIs() {
            return this.uris;
        }

        public Collection<String> getPrefixes() {
            return this.prefixes;
        }

        public Collection<String> getPrefixes(String namespaceURI) throws NamespaceException {
            if (this.uris.contains(namespaceURI)) {
                return this.prefixes;
            }
            throw new NamespaceException("Unrecognised namespace: " + namespaceURI);
        }

        public String getNamespaceURI(String prefix) throws NamespaceException {
            if (this.prefixes.contains(prefix)) {
                return "http://www.alfresco.org/model/foo/1.0";
            }
            throw new NamespaceException("Unrecognised prefix: " + prefix);
        }
    };

    @Test
    public void canCreateFromShortForm() throws Exception {
        Assert.assertEquals((Object)QName.createQName((String)"http://www.alfresco.org/model/foo/1.0", (String)"localName"), (Object)FacetQNameUtils.createQName((String)"foo:localName", (NamespacePrefixResolver)this.resolver));
    }

    @Test
    public void canCreateFromLongForm() throws Exception {
        Assert.assertEquals((Object)QName.createQName((String)"http://www.alfresco.org/model/foo/1.0", (String)"localName"), (Object)FacetQNameUtils.createQName((String)"{http://www.alfresco.org/model/foo/1.0}localName", (NamespacePrefixResolver)this.resolver));
    }

    @Test
    public void canCreateFromShortFormWithNoPrefix() throws Exception {
        Assert.assertEquals((Object)QName.createQName(null, (String)"localName"), (Object)FacetQNameUtils.createQName((String)"localName", (NamespacePrefixResolver)this.resolver));
    }

    @Test
    public void canCreateFromLongFormWithNoPrefix() throws Exception {
        Assert.assertEquals((Object)QName.createQName(null, (String)"localName"), (Object)FacetQNameUtils.createQName((String)"{}localName", (NamespacePrefixResolver)this.resolver));
    }

    @Test
    public void canCreateLongFormQnameWithUnrecognisedUri() throws Exception {
        Assert.assertEquals((Object)QName.createQName((String)"http://www.alfresco.org/model/illegal/1.0", (String)"localName"), (Object)FacetQNameUtils.createQName((String)"{http://www.alfresco.org/model/illegal/1.0}localName", (NamespacePrefixResolver)this.resolver));
    }

    @Test(expected=NamespaceException.class)
    public void shortFormQnameWithUnrecognisedPrefixFails() throws Exception {
        FacetQNameUtils.createQName((String)"illegal:localName", (NamespacePrefixResolver)this.resolver);
    }
}

