/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.alfresco.util.exec.RuntimeExec;

public class JmxDumpUtil {
    private static final String NAME_HEADER = "Attribute Name";
    private static final String VALUE_HEADER = "Attribute Value";
    private static final String NULL_VALUE = "<null>";
    public static final String PROTECTED_VALUE = "********";
    private static final String OS_NAME = "os.name";
    private static final String INPUT_ARGUMENTS = "InputArguments";
    private static final String[] REDACTED_INPUTS = new String[]{"password", "token", "pwd"};

    public static void dumpConnection(MBeanServerConnection connection, PrintWriter out) throws IOException {
        JmxDumpUtil.showStartBanner(out);
        Set<ObjectName> objectNames = connection.queryNames(null, null);
        TreeSet<ObjectName> newObjectNames = new TreeSet<ObjectName>(new Comparator<ObjectName>(){

            @Override
            public int compare(ObjectName o1, ObjectName o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        newObjectNames.addAll(objectNames);
        objectNames = newObjectNames;
        for (ObjectName objectName : objectNames) {
            try {
                JmxDumpUtil.printMBeanInfo(connection, objectName, out);
            }
            catch (JMException jMException) {}
        }
    }

    private static void printMBeanInfo(MBeanServerConnection connection, ObjectName objectName, PrintWriter out) throws IOException, JMException {
        String[] commandInputs;
        String osName;
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        MBeanInfo info = connection.getMBeanInfo(objectName);
        attributes.put("** Object Name", objectName.toString());
        attributes.put("** Object Type", info.getClassName());
        MBeanAttributeInfo[] mBeanAttributeInfoArray = info.getAttributes();
        int n = mBeanAttributeInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value;
            MBeanAttributeInfo element = mBeanAttributeInfoArray[n2];
            if (element.isReadable()) {
                try {
                    value = connection.getAttribute(objectName, element.getName());
                }
                catch (Exception exception) {
                    value = PROTECTED_VALUE;
                }
            } else {
                value = PROTECTED_VALUE;
            }
            attributes.put(element.getName(), value);
            ++n2;
        }
        if (objectName.getCanonicalName().equals("Alfresco:Name=SystemProperties") && (osName = (String)attributes.get(OS_NAME)) != null && osName.toLowerCase().startsWith("linux")) {
            attributes.put(OS_NAME, JmxDumpUtil.updateOSNameAttributeForLinux(osName));
        }
        if (objectName.getCanonicalName().equals("java.lang:type=Runtime") && (commandInputs = (String[])attributes.get(INPUT_ARGUMENTS)) != null) {
            try {
                attributes.put(INPUT_ARGUMENTS, JmxDumpUtil.cleanPasswordsFromInputArguments(commandInputs, REDACTED_INPUTS));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                attributes.put(INPUT_ARGUMENTS, commandInputs);
            }
        }
        JmxDumpUtil.tabulate(NAME_HEADER, VALUE_HEADER, attributes, out, 0);
    }

    static String[] cleanPasswordsFromInputArguments(String[] commandInputs, String[] redactedInputs) {
        Pattern passwordRedactPattern = Pattern.compile(JmxDumpUtil.createPasswordFindRegexString(redactedInputs));
        ArrayList<String> cleanInputs = new ArrayList<String>();
        String[] stringArray = commandInputs;
        int n = commandInputs.length;
        int n2 = 0;
        while (n2 < n) {
            String input = stringArray[n2];
            input = JmxDumpUtil.cleanPasswordFromInputArgument(input, passwordRedactPattern);
            cleanInputs.add(input);
            ++n2;
        }
        return cleanInputs.toArray(new String[commandInputs.length]);
    }

    static String cleanPasswordFromInputArgument(String input, Pattern redactedInputPattern) {
        String output = redactedInputPattern.matcher(input).replaceAll("$1********");
        return output;
    }

    static String createPasswordFindRegexString(String[] argEndings) throws IllegalArgumentException {
        if (argEndings.length < 1) {
            IllegalArgumentException e = new IllegalArgumentException("Arguments are required");
            throw e;
        }
        StringJoiner argJoiner = new StringJoiner("|");
        String[] stringArray = argEndings;
        int n = argEndings.length;
        int n2 = 0;
        while (n2 < n) {
            String argEnding = stringArray[n2];
            argJoiner.add(JmxDumpUtil.escapeRegexMetaChars(argEnding) + "=");
            ++n2;
        }
        String regex = String.format("%s%s%s%s%s", "(?i)(.*(", argJoiner.toString(), "))((?<=", argJoiner.toString(), ").*+)");
        return regex;
    }

    static String escapeRegexMetaChars(String input) {
        String pattern = "(\\||\\?|\\*|\\+|\\.)";
        String output = input.replaceAll(pattern, "\\\\$1");
        return output;
    }

    public static String updateOSNameAttributeForLinux(String osName) {
        RuntimeExec exec = new RuntimeExec();
        HashMap<String, String[]> commandMap = new HashMap<String, String[]>(3, 1.0f);
        commandMap.put("Linux", new String[]{"lsb_release", "-d"});
        exec.setCommandsAndArguments(commandMap);
        RuntimeExec.ExecutionResult ret = exec.execute();
        if (ret.getSuccess()) {
            osName = (String)osName + " (" + ret.getStdOut().replace("\n", "") + ")";
        } else {
            commandMap.put("Linux", new String[]{"uname", "-a"});
            exec.setCommandsAndArguments(commandMap);
            ret = exec.execute();
            osName = ret.getSuccess() ? (String)osName + " (" + ret.getStdOut().replace("\n", "") + ")" : (String)osName + " (Unknown)";
        }
        return osName;
    }

    private static void printCompositeInfo(CompositeData composite, PrintWriter out, int nestLevel) throws IOException {
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        for (String key : composite.getCompositeType().keySet()) {
            Object value;
            try {
                value = composite.get(key);
            }
            catch (Exception exception) {
                value = PROTECTED_VALUE;
            }
            attributes.put(key, value);
        }
        JmxDumpUtil.tabulate(NAME_HEADER, VALUE_HEADER, attributes, out, nestLevel);
    }

    private static void tabulate(String keyHeader, String valueHeader, Map<String, Object> rows, PrintWriter out, int nestLevel) throws IOException {
        if (rows.isEmpty()) {
            return;
        }
        int maxKeyLength = keyHeader.length();
        int maxValLength = valueHeader.length();
        for (Map.Entry<String, Object> entry : rows.entrySet()) {
            maxKeyLength = Math.max(maxKeyLength, entry.getKey().length());
            maxValLength = Math.max(maxValLength, JmxDumpUtil.getValueLength(entry.getValue()));
        }
        JmxDumpUtil.outputRow(out, maxKeyLength, keyHeader, valueHeader, nestLevel);
        JmxDumpUtil.indent(out, nestLevel);
        int col = 0;
        while (col < maxKeyLength) {
            out.print('-');
            ++col;
        }
        out.print(' ');
        col = 0;
        while (col < maxValLength) {
            out.print('-');
            ++col;
        }
        out.println();
        for (Map.Entry<String, Object> entry : rows.entrySet()) {
            JmxDumpUtil.outputRow(out, maxKeyLength, entry.getKey(), entry.getValue(), nestLevel);
        }
        out.println();
    }

    private static void indent(PrintWriter out, int nestLevel) {
        int size = nestLevel * 3;
        int i = 0;
        while (i < size) {
            out.print(' ');
            ++i;
        }
    }

    private static void outputRow(PrintWriter out, int maxKeyLength, String key, Object value, int nestLevel) throws IOException {
        JmxDumpUtil.indent(out, nestLevel);
        out.print(key);
        int i = key.length() - 1;
        while (i < maxKeyLength) {
            out.print(' ');
            ++i;
        }
        JmxDumpUtil.outputValue(out, value, nestLevel);
    }

    private static void outputValue(PrintWriter out, Object value, int nestLevel) throws IOException {
        if (value == null) {
            out.println(NULL_VALUE);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            if (length == 0) {
                out.println("[]");
            } else {
                out.println();
                JmxDumpUtil.indent(out, nestLevel + 1);
                out.println('[');
                int i = 0;
                while (i < length) {
                    JmxDumpUtil.indent(out, nestLevel + 2);
                    JmxDumpUtil.outputValue(out, Array.get(value, i), nestLevel + 2);
                    if (i + 1 < length) {
                        JmxDumpUtil.indent(out, nestLevel + 1);
                        out.println(',');
                    }
                    ++i;
                }
                JmxDumpUtil.indent(out, nestLevel + 1);
                out.println(']');
            }
        } else if (value instanceof CompositeData) {
            out.println();
            JmxDumpUtil.indent(out, nestLevel + 1);
            out.println('[');
            JmxDumpUtil.printCompositeInfo((CompositeData)value, out, nestLevel + 2);
            JmxDumpUtil.indent(out, nestLevel + 1);
            out.println(']');
        } else {
            out.println(value.toString());
        }
    }

    private static int getValueLength(Object value) {
        if (value == null) {
            return NULL_VALUE.length();
        }
        if (value.getClass().isArray() || value instanceof CompositeData) {
            return 0;
        }
        return value.toString().length();
    }

    private static void showStartBanner(PrintWriter out) {
        DateFormat df = SimpleDateFormat.getDateTimeInstance(1, 1);
        out.println(JmxDumpUtil.class.getSimpleName() + " started: " + df.format(new Date()));
        out.println();
    }
}

