/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.virtual.VirtualContext;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;

public class AlfrescoScriptVirtualContext
extends BaseScopableProcessorExtension {
    public static final String CURRENT_USER_PH = "CURRENT_USER";
    public static final String ACTUAL_PATH_PH = "ACTUAL_PATH";
    public static final String ACTUAL_ISO9075_PATH_PH = "ACTUAL_ISO9075_PATH";
    private VirtualContext context;
    private ServiceRegistry serviceRegistry;
    private Map<String, String> placeholders;

    public AlfrescoScriptVirtualContext(VirtualContext context, ServiceRegistry serviceRegistry) {
        this.context = context;
        this.serviceRegistry = serviceRegistry;
        this.placeholders = this.createPlaceHolders();
    }

    private String[] createQNamePaths() {
        NamespaceService ns = this.serviceRegistry.getNamespaceService();
        HashMap<String, String> cache = new HashMap<String, String>();
        StringBuilder bufPlain = new StringBuilder(128);
        StringBuilder bufISO9075 = new StringBuilder(128);
        Path path = this.serviceRegistry.getNodeService().getPath(this.context.getActualNodeRef());
        for (Path.Element e : path) {
            if (e instanceof Path.ChildAssocElement) {
                QName qname = ((Path.ChildAssocElement)e).getRef().getQName();
                if (qname == null) continue;
                String prefix = (String)cache.get(qname.getNamespaceURI());
                if (prefix == null) {
                    Collection prefixes = ns.getPrefixes(qname.getNamespaceURI());
                    prefix = prefixes.size() != 0 ? (String)prefixes.iterator().next() : "";
                    cache.put(qname.getNamespaceURI(), prefix);
                }
                bufISO9075.append('/').append(prefix).append(':').append(ISO9075.encode((String)qname.getLocalName()));
                bufPlain.append('/').append(prefix).append(':').append(qname.getLocalName());
                continue;
            }
            bufISO9075.append('/').append(e.toString());
            bufPlain.append('/').append(e.toString());
        }
        String[] qnamePaths = new String[]{bufPlain.toString(), bufISO9075.toString()};
        return qnamePaths;
    }

    private Map<String, String> createPlaceHolders() {
        HashMap<String, String> newPlaceholders = new HashMap<String, String>();
        String user = AuthenticationUtil.getFullyAuthenticatedUser();
        newPlaceholders.put(CURRENT_USER_PH, user);
        String[] paths = this.createQNamePaths();
        newPlaceholders.put(ACTUAL_PATH_PH, paths[1]);
        return newPlaceholders;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public synchronized ScriptNode getActualNode() {
        return new ScriptNode(this.context.getActualNodeRef(), this.serviceRegistry, this.getScope());
    }

    public Object getParameter(String param) {
        return this.context.getParameter(param);
    }
}

