/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.template.ClassPathRepoTemplateLoader;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class EmailHelper {
    private static final Log LOGGER = LogFactory.getLog(EmailHelper.class);
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private FileFolderService fileFolderService;
    private PersonService personService;
    private PreferenceService preferenceService;
    private Repository repositoryHelper;
    private TemplateLoader templateLoader;
    private String companyHomeChildName;

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setPreferenceService(PreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public void setCompanyHomeChildName(String companyHomeChildName) {
        this.companyHomeChildName = companyHomeChildName;
    }

    public void init() {
        PropertyCheck.mandatory((Object)this, (String)"serviceRegistry", (Object)this.serviceRegistry);
        PropertyCheck.mandatory((Object)this, (String)"preferenceService", (Object)this.preferenceService);
        PropertyCheck.mandatory((Object)this, (String)"repositoryHelper", (Object)this.repositoryHelper);
        PropertyCheck.mandatory((Object)this, (String)"companyHomeChildName", (Object)this.companyHomeChildName);
        this.nodeService = this.serviceRegistry.getNodeService();
        this.searchService = this.serviceRegistry.getSearchService();
        this.namespaceService = this.serviceRegistry.getNamespaceService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        this.personService = this.serviceRegistry.getPersonService();
        this.setTemplateLoader(new ClassPathRepoTemplateLoader(this.nodeService, this.serviceRegistry.getContentService(), "utf-8"));
    }

    public String getEmailTemplate(String clientName, String emailTemplatePath, String fallbackTemplatePath) {
        if (StringUtils.isEmpty((CharSequence)emailTemplatePath)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("No email template path is set for client [" + clientName + "]. The fallback template will be used: " + fallbackTemplatePath));
            }
            return fallbackTemplatePath;
        }
        if (emailTemplatePath.startsWith("/")) {
            emailTemplatePath = emailTemplatePath.substring(1);
        }
        if (emailTemplatePath.startsWith(this.companyHomeChildName)) {
            NodeRef nodeRef = this.getLocalizedEmailTemplateNodeRef(emailTemplatePath);
            if (nodeRef == null) {
                LOGGER.warn((Object)("Couldn't find email template with the XPath [" + emailTemplatePath + "] for client [" + clientName + "]. The fallback template will be used: " + fallbackTemplatePath));
                return fallbackTemplatePath;
            }
            return nodeRef.toString();
        }
        if (NodeRef.isNodeRef((String)emailTemplatePath)) {
            NodeRef ref = new NodeRef(emailTemplatePath);
            if (!this.nodeService.exists(ref)) {
                LOGGER.warn((Object)("Couldn't find email template with the NodeRef [" + String.valueOf(ref) + "] for client [" + clientName + "]. The fallback template will be used: " + fallbackTemplatePath));
                return fallbackTemplatePath;
            }
            return emailTemplatePath;
        }
        try {
            Object template = this.templateLoader.findTemplateSource(emailTemplatePath);
            if (template != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Using email template with class path [" + emailTemplatePath + "] for client: " + clientName));
                }
                return emailTemplatePath;
            }
            LOGGER.warn((Object)("Couldn't find email template with class path [" + emailTemplatePath + "] for client [" + clientName + "]. The fallback template will be used: " + fallbackTemplatePath));
        }
        catch (IOException ex) {
            LOGGER.error((Object)("Error occurred while finding the email template with the class path [" + emailTemplatePath + "] for client [" + clientName + "]. The fallback template will be used: " + fallbackTemplatePath), (Throwable)ex);
        }
        return fallbackTemplatePath;
    }

    public NodeRef getLocalizedEmailTemplateNodeRef(String emailTemplateXPath) {
        if (StringUtils.isEmpty((CharSequence)emailTemplateXPath)) {
            return null;
        }
        List nodeRefs = this.searchService.selectNodes(this.repositoryHelper.getRootHome(), emailTemplateXPath, null, (NamespacePrefixResolver)this.namespaceService, false);
        if (nodeRefs.isEmpty()) {
            return null;
        }
        NodeRef nodeRef = (NodeRef)nodeRefs.get(0);
        if (nodeRefs.size() > 1) {
            LOGGER.error((Object)("Found too many email templates using XPath [" + emailTemplateXPath + "]. The first element will be used: " + String.valueOf(nodeRef)));
        }
        return this.fileFolderService.getLocalizedSibling(nodeRef);
    }

    public Locale getUserLocaleOrDefault(String userId) {
        String localeString;
        if (userId != null && this.personService.personExists(userId) && (localeString = (String)AuthenticationUtil.runAsSystem(() -> (String)((Object)this.preferenceService.getPreference(userId, "locale")))) != null) {
            return I18NUtil.parseLocale((String)localeString);
        }
        return I18NUtil.getLocale();
    }
}

