/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.event2;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.event.v1.model.EventData;
import org.alfresco.repo.event.v1.model.EventType;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;
import org.alfresco.repo.event2.AbstractContextAwareRepoEvent;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.junit.Test;

public class DeleteRepoEventIT
extends AbstractContextAwareRepoEvent {
    @Test
    public void testDeleteContent() {
        String localName = GUID.generate();
        PropertyMap propertyMap = new PropertyMap();
        propertyMap.put((Object)ContentModel.PROP_TITLE, (Object)"test title");
        MLText localizedDescription = new MLText(this.germanLocale, "german description");
        localizedDescription.addValue(this.defaultLocale, "default description");
        propertyMap.put((Object)ContentModel.PROP_DESCRIPTION, (Object)localizedDescription);
        NodeRef nodeRef = this.createNode(ContentModel.TYPE_CONTENT, localName, propertyMap);
        NodeResource createdResource = this.getNodeResource(1);
        DeleteRepoEventIT.assertNotNull((String)"Resource ID is null", (Object)createdResource.getId());
        DeleteRepoEventIT.assertNotNull((String)"Default aspects were not added. ", (Object)createdResource.getAspectNames());
        DeleteRepoEventIT.assertNotNull((String)"Missing createdByUser property.", (Object)createdResource.getCreatedByUser());
        DeleteRepoEventIT.assertNotNull((String)"Missing createdAt property.", (Object)createdResource.getCreatedAt());
        DeleteRepoEventIT.assertNotNull((String)"Missing modifiedByUser property.", (Object)createdResource.getModifiedByUser());
        DeleteRepoEventIT.assertNotNull((String)"Missing modifiedAt property.", (Object)createdResource.getModifiedAt());
        DeleteRepoEventIT.assertNotNull((String)"Missing node resource properties", (Object)createdResource.getProperties());
        this.deleteNode(nodeRef);
        RepoEvent resultRepoEvent = this.getRepoEvent(2);
        NodeResource nodeResource = this.getNodeResource(resultRepoEvent);
        DeleteRepoEventIT.assertEquals((String)"Repo event type:", (String)EventType.NODE_DELETED.getType(), (String)resultRepoEvent.getType());
        DeleteRepoEventIT.assertEquals((String)createdResource.getId(), (String)nodeResource.getId());
        DeleteRepoEventIT.assertEquals((String)"Wrong primaryAssocQName prefix.", (String)("ce:" + localName), (String)createdResource.getPrimaryAssocQName());
        DeleteRepoEventIT.assertEquals((String)"test title", (String)((String)this.getProperty(nodeResource, "cm:title")));
        DeleteRepoEventIT.assertEquals((String)"test title", (String)this.getLocalizedProperty(nodeResource, "cm:title", this.defaultLocale));
        DeleteRepoEventIT.assertEquals((String)"default description", (String)((String)this.getProperty(nodeResource, "cm:description")));
        DeleteRepoEventIT.assertEquals((String)"default description", (String)this.getLocalizedProperty(nodeResource, "cm:description", this.defaultLocale));
        DeleteRepoEventIT.assertEquals((String)"german description", (String)this.getLocalizedProperty(nodeResource, "cm:description", this.germanLocale));
        EventData eventData = (EventData)this.getEventData(resultRepoEvent);
        DeleteRepoEventIT.assertNull((String)"There should be no 'resourceBefore' object for the Deleted event type.", (Object)eventData.getResourceBefore());
    }

    @Test
    public void testDeleteFolderWithContent() {
        NodeRef grandParent = this.createNode(ContentModel.TYPE_FOLDER);
        NodeRef parent = this.createNode(ContentModel.TYPE_FOLDER, grandParent);
        this.createNode(ContentModel.TYPE_CONTENT, parent);
        this.createNode(ContentModel.TYPE_CONTENT, parent);
        this.checkNumOfEvents(4);
        this.deleteNode(grandParent);
        this.checkNumOfEvents(8);
    }

    @Test
    public void testCreateDeleteNodeInTheSameTransaction() {
        this.retryingTransactionHelper.doInTransaction(() -> {
            NodeRef nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/ContextAwareRepoEvent", (String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
            this.nodeService.deleteNode(nodeRef);
            return null;
        });
        this.checkNumOfEvents(0);
    }
}

