/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Locale;
import org.alfresco.repo.content.AbstractStreamAwareProxy;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentStreamListener;
import org.alfresco.service.cmr.repository.ContentWriter;

public class StreamAwareContentWriterProxy
extends AbstractStreamAwareProxy
implements ContentWriter {
    private ContentWriter delegatee;
    private Closeable releaseableResource;

    public StreamAwareContentWriterProxy(ContentWriter delegator) {
        this.delegatee = delegator;
    }

    public OutputStream getContentOutputStream() throws ContentIOException {
        OutputStream result = this.delegatee.getContentOutputStream();
        if (this.releaseableResource == null) {
            this.releaseableResource = result;
        }
        return result;
    }

    public FileChannel getFileChannel(boolean truncate) throws ContentIOException {
        FileChannel result = this.delegatee.getFileChannel(truncate);
        if (this.releaseableResource == null) {
            this.releaseableResource = result;
        }
        return result;
    }

    public ContentReader getReader() throws ContentIOException {
        return this.delegatee.getReader();
    }

    public WritableByteChannel getWritableChannel() throws ContentIOException {
        WritableByteChannel result = this.delegatee.getWritableChannel();
        if (this.releaseableResource == null) {
            this.releaseableResource = result;
        }
        return result;
    }

    public void guessEncoding() {
        this.delegatee.guessEncoding();
    }

    public void guessMimetype(String filename) {
        this.delegatee.guessMimetype(filename);
    }

    public boolean isClosed() {
        return this.delegatee.isClosed();
    }

    public void putContent(ContentReader reader) throws ContentIOException {
        this.delegatee.putContent(reader);
    }

    public void putContent(InputStream is) throws ContentIOException {
        this.delegatee.putContent(is);
    }

    public void putContent(File file) throws ContentIOException {
        this.delegatee.putContent(file);
    }

    public void putContent(String content) throws ContentIOException {
        this.delegatee.putContent(content);
    }

    public void addListener(ContentStreamListener listener) {
        this.delegatee.addListener(listener);
    }

    public ContentData getContentData() {
        return this.delegatee.getContentData();
    }

    public String getContentUrl() {
        return this.delegatee.getContentUrl();
    }

    public String getEncoding() {
        return this.delegatee.getEncoding();
    }

    public Locale getLocale() {
        return this.delegatee.getLocale();
    }

    public String getMimetype() {
        return this.delegatee.getMimetype();
    }

    public long getSize() {
        return this.delegatee.getSize();
    }

    public boolean isChannelOpen() {
        return this.delegatee.isChannelOpen();
    }

    public void setEncoding(String encoding) {
        this.delegatee.setEncoding(encoding);
    }

    public void setLocale(Locale locale) {
        this.delegatee.setLocale(locale);
    }

    public void setMimetype(String mimetype) {
        this.delegatee.setMimetype(mimetype);
    }

    @Override
    public boolean canBeClosed() {
        return this.delegatee.isChannelOpen();
    }

    @Override
    public Closeable getStream() {
        return this.releaseableResource;
    }
}

