/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class SpellCheckDecisionManager {
    private static final Log logger = LogFactory.getLog(SpellCheckDecisionManager.class);
    private static final String COLLATION = "collation";
    private boolean collate;
    private String url;
    private JSONObject spellCheckJsonValue;

    public SpellCheckDecisionManager(JSONObject resultJson, String origURL, JSONObject reguestJsonBody, String spellCheckParams) {
        try {
            ArrayList<String> collationQueriesList = new ArrayList<String>();
            JSONObject response = resultJson.getJSONObject("response");
            long numberFound = response.getLong("numFound");
            this.url = origURL;
            JSONObject spellcheck = resultJson.getJSONObject("spellcheck");
            JSONArray suggestions = spellcheck.getJSONArray("suggestions");
            JSONArray collations = null;
            if (spellcheck.has("collations")) {
                collations = spellcheck.getJSONArray("collations");
            }
            JSONArray jsonArray = collations != null ? collations : suggestions;
            int key = 0;
            int value = 1;
            int length = jsonArray.length();
            while (value < length) {
                String jsonName = jsonArray.getString(key);
                if (COLLATION.equals(jsonName)) {
                    JSONObject valueJsonObject = jsonArray.getJSONObject(value);
                    long collationHit = valueJsonObject.getLong("hits");
                    boolean bl = this.collate = numberFound == 0L && collationHit > 0L;
                    if (this.collate) {
                        reguestJsonBody.put("query", (Object)valueJsonObject.getString("collationQuery"));
                        this.spellCheckJsonValue = new JSONObject();
                        this.spellCheckJsonValue.put("searchInsteadFor", (Object)valueJsonObject.getString("collationQueryString"));
                        break;
                    }
                    if (collationHit > numberFound) {
                        collationQueriesList.add(valueJsonObject.getString("collationQueryString"));
                    }
                }
                key += 2;
                value += 2;
            }
            if (this.collate) {
                this.url = origURL.replace(spellCheckParams, "");
            } else if (collationQueriesList.size() > 0) {
                this.spellCheckJsonValue = new JSONObject();
                JSONArray jsonArray1 = new JSONArray(collationQueriesList);
                this.spellCheckJsonValue.put("didYouMean", (Object)jsonArray1);
            } else {
                this.spellCheckJsonValue = new JSONObject();
            }
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
        }
    }

    public boolean isCollate() {
        return this.collate;
    }

    public String getUrl() {
        return this.url;
    }

    public JSONObject getSpellCheckJsonValue() {
        return this.spellCheckJsonValue;
    }
}

