/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.alfresco;

import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.alfresco.AlfrescoDiskDriver;
import org.alfresco.filesys.alfresco.FilesysTransaction;
import org.alfresco.jlan.server.SrvSession;
import org.alfresco.jlan.server.filesys.TransactionalFilesystemInterface;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AlfrescoTxDiskDriver
extends AlfrescoDiskDriver
implements TransactionalFilesystemInterface {
    private static final Log logger = LogFactory.getLog(AlfrescoTxDiskDriver.class);
    private ThreadLocal<Boolean> m_inRetryingTransaction = new ThreadLocal();

    public void beginReadTransaction(SrvSession sess) {
        this.beginTransaction(sess, true);
    }

    public void beginWriteTransaction(SrvSession sess) {
        this.beginTransaction(sess, false);
    }

    public <T> T doInWriteTransaction(SrvSession sess, final CallableIO<T> callback) throws IOException {
        Boolean wasInRetryingTransaction = this.m_inRetryingTransaction.get();
        try {
            boolean hadTransaction = sess.hasTransaction();
            if (hadTransaction) {
                sess.endTransaction();
            }
            this.m_inRetryingTransaction.set(Boolean.TRUE);
            Object result = this.m_transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<T>(){

                @Override
                public T execute() throws Throwable {
                    try {
                        return callback.call();
                    }
                    catch (IOException e) {
                        throw new PropagatingException(e);
                    }
                }
            });
            if (hadTransaction) {
                this.beginReadTransaction(sess);
            }
            Object r = result;
            return (T)r;
        }
        catch (PropagatingException e) {
            throw (IOException)e.getCause();
        }
        finally {
            this.m_inRetryingTransaction.set(wasInRetryingTransaction);
        }
    }

    public void endTransaction(SrvSession sess, Object tx) {
        if (tx == null) {
            return;
        }
        FilesysTransaction filesysTx = (FilesysTransaction)tx;
        if (filesysTx != null && filesysTx.hasTransaction()) {
            UserTransaction ftx = filesysTx.getTransaction();
            try {
                try {
                    if (ftx.getStatus() == 1 || ftx.getStatus() == 4 || ftx.getStatus() == 9) {
                        ftx.rollback();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"End transaction (rollback)");
                        }
                    } else {
                        ftx.commit();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"End transaction (commit)");
                        }
                    }
                }
                catch (Exception ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Failed to end transaction, " + ex.getMessage()));
                    }
                    sess.clearTransaction();
                }
            }
            finally {
                sess.clearTransaction();
            }
        }
    }

    private final void beginTransaction(SrvSession sess, boolean readOnly) throws AlfrescoRuntimeException {
        Boolean inRetryingTransaction = this.m_inRetryingTransaction.get();
        if (inRetryingTransaction != null && inRetryingTransaction.booleanValue()) {
            return;
        }
        sess.initializeTransactionObject();
        FilesysTransaction filesysTx = (FilesysTransaction)sess.getTransactionObject().get();
        if (filesysTx == null) {
            filesysTx = new FilesysTransaction();
            sess.getTransactionObject().set(filesysTx);
        }
        if (filesysTx.hasTransaction()) {
            UserTransaction tx = filesysTx.getTransaction();
            try {
                if (tx.getStatus() == 1 || tx.getStatus() == 4 || tx.getStatus() == 9) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {}
            if (!readOnly && filesysTx.isReadOnly()) {
                try {
                    try {
                        tx.commit();
                    }
                    catch (Exception ex) {
                        throw new AlfrescoRuntimeException("Failed to commit read-only transaction, " + ex.getMessage());
                    }
                }
                finally {
                    filesysTx.clearTransaction();
                }
            }
        }
        if (!filesysTx.hasTransaction()) {
            try {
                UserTransaction userTrans = this.m_transactionService.getUserTransaction(readOnly);
                userTrans.begin();
                filesysTx.setTransaction(userTrans, readOnly);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Created transaction readOnly=" + readOnly));
                }
            }
            catch (Exception ex) {
                throw new AlfrescoRuntimeException("Failed to create transaction, " + ex.getMessage());
            }
        }
        sess.setTransaction((TransactionalFilesystemInterface)this);
    }

    public static interface CallableIO<V>
    extends Callable<V> {
        @Override
        public V call() throws IOException;
    }

    protected static class PropagatingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public PropagatingException(Throwable cause) {
            super(cause);
        }
    }
}

