/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.cleanup;

import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.cleanup.EagerContentStoreCleaner;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.alfresco.util.VmShutdownListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentStoreCleaner {
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"ContentStoreCleaner");
    private static final long LOCK_TTL = 30000L;
    private static Log logger = LogFactory.getLog(ContentStoreCleaner.class);
    private static VmShutdownListener vmShutdownListener = new VmShutdownListener("ContentStoreCleaner");
    private EagerContentStoreCleaner eagerContentStoreCleaner;
    private JobLockService jobLockService;
    private ContentDataDAO contentDataDAO;
    private DictionaryService dictionaryService;
    private ContentService contentService;
    private TransactionService transactionService;
    private int protectDays = 7;
    private int batchSize = 1000;
    private DeleteFailureAction deletionFailureAction = DeleteFailureAction.IGNORE;

    public void setEagerContentStoreCleaner(EagerContentStoreCleaner eagerContentStoreCleaner) {
        this.eagerContentStoreCleaner = eagerContentStoreCleaner;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setProtectDays(int protectDays) {
        this.protectDays = protectDays;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setDeletionFailureAction(DeleteFailureAction deletionFailureAction) {
        this.deletionFailureAction = deletionFailureAction;
    }

    public void init() {
        this.checkProperties();
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        PropertyCheck.mandatory((Object)this, (String)"contentDataDAO", (Object)this.contentDataDAO);
        PropertyCheck.mandatory((Object)this, (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)this, (String)"contentService", (Object)this.contentService);
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"eagerContentStoreCleaner", (Object)this.eagerContentStoreCleaner);
        if (this.protectDays < 0) {
            throw new AlfrescoRuntimeException("Property 'protectDays' must be 0 or greater (0 is not recommended)");
        }
        if (this.protectDays == 0) {
            logger.warn((Object)"Property 'protectDays' is set to 0.  Please ensure that your backup strategy is appropriate for this setting.");
        }
    }

    private String acquireLock(JobLockService.JobLockRefreshCallback lockCallback) {
        String lockToken = this.jobLockService.getLock(LOCK_QNAME, 30000L);
        this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 30000L, lockCallback);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("lock acquired: " + String.valueOf(LOCK_QNAME) + ": " + lockToken));
        }
        return lockToken;
    }

    private void releaseLock(LockCallback lockCallback, String lockToken) {
        if (lockCallback != null) {
            lockCallback.running.set(false);
        }
        if (lockToken != null) {
            this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Lock released: " + String.valueOf(LOCK_QNAME) + ": " + lockToken));
            }
        }
    }

    public void execute() {
        block10: {
            this.checkProperties();
            if (this.transactionService.isReadOnly()) {
                logger.debug((Object)"Content store cleanup bypassed; the system is read-only.");
                return;
            }
            LockCallback lockCallback = new LockCallback();
            String lockToken = null;
            try {
                logger.debug((Object)"Content store cleanup started.");
                lockToken = this.acquireLock(lockCallback);
                this.executeInternal();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"   Content store cleanup completed.");
                }
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"   Content store cleanup already underway.");
                }
                this.releaseLock(lockCallback, lockToken);
                break block10;
            }
            catch (VmShutdownListener.VmShutdownException vmShutdownException) {
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"   Content store cleanup aborted.");
                    }
                    this.releaseLock(lockCallback, lockToken);
                    break block10;
                }
                catch (Throwable throwable) {
                    this.releaseLock(lockCallback, lockToken);
                    throw throwable;
                }
            }
            this.releaseLock(lockCallback, lockToken);
        }
    }

    private void executeInternal() {
        final long maxOrphanTime = System.currentTimeMillis() - (long)(this.protectDays * 24 * 3600) * 1000L;
        RetryingTransactionHelper.RetryingTransactionCallback<Long> getAndDeleteWork = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            @Override
            public Long execute() throws Exception {
                return ContentStoreCleaner.this.cleanBatch(maxOrphanTime, ContentStoreCleaner.this.batchSize);
            }
        };
        while (true) {
            Long lastProcessedOrphanId = this.transactionService.getRetryingTransactionHelper().doInTransaction(getAndDeleteWork);
            if (vmShutdownListener.isVmShuttingDown()) {
                throw new VmShutdownListener.VmShutdownException();
            }
            if (lastProcessedOrphanId == null) break;
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("   Removed orphaned content URLs up orphan time " + String.valueOf(new Date(lastProcessedOrphanId))));
        }
    }

    private Long cleanBatch(long maxTimeExclusive, int batchSize) {
        final TreeMap urlsById = new TreeMap();
        ContentDataDAO.ContentUrlHandler contentUrlHandler = new ContentDataDAO.ContentUrlHandler(){

            @Override
            public void handle(Long id, String contentUrl, Long orphanTime) {
                urlsById.put(id, contentUrl);
            }
        };
        this.contentDataDAO.getContentUrlsOrphaned(contentUrlHandler, maxTimeExclusive, batchSize);
        if (urlsById.size() == 0) {
            return null;
        }
        Long lastId = (Long)urlsById.lastKey();
        ArrayList<Long> ids = new ArrayList<Long>(urlsById.keySet());
        this.contentDataDAO.deleteContentUrls(ids);
        for (Long id : ids) {
            String contentUrl = (String)urlsById.get(id);
            boolean deleted = this.eagerContentStoreCleaner.deleteFromStores(contentUrl);
            if (deleted) continue;
            switch (this.deletionFailureAction) {
                case KEEP_URL: {
                    this.contentDataDAO.createContentUrlOrphaned(contentUrl, new Date(0L));
                }
                case IGNORE: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown deletion failure action: " + String.valueOf((Object)this.deletionFailureAction));
                }
            }
        }
        return lastId;
    }

    public static enum DeleteFailureAction {
        IGNORE,
        KEEP_URL;

    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback() {
        }

        @Override
        public boolean isActive() {
            return this.running.get();
        }

        @Override
        public void lockReleased() {
            this.running.set(false);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Lock release notification: " + String.valueOf(LOCK_QNAME)));
            }
        }
    }
}

