/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.oauth1;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.remotecredentials.OAuth1CredentialsInfoImpl;
import org.alfresco.repo.remotecredentials.RemoteCredentialsModel;
import org.alfresco.service.cmr.oauth1.OAuth1CredentialsStoreService;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.OAuth1CredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.RemoteCredentialsService;
import org.alfresco.service.cmr.remoteticket.NoSuchSystemException;

public class OAuth1CredentialsStoreServiceImpl
implements OAuth1CredentialsStoreService {
    private RemoteCredentialsService remoteCredentialsService;

    public void setRemoteCredentialsService(RemoteCredentialsService remoteCredentialsService) {
        this.remoteCredentialsService = remoteCredentialsService;
    }

    @Override
    public OAuth1CredentialsInfo storePersonalOAuth1Credentials(String remoteSystemId, String token, String secret) throws NoSuchSystemException {
        OAuth1CredentialsInfo credentials = this.buildPersonalOAuth1CredentialsInfo(remoteSystemId, token, secret);
        if (credentials.getNodeRef() != null) {
            return (OAuth1CredentialsInfo)this.remoteCredentialsService.updateCredentials(credentials);
        }
        return (OAuth1CredentialsInfo)this.remoteCredentialsService.createPersonCredentials(remoteSystemId, credentials);
    }

    @Override
    public OAuth1CredentialsInfo storeSharedOAuth1Credentials(String remoteSystemId, String token, String secret) throws NoSuchSystemException {
        OAuth1CredentialsInfo credentials = this.buildSharedOAuth1CredentialsInfo(remoteSystemId, token, secret);
        return (OAuth1CredentialsInfo)this.remoteCredentialsService.createSharedCredentials(remoteSystemId, credentials);
    }

    @Override
    public OAuth1CredentialsInfo updateSharedOAuth1Credentials(OAuth1CredentialsInfo exisitingCredentials, String remoteSystemId, String token, String secret) throws NoSuchSystemException {
        List<OAuth1CredentialsInfo> shared = this.listSharedOAuth1Credentials(remoteSystemId);
        for (OAuth1CredentialsInfo credential : shared) {
            if (!credential.getNodeRef().equals((Object)exisitingCredentials.getNodeRef())) continue;
            OAuth1CredentialsInfoImpl credentials = new OAuth1CredentialsInfoImpl(exisitingCredentials.getNodeRef(), exisitingCredentials.getRemoteSystemName(), exisitingCredentials.getRemoteSystemContainerNodeRef());
            credentials.setOAuthToken(token);
            credentials.setOAuthSecret(secret);
            return (OAuth1CredentialsInfo)this.remoteCredentialsService.updateCredentials(credentials);
        }
        throw new AlfrescoRuntimeException("Cannot update Credentials which haven't been persisted yet!");
    }

    private OAuth1CredentialsInfo buildPersonalOAuth1CredentialsInfo(String remoteSystemId, String token, String secret) {
        OAuth1CredentialsInfoImpl credentials = new OAuth1CredentialsInfoImpl();
        OAuth1CredentialsInfoImpl existing = (OAuth1CredentialsInfoImpl)this.getPersonalOAuth1Credentials(remoteSystemId);
        if (existing != null) {
            credentials = existing;
        }
        credentials.setOAuthToken(token);
        credentials.setOAuthSecret(secret);
        return credentials;
    }

    private OAuth1CredentialsInfo buildSharedOAuth1CredentialsInfo(String remoteSystemId, String token, String secret) {
        OAuth1CredentialsInfoImpl credentials = new OAuth1CredentialsInfoImpl();
        credentials.setOAuthToken(token);
        credentials.setOAuthSecret(secret);
        return credentials;
    }

    @Override
    public OAuth1CredentialsInfo getPersonalOAuth1Credentials(String remoteSystemId) throws NoSuchSystemException {
        return (OAuth1CredentialsInfo)this.remoteCredentialsService.getPersonCredentials(remoteSystemId);
    }

    @Override
    public List<OAuth1CredentialsInfo> listSharedOAuth1Credentials(String remoteSystemId) throws NoSuchSystemException {
        PagingRequest paging = new PagingRequest(Integer.MAX_VALUE);
        PagingResults<? extends BaseCredentialsInfo> pagingResults = this.remoteCredentialsService.listSharedCredentials(remoteSystemId, RemoteCredentialsModel.TYPE_OAUTH1_CREDENTIALS, paging);
        return pagingResults.getPage();
    }

    @Override
    public boolean deletePersonalOAuth1Credentials(String remoteSystemId) throws NoSuchSystemException {
        OAuth1CredentialsInfo credentials = this.getPersonalOAuth1Credentials(remoteSystemId);
        if (credentials == null) {
            return false;
        }
        this.remoteCredentialsService.deleteCredentials(credentials);
        return true;
    }

    @Override
    public boolean deleteSharedOAuth1Credentials(String remoteSystemId, OAuth1CredentialsInfo credentials) throws NoSuchSystemException {
        List<OAuth1CredentialsInfo> shared = this.listSharedOAuth1Credentials(remoteSystemId);
        if (shared.isEmpty()) {
            return false;
        }
        for (OAuth1CredentialsInfo credential : shared) {
            if (credential.getNodeRef().equals((Object)credentials.getNodeRef())) {
                this.remoteCredentialsService.deleteCredentials(credential);
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public OAuth1CredentialsInfo updateCredentialsAuthenticationSucceeded(boolean succeeded, OAuth1CredentialsInfo credentials) {
        return (OAuth1CredentialsInfo)this.remoteCredentialsService.updateCredentialsAuthenticationSucceeded(succeeded, credentials);
    }
}

