/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer.report;

import java.io.Writer;
import java.util.List;
import org.alfresco.repo.transfer.manifest.TransferManifestNode;
import org.alfresco.repo.transfer.report.XMLTransferEventFormatter;
import org.alfresco.repo.transfer.report.XMLTransferEventFormatterFactory;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.transfer.TransferDefinition;
import org.alfresco.service.cmr.transfer.TransferEvent;
import org.alfresco.service.cmr.transfer.TransferTarget;
import org.alfresco.service.namespace.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLTransferReportWriter {
    private XMLWriter writer;
    final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    final String PREFIX = "report";

    public void startTransferReport(String encoding, Writer writer) throws SAXException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding(encoding);
        this.writer = new XMLWriter(writer, format);
        this.writer.startDocument();
        this.writer.startPrefixMapping("report", "http://www.alfresco.org/model/transferReport/2.0");
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "transferReport", "report:transferReport", (Attributes)this.EMPTY_ATTRIBUTES);
    }

    public void endTransferReport() throws SAXException {
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "transferReport", "report:transferReport");
        this.writer.endPrefixMapping("report");
        this.writer.endDocument();
    }

    public void writeTarget(TransferTarget target) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "name", "name", "String", target.getName());
        attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "endpointHost", "endpointHost", "String", target.getEndpointHost());
        attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "endpointPort", "endpointPort", "int", String.valueOf(target.getEndpointPort()));
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "target", "report:target", (Attributes)attributes);
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "target", "report:target");
    }

    public void writeDefinition(TransferDefinition definition) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "isReadOnly", "isReadOnly", "boolean", definition.isReadOnly() ? "true" : "false");
        attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "isSync", "isSync", "boolean", definition.isSync() ? "true" : "false");
        if (definition.getNodes() != null) {
            attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "numberOfNodes", "numberOfNodes", "string", String.valueOf(definition.getNodes().size()));
        }
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "definition", "report:definition", (Attributes)attributes);
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "definition", "report:definition");
    }

    public void writeException(Exception e) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "type", "type", "String", e.getClass().getName());
        attributes.addAttribute("http://www.alfresco.org/model/transferReport/2.0", "message", "message", "String", e.getMessage());
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "exception", "report:exception", (Attributes)attributes);
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "exception", "report:exception");
    }

    public void writeTransferEvents(List<TransferEvent> events) throws SAXException {
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "events", "report:events", (Attributes)this.EMPTY_ATTRIBUTES);
        for (TransferEvent event : events) {
            this.writeTransferEvent(event);
        }
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "events", "report:events");
    }

    public void writeNodeSummary(TransferManifestNode node) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("uri", "nodeRef", "nodeRef", "String", node.getNodeRef().toString());
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "node", "report:node", (Attributes)attributes);
        if (node.getPrimaryParentAssoc() != null) {
            this.writePrimaryParent(node.getPrimaryParentAssoc(), node.getParentPath());
        }
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "node", "report:node");
    }

    private void writePrimaryParent(ChildAssociationRef parentAssoc, Path parentPath) throws SAXException {
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "primaryParent", "report:primaryParent", (Attributes)this.EMPTY_ATTRIBUTES);
        this.writeParentAssoc(parentAssoc);
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", "primaryPath", "report:primaryPath", (Attributes)this.EMPTY_ATTRIBUTES);
        if (parentPath != null) {
            String path = parentPath.toString();
            this.writer.characters(path.toCharArray(), 0, path.length());
        }
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "primaryPath", "report:primaryPath");
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", "primaryParent", "report:primaryParent");
    }

    private void writeParentAssoc(ChildAssociationRef assoc) throws SAXException {
        if (assoc != null) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "from", "from", "String", assoc.getParentRef().toString());
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "type", "type", "String", this.formatQName(assoc.getTypeQName()));
            attributes.addAttribute("http://www.alfresco.org/model/transfer/1.0", "type", "isPrimary", "Boolean", assoc.isPrimary() ? "true" : "false");
            this.writer.startElement("http://www.alfresco.org/model/transfer/1.0", "parentAssoc", "report:parentAssoc", (Attributes)attributes);
            String name = this.formatQName(assoc.getQName());
            this.writer.characters(name.toCharArray(), 0, name.length());
            assoc.isPrimary();
            this.writer.endElement("http://www.alfresco.org/model/transfer/1.0", "parentAssoc", "report:parentAssoc");
        }
    }

    public void writeTransferEvent(TransferEvent event) throws SAXException {
        XMLTransferEventFormatter formatter = XMLTransferEventFormatterFactory.getFormatter(event);
        AttributesImpl attributes = formatter.getAttributes(event);
        String elementName = formatter.getElementName(event);
        String message = formatter.getMessage(event);
        this.writer.startElement("http://www.alfresco.org/model/transferReport/2.0", elementName, "report:" + elementName, (Attributes)attributes);
        if (message != null) {
            this.writer.characters(message.toCharArray(), 0, message.length());
        }
        this.writer.endElement("http://www.alfresco.org/model/transferReport/2.0", elementName, "report:" + elementName);
    }

    private String formatQName(QName qname) {
        return qname.toString();
    }
}

