/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.mimetype;

import junit.framework.TestCase;
import org.alfresco.repo.domain.mimetype.MimetypeDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class MimetypeDAOTest
extends TestCase {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private RetryingTransactionHelper txnHelper;
    private MimetypeDAO mimetypeDAO;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.mimetypeDAO = (MimetypeDAO)this.ctx.getBean("mimetypeDAO");
    }

    private Pair<Long, String> get(final String mimetype, final boolean autoCreate, boolean expectSuccess) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            public Pair<Long, String> execute() throws Throwable {
                Pair mimetypePair = null;
                mimetypePair = autoCreate ? MimetypeDAOTest.this.mimetypeDAO.getOrCreateMimetype(mimetype) : MimetypeDAOTest.this.mimetypeDAO.getMimetype(mimetype);
                return mimetypePair;
            }
        };
        try {
            return (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, !autoCreate, false);
        }
        catch (Throwable e) {
            if (expectSuccess) {
                throw new RuntimeException("Expected to get mimetype '" + mimetype + "'.", e);
            }
            return null;
        }
    }

    private Pair<Long, String> update(final String oldMimetype, final String newMimetype) {
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            public Pair<Long, String> execute() throws Throwable {
                MimetypeDAOTest.this.mimetypeDAO.updateMimetype(oldMimetype, newMimetype);
                return MimetypeDAOTest.this.mimetypeDAO.getMimetype(newMimetype);
            }
        };
        return (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, false);
    }

    public void testCreateWithCommit() throws Exception {
        String mimetype = GUID.generate();
        Pair<Long, String> mimetypePair = this.get(mimetype, true, true);
        Pair<Long, String> mimetypePairCheck = this.get((String)mimetypePair.getSecond(), false, true);
        MimetypeDAOTest.assertEquals((String)"Mimetype ID changed", (Object)mimetypePair.getFirst(), (Object)mimetypePairCheck.getFirst());
    }

    public void testCreateWithRollback() throws Exception {
        final String mimetype = GUID.generate();
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            public Pair<Long, String> execute() throws Throwable {
                MimetypeDAOTest.this.get(mimetype, true, true);
                throw new RuntimeException("Forced");
            }
        };
        try {
            this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
            MimetypeDAOTest.fail((String)"Transaction didn't roll back");
        }
        catch (RuntimeException runtimeException) {}
        this.get(mimetype, false, false);
    }

    public void testCaseInsensitivity() throws Exception {
        String mimetype = "AAA-" + GUID.generate();
        Pair<Long, String> lowercasePair = this.get(mimetype.toLowerCase(), true, true);
        Long id = (Long)lowercasePair.getFirst();
        Pair<Long, String> uppercasePair = this.get(mimetype.toUpperCase(), true, true);
        MimetypeDAOTest.assertNotNull(uppercasePair);
        MimetypeDAOTest.assertEquals((String)"Upper and lowercase mimetype instance IDs were not the same", (Object)id, (Object)uppercasePair.getFirst());
        MimetypeDAOTest.assertEquals((String)mimetype.toLowerCase(), (String)((String)lowercasePair.getSecond()));
        MimetypeDAOTest.assertEquals((String)mimetype.toLowerCase(), (String)((String)uppercasePair.getSecond()));
        String mimetypeFoobar = "APPLICATION/FOOBAR/" + GUID.generate();
        Pair<Long, String> updatedMimetype = this.update(mimetype, mimetypeFoobar);
        MimetypeDAOTest.assertEquals((Object)id, (Object)updatedMimetype.getFirst());
        MimetypeDAOTest.assertEquals((String)mimetypeFoobar.toLowerCase(), (String)((String)updatedMimetype.getSecond()));
        updatedMimetype = this.get(mimetypeFoobar.toUpperCase(), false, true);
        MimetypeDAOTest.assertNotNull(updatedMimetype);
        MimetypeDAOTest.assertEquals((Object)id, (Object)updatedMimetype.getFirst());
        MimetypeDAOTest.assertEquals((String)mimetypeFoobar.toLowerCase(), (String)((String)updatedMimetype.getSecond()));
        updatedMimetype = this.get(mimetypeFoobar.toLowerCase(), false, true);
        MimetypeDAOTest.assertNotNull(updatedMimetype);
        MimetypeDAOTest.assertEquals((Object)id, (Object)updatedMimetype.getFirst());
        MimetypeDAOTest.assertEquals((String)mimetypeFoobar.toLowerCase(), (String)((String)updatedMimetype.getSecond()));
    }

    public void testUpdate() throws Exception {
        final String oldMimetype = GUID.generate();
        final String newMimetype = GUID.generate();
        Pair<Long, String> oldMimetypePair = this.get(oldMimetype, true, true);
        RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Pair<Long, String>>(){

            public Pair<Long, String> execute() throws Throwable {
                int count = MimetypeDAOTest.this.mimetypeDAO.updateMimetype(oldMimetype, newMimetype);
                MimetypeDAOTest.assertEquals((String)"Incorrect number updated", (int)1, (int)count);
                return MimetypeDAOTest.this.mimetypeDAO.getMimetype(newMimetype);
            }
        };
        Pair newMimetypePair = (Pair)this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, false);
        MimetypeDAOTest.assertEquals((String)"ID should remain the same if the old mimetype existed", (Object)oldMimetypePair.getFirst(), (Object)newMimetypePair.getFirst());
        this.get(oldMimetype, false, false);
        this.get(newMimetype, false, true);
    }
}

