/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.bundle.FileInfoPropsComparator;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;

public class FileInfoPropsComparatorTest
extends VirtualizationIntegrationTest {
    private static Log logger = LogFactory.getLog(FileInfoPropsComparatorTest.class);

    private void compare(List<FileInfo> fileInfoList, QName property) {
        ArrayList<Pair> sortProps = new ArrayList<Pair>();
        sortProps.add(new Pair((Object)QName.createQName((String)"IS_FOLDER"), (Object)false));
        sortProps.add(new Pair((Object)property, (Object)false));
        FileInfoPropsComparator comparator = new FileInfoPropsComparator(sortProps);
        Assert.assertEquals((long)-1L, (long)comparator.compare(fileInfoList.get(0), fileInfoList.get(1)));
        Assert.assertEquals((long)1L, (long)comparator.compare(fileInfoList.get(1), fileInfoList.get(0)));
        ArrayList<Pair> localSortProps = sortProps;
        ((Pair)localSortProps.get(0)).setSecond((Object)true);
        comparator = new FileInfoPropsComparator(localSortProps);
        Assert.assertEquals((long)1L, (long)comparator.compare(fileInfoList.get(0), fileInfoList.get(1)));
        Assert.assertEquals((long)-1L, (long)comparator.compare(fileInfoList.get(1), fileInfoList.get(0)));
        Assert.assertEquals((long)1L, (long)comparator.compare(fileInfoList.get(1), fileInfoList.get(2)));
        Assert.assertEquals((long)-1L, (long)comparator.compare(fileInfoList.get(2), fileInfoList.get(1)));
    }

    @Test
    public void testCompare() {
        this.createFolder(this.testRootFolder.getNodeRef(), "FOLDER").getChildRef();
        NodeRef virtualFolder = this.createVirtualizedFolder(this.testRootFolder.getNodeRef(), "VirtualFolder2", "C/org/alfresco/repo/virtual/template/testTemplate6.json");
        NodeRef nodeRef1 = this.nodeService.getChildByName(virtualFolder, ContentModel.ASSOC_CONTAINS, "Node1");
        QName assocQName1 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"testfile1.txt"));
        QName assocQName2 = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)"testfile2.txt"));
        ChildAssociationRef assoc2 = this.nodeService.createNode(virtualFolder, ContentModel.ASSOC_CONTAINS, assocQName1, ContentModel.TYPE_CONTENT, null);
        NodeRef nodeRef2 = assoc2.getChildRef();
        ChildAssociationRef assoc3 = this.nodeService.createNode(virtualFolder, ContentModel.ASSOC_CONTAINS, assocQName2, ContentModel.TYPE_CONTENT, null);
        NodeRef nodeRef3 = assoc3.getChildRef();
        ArrayList<NodeRef> nodeRefList = new ArrayList<NodeRef>();
        nodeRefList.add(nodeRef1);
        nodeRefList.add(nodeRef2);
        nodeRefList.add(nodeRef3);
        List fileInfoList = this.fileAndFolderService.toFileInfoList(nodeRefList);
        this.compare(fileInfoList, ContentModel.PROP_MODIFIED);
        this.compare(fileInfoList, ContentModel.PROP_CREATED);
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_TITLE, (Serializable)((Object)"title2"));
        this.nodeService.setProperty(nodeRef3, ContentModel.PROP_TITLE, (Serializable)((Object)"title3"));
        fileInfoList = this.fileAndFolderService.toFileInfoList(nodeRefList);
        this.compare(fileInfoList, ContentModel.PROP_TITLE);
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"descr2"));
        this.nodeService.setProperty(nodeRef3, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"descr3"));
        fileInfoList = this.fileAndFolderService.toFileInfoList(nodeRefList);
        this.compare(fileInfoList, ContentModel.PROP_DESCRIPTION);
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"descr2"));
        this.nodeService.setProperty(nodeRef3, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"descr2"));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_TITLE, (Serializable)((Object)"title"));
        this.nodeService.setProperty(nodeRef3, ContentModel.PROP_TITLE, (Serializable)((Object)"title1"));
        ArrayList<Pair> sortProps = new ArrayList<Pair>();
        sortProps.add(new Pair((Object)QName.createQName((String)"IS_FOLDER"), (Object)false));
        sortProps.add(new Pair((Object)ContentModel.PROP_DESCRIPTION, (Object)false));
        sortProps.add(new Pair((Object)ContentModel.PROP_TITLE, (Object)false));
        fileInfoList = this.fileAndFolderService.toFileInfoList(nodeRefList);
        FileInfoPropsComparator comparator = new FileInfoPropsComparator(sortProps);
        Assert.assertEquals((long)1L, (long)comparator.compare((FileInfo)fileInfoList.get(1), (FileInfo)fileInfoList.get(2)));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_CREATED, (Serializable)new Date(8099, 11, 31));
        this.nodeService.setProperty(nodeRef3, ContentModel.PROP_CREATED, (Serializable)new Date(0, 0, 0));
        fileInfoList = this.fileAndFolderService.toFileInfoList(nodeRefList);
        sortProps.remove(sortProps.size() - 1);
        sortProps.add(new Pair((Object)ContentModel.PROP_CREATED, (Object)false));
        comparator = new FileInfoPropsComparator(sortProps);
        Assert.assertEquals((long)1L, (long)comparator.compare((FileInfo)fileInfoList.get(1), (FileInfo)fileInfoList.get(2)));
        this.nodeService.setProperty(nodeRef2, ContentModel.PROP_TITLE, (Serializable)((Object)""));
        this.nodeService.setProperty(nodeRef3, ContentModel.PROP_TITLE, (Serializable)((Object)" "));
        fileInfoList = this.fileAndFolderService.toFileInfoList(nodeRefList);
        sortProps.remove(sortProps.size() - 1);
        sortProps.add(new Pair((Object)ContentModel.PROP_TITLE, (Object)false));
        comparator = new FileInfoPropsComparator(sortProps);
        Assert.assertEquals((long)1L, (long)comparator.compare((FileInfo)fileInfoList.get(1), (FileInfo)fileInfoList.get(2)));
    }
}

