/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.alfresco.util.schemacomp.XMLToSchema;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Sequence;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.alfresco.util.schemacomp.validator.NameValidator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;

public class XMLToSchemaTest {
    private XMLToSchema xmlToSchema;
    private InputStream in;

    @Before
    public void setUp() throws Exception {
        ClassPathResource testFileResource = new ClassPathResource("schemacomp/xml_to_schema_test.xml");
        this.in = new BufferedInputStream(testFileResource.getInputStream());
        this.xmlToSchema = new XMLToSchema(this.in);
    }

    @Test
    public void canReadSchemaXML() {
        this.xmlToSchema.parse();
        Schema schema = this.xmlToSchema.getSchema();
        Assert.assertNotNull((String)"A null Schema object was returned", (Object)schema);
        Assert.assertNull((String)"Schema isn't meant to have a parent", (Object)schema.getParent());
        Assert.assertEquals((Object)"alfresco", (Object)schema.getName());
        Assert.assertEquals((Object)"myprefix_", (Object)schema.getDbPrefix());
        Assert.assertEquals((long)325L, (long)schema.getVersion());
        Iterator objects = schema.iterator();
        Table table = (Table)objects.next();
        Assert.assertSame((String)"Wrong or no parent set on table", (Object)schema, (Object)table.getParent());
        Assert.assertEquals((Object)"node", (Object)table.getName());
        Assert.assertEquals((long)3L, (long)table.getColumns().size());
        Assert.assertSame((String)"Wrong or no parent set", (Object)table, (Object)((Column)table.getColumns().get(0)).getParent());
        Assert.assertEquals((Object)"id", (Object)((Column)table.getColumns().get(0)).getName());
        Assert.assertEquals((Object)"NUMBER(10)", (Object)((Column)table.getColumns().get(0)).getType());
        Assert.assertEquals((Object)false, (Object)((Column)table.getColumns().get(0)).isNullable());
        Assert.assertEquals((long)1L, (long)((Column)table.getColumns().get(0)).getOrder());
        Assert.assertEquals((Object)true, (Object)((Column)table.getColumns().get(0)).isAutoIncrement());
        Assert.assertSame((String)"Wrong or no parent set", (Object)table, (Object)((Column)table.getColumns().get(1)).getParent());
        Assert.assertEquals((Object)"nodeRef", (Object)((Column)table.getColumns().get(1)).getName());
        Assert.assertEquals((Object)"VARCHAR2(200)", (Object)((Column)table.getColumns().get(1)).getType());
        Assert.assertEquals((Object)false, (Object)((Column)table.getColumns().get(1)).isNullable());
        Assert.assertEquals((long)3L, (long)((Column)table.getColumns().get(1)).getOrder());
        Assert.assertEquals((Object)false, (Object)((Column)table.getColumns().get(1)).isAutoIncrement());
        Assert.assertSame((String)"Wrong or no parent set", (Object)table, (Object)((Column)table.getColumns().get(2)).getParent());
        Assert.assertEquals((Object)"name", (Object)((Column)table.getColumns().get(2)).getName());
        Assert.assertEquals((Object)"VARCHAR2(150)", (Object)((Column)table.getColumns().get(2)).getType());
        Assert.assertEquals((Object)true, (Object)((Column)table.getColumns().get(2)).isNullable());
        Assert.assertEquals((long)2L, (long)((Column)table.getColumns().get(2)).getOrder());
        Assert.assertEquals((Object)false, (Object)((Column)table.getColumns().get(2)).isAutoIncrement());
        Assert.assertSame((String)"Wrong or no parent set", (Object)table, (Object)table.getPrimaryKey().getParent());
        Assert.assertEquals((Object)"pk_node", (Object)table.getPrimaryKey().getName());
        Assert.assertEquals((long)1L, (long)table.getPrimaryKey().getColumnNames().size());
        Assert.assertEquals((Object)"id", table.getPrimaryKey().getColumnNames().get(0));
        Assert.assertEquals((long)1L, (long)((Integer)table.getPrimaryKey().getColumnOrders().get(0)).intValue());
        Assert.assertEquals((long)1L, (long)table.getForeignKeys().size());
        Assert.assertSame((String)"Wrong or no parent set", (Object)table, (Object)((ForeignKey)table.getForeignKeys().get(0)).getParent());
        Assert.assertEquals((Object)"fk_node_noderef", (Object)((ForeignKey)table.getForeignKeys().get(0)).getName());
        Assert.assertEquals((Object)"nodeRef", (Object)((ForeignKey)table.getForeignKeys().get(0)).getLocalColumn());
        Assert.assertEquals((Object)"node", (Object)((ForeignKey)table.getForeignKeys().get(0)).getTargetTable());
        Assert.assertEquals((Object)"nodeRef", (Object)((ForeignKey)table.getForeignKeys().get(0)).getTargetColumn());
        Assert.assertEquals((long)1L, (long)table.getIndexes().size());
        Index index = (Index)table.getIndexes().get(0);
        Assert.assertSame((String)"Wrong or no parent set on index", (Object)table, (Object)index.getParent());
        Assert.assertEquals((Object)"idx_node_by_id", (Object)index.getName());
        Assert.assertEquals((Object)true, (Object)index.isUnique());
        Assert.assertEquals((long)2L, (long)index.getColumnNames().size());
        Assert.assertEquals((Object)"id", index.getColumnNames().get(0));
        Assert.assertEquals((Object)"nodeRef", index.getColumnNames().get(1));
        Assert.assertEquals((long)1L, (long)index.getValidators().size());
        DbValidator validator = (DbValidator)index.getValidators().get(0);
        Assert.assertEquals(NameValidator.class, validator.getClass());
        Assert.assertEquals((long)1L, (long)validator.getPropertyNames().size());
        Assert.assertEquals((Object)"idx_.+", (Object)validator.getProperty("pattern"));
        Sequence seq = (Sequence)objects.next();
        Assert.assertSame((String)"Wrong or no parent set", (Object)schema, (Object)seq.getParent());
        Assert.assertEquals((Object)"node_seq", (Object)seq.getName());
        seq = (Sequence)objects.next();
        Assert.assertSame((String)"Wrong or no parent set", (Object)schema, (Object)seq.getParent());
        Assert.assertEquals((Object)"person_seq", (Object)seq.getName());
        seq = (Sequence)objects.next();
        Assert.assertSame((String)"Wrong or no parent set", (Object)schema, (Object)seq.getParent());
        Assert.assertEquals((Object)"content_seq", (Object)seq.getName());
        Assert.assertFalse((String)"Should be no more DB objects", (boolean)objects.hasNext());
    }
}

