/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.action.ParameterizedItemDefinition;
import org.alfresco.service.cmr.rule.RuleServiceException;
import org.springframework.extensions.surf.util.I18NUtil;

public abstract class ParameterizedItemDefinitionImpl
implements ParameterizedItemDefinition,
Serializable {
    private static final long serialVersionUID = -114215660281683946L;
    private String name;
    private String titleKey;
    private String descriptionKey;
    private boolean adhocPropertiesAllowed = false;
    private Map<Locale, List<ParameterDefinition>> parameterDefinitions = new HashMap<Locale, List<ParameterDefinition>>();
    private Map<Locale, Map<String, ParameterDefinition>> paramDefinitionsByName;
    private static final String ERR_NAME_DUPLICATION = "The names given to parameter definitions must be unique within the scope of the rule item definition.";

    public ParameterizedItemDefinitionImpl(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setTitleKey(String title) {
        this.titleKey = title;
    }

    @Override
    public String getTitle() {
        return I18NUtil.getMessage((String)this.titleKey);
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    @Override
    public String getDescription() {
        return I18NUtil.getMessage((String)this.descriptionKey);
    }

    @Override
    public boolean getAdhocPropertiesAllowed() {
        return this.adhocPropertiesAllowed;
    }

    public void setAdhocPropertiesAllowed(boolean adhocPropertiesAllowed) {
        this.adhocPropertiesAllowed = adhocPropertiesAllowed;
    }

    public void setLocalizedParameterDefinitions(Map<Locale, List<ParameterDefinition>> parameterDefinitions) {
        if (this.hasDuplicateNames(parameterDefinitions)) {
            throw new RuleServiceException(ERR_NAME_DUPLICATION);
        }
        this.parameterDefinitions = parameterDefinitions;
        this.createParamDefinitionsByName();
    }

    public void setParameterDefinitions(List<ParameterDefinition> parameterDefinitions) {
        Locale currentLocale = I18NUtil.getLocale();
        new HashMap();
        if (this.hasDuplicateNames(parameterDefinitions)) {
            throw new RuleServiceException(ERR_NAME_DUPLICATION);
        }
        this.parameterDefinitions.put(currentLocale, parameterDefinitions);
        this.createParamDefinitionsByName();
    }

    private void createParamDefinitionsByName() {
        this.paramDefinitionsByName = new HashMap<Locale, Map<String, ParameterDefinition>>();
        for (Locale locale : this.parameterDefinitions.keySet()) {
            HashMap<String, ParameterDefinition> namedDefinitions = new HashMap<String, ParameterDefinition>();
            this.paramDefinitionsByName.put(locale, namedDefinitions);
            List<ParameterDefinition> localizedDefinitions = this.parameterDefinitions.get(locale);
            if (localizedDefinitions == null || localizedDefinitions.size() <= 0) continue;
            for (ParameterDefinition definition : localizedDefinitions) {
                namedDefinitions.put(definition.getName(), definition);
            }
        }
    }

    private boolean hasDuplicateNames(Map<Locale, List<ParameterDefinition>> parameterDefinitions) {
        boolean result = false;
        if (parameterDefinitions != null) {
            for (List<ParameterDefinition> localizedDefinitions : parameterDefinitions.values()) {
                result = this.hasDuplicateNames(localizedDefinitions);
                if (result) break;
            }
        }
        return result;
    }

    private boolean hasDuplicateNames(List<ParameterDefinition> parameterDefinitions) {
        boolean result = false;
        if (parameterDefinitions != null) {
            HashSet<String> temp = new HashSet<String>(parameterDefinitions.size());
            for (ParameterDefinition definition : parameterDefinitions) {
                temp.add(definition.getName());
            }
            result = parameterDefinitions.size() != temp.size();
        }
        return result;
    }

    @Override
    public boolean hasParameterDefinitions() {
        List<ParameterDefinition> localizedDefinitions = this.getParameterDefinitions();
        return localizedDefinitions != null && !localizedDefinitions.isEmpty();
    }

    @Override
    public List<ParameterDefinition> getParameterDefinitions() {
        Set<Locale> locales = this.parameterDefinitions.keySet();
        Locale match = I18NUtil.getNearestLocale((Locale)I18NUtil.getLocale(), locales);
        List<ParameterDefinition> result = this.parameterDefinitions.get(match);
        if (result == null) {
            result = this.parameterDefinitions.get(Locale.ROOT);
        }
        return result;
    }

    @Override
    public ParameterDefinition getParameterDefintion(String name) {
        ParameterDefinition result = null;
        if (this.paramDefinitionsByName != null) {
            Set<Locale> locales = this.paramDefinitionsByName.keySet();
            Locale match = I18NUtil.getNearestLocale((Locale)I18NUtil.getLocale(), locales);
            Map<String, ParameterDefinition> localizedDefinitionsByName = this.paramDefinitionsByName.get(match);
            if (localizedDefinitionsByName == null) {
                localizedDefinitionsByName = this.paramDefinitionsByName.get(Locale.ROOT);
            }
            result = localizedDefinitionsByName == null ? null : localizedDefinitionsByName.get(name);
        }
        return result;
    }
}

