/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.acegi;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.sf.acegisecurity.ConfigAttribute;
import net.sf.acegisecurity.ConfigAttributeDefinition;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.impl.AbstractPermissionTest;
import org.alfresco.repo.security.permissions.impl.SimplePermissionEntry;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoter;
import org.alfresco.repo.security.permissions.impl.acegi.ACLEntryVoterException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.experimental.categories.Category;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import org.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import org.springframework.aop.target.SingletonTargetSource;

@Category(value={OwnJVMTestsCategory.class})
public class ACLEntryVoterTest
extends AbstractPermissionTest {
    private static final String ANDY = "andy";
    private static final String ACL_NODE_0_SYS_BASE_READ = "ACL_NODE.0.sys:base.Read";
    private static final String TEST_LIST_OF_NODE_REFS = "testListOfNodeRefs";
    private static final String ABSTAIN = "ABSTAIN";
    private static final String DENIED = "Access denied";
    private static final String SHOULD_FAIL_DENIED = "Should fail because node is DENIED";
    private static final String SHOULD_FAIL_ABSTAINED = "Should fail because node is ABSTAINED";

    public void testBasicDenyNode() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, this.rootNodeRef);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        try {
            method.invoke(proxy, this.systemNodeRef);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.nodeService.deleteNode(this.systemNodeRef);
        ACLEntryVoterTest.assertNull((Object)method.invoke(proxy, this.systemNodeRef));
    }

    public void testBasicDenyStore() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneStoreRef", StoreRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, this.rootNodeRef.getStoreRef());
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    public void testAllowNullNode() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, new Object[1]);
    }

    public void testAllowNullStore() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneStoreRef", StoreRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, new Object[1]);
    }

    public void testAllowNullParentOnRealChildAssoc() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_PARENT.0.sys:base.Read");
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
    }

    public void testAllowNullParent() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_PARENT.0.sys:base.Read");
        method.invoke(proxy, new Object[1]);
    }

    public void testAllowNullChild() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, new Object[1]);
    }

    public void testBasicDenyChildAssocNode() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    public void testBasicDenyParentAssocNode() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_PARENT.0.sys:base.Read");
        try {
            method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    public void testBasicAllowNode() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, this.rootNodeRef);
    }

    public void testBasicAllow() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneNodeRef", NodeRef.class);
        Object proxy = this.getProxy(o, "ACL_ALLOW");
        method.invoke(proxy, this.rootNodeRef);
    }

    public void testBasicAllowStore() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneStoreRef", StoreRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, this.rootNodeRef.getStoreRef());
    }

    public void testBasicAllowChildAssocNode() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.rootNodeRef));
    }

    public void testBasicAllowParentAssocNode() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_PARENT.0.sys:base.Read");
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
    }

    public void testDenyParentAssocNode() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_PARENT.0.sys:base.Read");
        try {
            method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    public void testAllowChildAssocNode() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("ReadChildren"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testOneChildAssociationRef", ChildAssociationRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, this.nodeService.getPrimaryParent(this.systemNodeRef));
    }

    public void testMultiNodeMethodsArg0() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.rootNodeRef;
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[0] = this.rootNodeRef;
        method.invoke(proxy, objectArray);
    }

    public void testMultiNodeMethodsArg1() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        Object proxy = this.getProxy(o, "ACL_NODE.1.sys:base.Read");
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[1] = this.rootNodeRef;
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[1] = this.rootNodeRef;
        method.invoke(proxy, objectArray);
    }

    public void testMultiNodeMethodsArg2() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        Object proxy = this.getProxy(o, "ACL_NODE.2.sys:base.Read");
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[2] = this.rootNodeRef;
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[2] = this.rootNodeRef;
        method.invoke(proxy, objectArray);
    }

    public void testMultiNodeMethodsArg3() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyNodeRef", NodeRef.class, NodeRef.class, NodeRef.class, NodeRef.class);
        Object proxy = this.getProxy(o, "ACL_NODE.3.sys:base.Read");
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[3] = this.rootNodeRef;
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[3] = this.rootNodeRef;
        method.invoke(proxy, objectArray);
    }

    public void testMultiChildAssocRefMethodsArg0() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[0] = this.nodeService.getPrimaryParent(this.rootNodeRef);
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[0] = this.nodeService.getPrimaryParent(this.rootNodeRef);
        method.invoke(proxy, objectArray);
    }

    public void testMultiChildAssocRefMethodsArg1() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_NODE.1.sys:base.Read");
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[1] = this.nodeService.getPrimaryParent(this.rootNodeRef);
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[1] = this.nodeService.getPrimaryParent(this.rootNodeRef);
        method.invoke(proxy, objectArray);
    }

    public void testMultiChildAssocRefMethodsArg2() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_NODE.2.sys:base.Read");
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[2] = this.nodeService.getPrimaryParent(this.rootNodeRef);
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[2] = this.nodeService.getPrimaryParent(this.rootNodeRef);
        method.invoke(proxy, objectArray);
    }

    public void testMultiChildAssocRefMethodsArg3() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testManyChildAssociationRef", ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class, ChildAssociationRef.class);
        Object proxy = this.getProxy(o, "ACL_NODE.3.sys:base.Read");
        method.invoke(proxy, new Object[4]);
        try {
            Object[] objectArray = new Object[4];
            objectArray[3] = this.nodeService.getPrimaryParent(this.rootNodeRef);
            method.invoke(proxy, objectArray);
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        Object[] objectArray = new Object[4];
        objectArray[3] = this.nodeService.getPrimaryParent(this.rootNodeRef);
        method.invoke(proxy, objectArray);
    }

    public void testMethodACL() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testMethod", new Class[0]);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_METHOD.andy", "ACL_METHOD.BANANA")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[0]);
    }

    public void testMethodACL2() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testMethod", new Class[0]);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_METHOD.BANANA", "ACL_METHOD.GROUP_EVERYONE")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[0]);
    }

    public void testMethodACL3() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testMethod", new Class[0]);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_METHOD.andy", "ACL_METHOD.GROUP_EVERYONE")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        method.invoke(proxy, new Object[0]);
    }

    public void testMethodACL4() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod("testMethod", new Class[0]);
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor("ACL_METHOD.woof", "ACL_METHOD.BOO")));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource((Object)o));
        Object proxy = proxyFactory.getProxy();
        try {
            method.invoke(proxy, new Object[0]);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    public void testBasicAllowNodeCollection() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, Collections.singletonList(this.rootNodeRef));
    }

    public void testBasicDenyNodeCollection() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, Collections.singletonList(this.rootNodeRef));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    public void testAllowNullCollection() throws Exception {
        this.runAs(ANDY);
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, Collections.singletonList(null));
    }

    public void testAllowNodeCollection() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        method.invoke(proxy, Arrays.asList(this.systemNodeRef, this.systemNodeRef, this.systemNodeRef));
    }

    public void testDenyNodeCollectionWhenOneElementShouldBeDenied() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.systemNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, Arrays.asList(this.systemNodeRef, this.rootNodeRef, this.systemNodeRef));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    public void testSimpleAbstain() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.abstainedNode, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, Collections.singletonList(this.abstainedNode));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_ABSTAINED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessAbstain(e);
        }
    }

    public void testAbstainHasAPriorityOverDeny() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.abstainedNode, this.getPermission("Read"), ANDY, AccessStatus.DENIED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, Collections.singletonList(this.abstainedNode));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_ABSTAINED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessAbstain(e);
        }
    }

    public void testSimpleAbstainList() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.abstainedNode, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, Collections.singletonList(this.abstainedNode));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_ABSTAINED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessAbstain(e);
        }
    }

    public void testAbstainNodeCollectionWhenOneElementShouldBeAbstained() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.rootNodeRef, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.abstainedNode, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, Arrays.asList(this.rootNodeRef, this.abstainedNode, this.rootNodeRef));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_ABSTAINED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessAbstain(e);
        }
    }

    public void testDenyNodeCollectionWhenOneElementShouldBeDeniedAndThereAreAlsoAbstained() throws Exception {
        this.runAs(ANDY);
        this.permissionService.setPermission((PermissionEntry)new SimplePermissionEntry(this.abstainedNode, this.getPermission("Read"), ANDY, AccessStatus.ALLOWED));
        ClassWithMethods o = new ClassWithMethods();
        Method method = o.getClass().getMethod(TEST_LIST_OF_NODE_REFS, List.class);
        Object proxy = this.getProxy(o, ACL_NODE_0_SYS_BASE_READ);
        try {
            method.invoke(proxy, Arrays.asList(this.abstainedNode, this.systemNodeRef, this.abstainedNode));
            ACLEntryVoterTest.fail((String)SHOULD_FAIL_DENIED);
        }
        catch (InvocationTargetException e) {
            this.verifyAccessDenied(e);
        }
    }

    private void verifyAccessAbstain(InvocationTargetException e) {
        ACLEntryVoterTest.assertEquals((String)ABSTAIN, (String)e.getCause().getMessage());
    }

    private void verifyAccessDenied(InvocationTargetException e) {
        String causeMessage = e.getCause().getMessage();
        ACLEntryVoterTest.assertEquals((String)DENIED, (String)causeMessage.substring(causeMessage.length() - 13));
    }

    private Object getProxy(Object o, String s) {
        AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addAdvisor(advisorAdapterRegistry.wrap((Object)new Interceptor(s)));
        proxyFactory.setTargetSource((TargetSource)new SingletonTargetSource(o));
        return proxyFactory.getProxy();
    }

    public static class ClassWithMethods {
        public void testMethod() {
        }

        public void testOneStoreRef(StoreRef storeRef) {
        }

        public void testOneNodeRef(NodeRef nodeRef) {
        }

        public void testManyNodeRef(NodeRef nodeRef1, NodeRef nodeRef2, NodeRef nodeRef3, NodeRef nodeRef4) {
        }

        public void testOneChildAssociationRef(ChildAssociationRef car) {
        }

        public void testManyChildAssociationRef(ChildAssociationRef car1, ChildAssociationRef car2, ChildAssociationRef car3, ChildAssociationRef car4) {
        }

        public void testListOfNodeRefs(List listOfNodeRefs) {
        }
    }

    public class Interceptor
    implements MethodInterceptor {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();

        Interceptor(final String config1, final String config2) {
            this.cad.addConfigAttribute(new ConfigAttribute(){
                private static final long serialVersionUID = 1L;

                public String getAttribute() {
                    return config1;
                }
            });
            this.cad.addConfigAttribute(new ConfigAttribute(){
                private static final long serialVersionUID = 1L;

                public String getAttribute() {
                    return config2;
                }
            });
        }

        Interceptor(final String config) {
            this.cad.addConfigAttribute(new ConfigAttribute(){
                private static final long serialVersionUID = 1L;

                public String getAttribute() {
                    return config;
                }
            });
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            ACLEntryVoter voter = new ACLEntryVoter();
            voter.setNamespacePrefixResolver(ACLEntryVoterTest.this.namespacePrefixResolver);
            voter.setPermissionService((PermissionService)ACLEntryVoterTest.this.permissionService);
            voter.setNodeService(ACLEntryVoterTest.this.nodeService);
            voter.setAuthenticationService((AuthenticationService)ACLEntryVoterTest.this.authenticationService);
            voter.setAuthorityService(ACLEntryVoterTest.this.authorityService);
            HashSet<String> abstainFor = new HashSet<String>(2);
            abstainFor.add("{http://www.alfresco.org/model/content/1.0}emailed");
            abstainFor.add("{http://www.alfresco.org/model/content/1.0}failedThumbnail");
            voter.setAbstainFor(abstainFor);
            voter.afterPropertiesSet();
            int voteResult = voter.vote(null, (Object)invocation, this.cad);
            if (voteResult == -1) {
                throw new ACLEntryVoterException(ACLEntryVoterTest.DENIED);
            }
            if (voteResult == 0) {
                throw new RuntimeException(ACLEntryVoterTest.ABSTAIN);
            }
            return invocation.proceed();
        }
    }
}

