/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.serviceaccount;

import java.util.Optional;
import java.util.Properties;
import org.alfresco.repo.serviceaccount.ServiceAccountRegistryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceAccountRegistryImplTest {
    private ServiceAccountRegistryImpl serviceAccountService;
    private Properties globalProperties;

    @Before
    public void setUp() throws Exception {
        this.globalProperties = new Properties();
        this.globalProperties.put("system.test.property", "test-prop");
        this.globalProperties.put("repo.events.test.someKey", "test-event-value");
        this.serviceAccountService = new ServiceAccountRegistryImpl();
        this.serviceAccountService.setGlobalProperties(this.globalProperties);
        this.serviceAccountService.afterPropertiesSet();
    }

    @Test
    public void testNoDefinedServiceAccount() {
        Optional nonExistentSa = this.serviceAccountService.getServiceAccountRole("nonExistentServiceAccount");
        Assert.assertTrue((boolean)nonExistentSa.isEmpty());
        Assert.assertTrue((boolean)this.serviceAccountService.getServiceAccountNames().isEmpty());
    }

    @Test
    public void testInvalidServiceAccountName() {
        this.globalProperties.put("serviceaccount.role. ", "ROLE_ADMIN_SERVICE_ACCOUNT");
        Assert.assertTrue((String)"Invalid service account name.", (boolean)this.serviceAccountService.getServiceAccountNames().isEmpty());
    }

    @Test
    public void testInvalidServiceAccountRole() throws Exception {
        this.globalProperties.put("serviceaccount.role.testServiceAccount", "");
        this.serviceAccountService.afterPropertiesSet();
        Optional testServiceAccount = this.serviceAccountService.getServiceAccountRole("testServiceAccount");
        Assert.assertTrue((String)"Invalid service account role.", (boolean)testServiceAccount.isEmpty());
        Assert.assertTrue((boolean)this.serviceAccountService.getServiceAccountNames().isEmpty());
    }

    @Test
    public void testNotSupportedServiceAccountRole() throws Exception {
        this.globalProperties.put("serviceaccount.role.testServiceAccount", "testRole");
        this.serviceAccountService.afterPropertiesSet();
        Optional testServiceAccount = this.serviceAccountService.getServiceAccountRole("testServiceAccount");
        Assert.assertTrue((String)"Not supported service account role.", (boolean)testServiceAccount.isEmpty());
        Assert.assertTrue((boolean)this.serviceAccountService.getServiceAccountNames().isEmpty());
    }

    @Test
    public void testValidServiceAccount() throws Exception {
        this.globalProperties.put("serviceaccount.role.testServiceAccount", "ROLE_ADMIN_SERVICE_ACCOUNT");
        this.serviceAccountService.afterPropertiesSet();
        Optional testServiceAccount = this.serviceAccountService.getServiceAccountRole("testServiceAccount");
        Assert.assertFalse((String)"The service account role is not empty.", (boolean)testServiceAccount.isEmpty());
        Assert.assertEquals((Object)"ROLE_ADMIN_SERVICE_ACCOUNT", testServiceAccount.get());
        Assert.assertEquals((long)1L, (long)this.serviceAccountService.getServiceAccountNames().size());
    }

    @Test
    public void testManyServiceAccounts() throws Exception {
        this.globalProperties.put("serviceaccount.role.testEditorSA", "ROLE_EDITOR_SERVICE_ACCOUNT");
        this.globalProperties.put("serviceaccount.role.testCollaboratorSA", "ROLE_COLLABORATOR_SERVICE_ACCOUNT");
        this.globalProperties.put("serviceaccount.role.testAdminSA", "ROLE_ADMIN_SERVICE_ACCOUNT");
        this.serviceAccountService.afterPropertiesSet();
        Assert.assertEquals((long)3L, (long)this.serviceAccountService.getServiceAccountNames().size());
        Optional editorSA = this.serviceAccountService.getServiceAccountRole("testEditorSA");
        Assert.assertFalse((String)"The service account role is not empty.", (boolean)editorSA.isEmpty());
        Assert.assertEquals((Object)"ROLE_EDITOR_SERVICE_ACCOUNT", editorSA.get());
        Optional collaboratorSA = this.serviceAccountService.getServiceAccountRole("testCollaboratorSA");
        Assert.assertFalse((String)"The service account role is not empty.", (boolean)collaboratorSA.isEmpty());
        Assert.assertEquals((Object)"ROLE_COLLABORATOR_SERVICE_ACCOUNT", collaboratorSA.get());
        Optional adminSA = this.serviceAccountService.getServiceAccountRole("testAdminSA");
        Assert.assertFalse((String)"The service account role is not empty.", (boolean)adminSA.isEmpty());
        Assert.assertEquals((Object)"ROLE_ADMIN_SERVICE_ACCOUNT", adminSA.get());
    }

    @Test
    public void testValidServiceAccountRoleValues() throws Exception {
        this.globalProperties.put("serviceaccount.role.testEditorSA", "EDITOR_SERVICE_ACCOUNT");
        this.globalProperties.put("serviceaccount.role.testCollaboratorSA", "COLLABORATOR_SERVICE_ACCOUNT");
        this.globalProperties.put("serviceaccount.role.testAdminSA", "ADMIN_SERVICE_ACCOUNT");
        this.serviceAccountService.afterPropertiesSet();
        Assert.assertEquals((long)3L, (long)this.serviceAccountService.getServiceAccountNames().size());
        Optional editorSA = this.serviceAccountService.getServiceAccountRole("testEditorSA");
        Assert.assertFalse((String)"The service account role is not empty.", (boolean)editorSA.isEmpty());
        Assert.assertEquals((Object)"ROLE_EDITOR_SERVICE_ACCOUNT", editorSA.get());
        Optional collaboratorSA = this.serviceAccountService.getServiceAccountRole("testCollaboratorSA");
        Assert.assertFalse((String)"The service account role is not empty.", (boolean)collaboratorSA.isEmpty());
        Assert.assertEquals((Object)"ROLE_COLLABORATOR_SERVICE_ACCOUNT", collaboratorSA.get());
        Optional adminSA = this.serviceAccountService.getServiceAccountRole("testAdminSA");
        Assert.assertFalse((String)"The service account role is not empty.", (boolean)adminSA.isEmpty());
        Assert.assertEquals((Object)"ROLE_ADMIN_SERVICE_ACCOUNT", adminSA.get());
    }
}

