/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import java.util.LinkedList;
import org.alfresco.filesys.repo.NodeEvent;

public class NodeEventQueue {
    private LinkedList<NodeEvent> m_queue = new LinkedList();

    public final synchronized int numberOfEvents() {
        return this.m_queue.size();
    }

    public final synchronized void addEvent(NodeEvent event) {
        this.m_queue.add(event);
        this.notify();
    }

    public final synchronized NodeEvent removeEvent() throws InterruptedException {
        this.waitWhileEmpty();
        return this.m_queue.removeFirst();
    }

    public final synchronized NodeEvent removeSessionNoWait() {
        NodeEvent event = null;
        if (this.m_queue.size() > 0) {
            event = this.m_queue.removeFirst();
        }
        return event;
    }

    public final synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.m_queue.size() == 0) {
            this.wait();
        }
    }

    public final synchronized void waitUntilEmpty() throws InterruptedException {
        while (this.m_queue.size() != 0) {
            this.wait();
        }
    }
}

