/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.audit;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Map;

public class AuditRecord {
    private final boolean inTransaction;
    private final String auditApplicationId;
    private final ZonedDateTime createdAt;
    private final String username;
    private final Long entryDBId;
    private final Map<String, Serializable> auditData;

    public AuditRecord(Builder builder) {
        this.auditApplicationId = builder.auditRecordType;
        this.inTransaction = builder.inTransaction;
        this.auditData = builder.auditRecordData;
        this.createdAt = ZonedDateTime.now();
        this.username = builder.username;
        this.entryDBId = builder.entryDBId;
    }

    public String getAuditApplicationId() {
        return this.auditApplicationId;
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }

    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    public String getUsername() {
        return this.username;
    }

    public Long getEntryDBId() {
        return this.entryDBId;
    }

    public Map<String, Serializable> getAuditData() {
        return this.auditData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String auditRecordType;
        private boolean inTransaction;
        private Map<String, Serializable> auditRecordData;
        private String username;
        private Long entryDBId;

        public Builder setAuditRecordType(String auditRecordType) {
            this.auditRecordType = auditRecordType;
            return this;
        }

        public Builder setInTransaction(boolean inTransaction) {
            this.inTransaction = inTransaction;
            return this;
        }

        public Builder setAuditRecordData(Map<String, Serializable> auditRecordData) {
            this.auditRecordData = auditRecordData;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setEntryDBId(Long entryDBId) {
            this.entryDBId = entryDBId;
            return this;
        }

        public AuditRecord build() {
            return new AuditRecord(this);
        }
    }
}

