/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.oauth1;

import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.oauth1.OAuth1CredentialsStoreService;
import org.alfresco.service.cmr.remotecredentials.OAuth1CredentialsInfo;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.alfresco.util.PropertyMap;
import org.junit.After;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class OAuth1CredentialsStoreServiceTest
extends BaseSpringTest {
    private static OAuth1CredentialsStoreService oauth1CredentialsStoreService;
    private static ServiceRegistry serviceRegistry;
    private static RetryingTransactionHelper transactionHelper;
    private static MutableAuthenticationService authenticationService;
    private static PersonService personService;
    private static String RemoteSystemId;
    private static String Token;
    private static String Secret;
    private static String UpdatedToken;
    private static String UpdatedSecret;
    private static String TEST_USER_ONE;
    private static String TEST_USER_TWO;
    private static final String ADMIN_USER;

    static {
        RemoteSystemId = "Test-OAuth1RemoteSystem";
        Token = "123456789ABC";
        Secret = "CBA987654321";
        UpdatedToken = "abcdefghi123";
        UpdatedSecret = "321ihgfedcba";
        TEST_USER_ONE = OAuth1CredentialsStoreService.class.getSimpleName() + GUID.generate();
        TEST_USER_TWO = OAuth1CredentialsStoreService.class.getSimpleName() + GUID.generate();
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
    }

    @Before
    public void before() throws Exception {
        serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        transactionHelper = serviceRegistry.getTransactionService().getRetryingTransactionHelper();
        authenticationService = serviceRegistry.getAuthenticationService();
        personService = serviceRegistry.getPersonService();
        oauth1CredentialsStoreService = (OAuth1CredentialsStoreService)this.applicationContext.getBean("oauth1CredentialsStoreService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        OAuth1CredentialsStoreServiceTest.createUser(TEST_USER_ONE);
        OAuth1CredentialsStoreServiceTest.createUser(TEST_USER_TWO);
    }

    @After
    public void tearDown() throws Exception {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    @Test
    public void test1StorePersonalOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        oauth1CredentialsStoreService.storePersonalOAuth1Credentials(RemoteSystemId, Token, Secret);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = oauth1CredentialsStoreService.getPersonalOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)Token, (String)oAuth1CredentialsInfo.getOAuthToken());
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)Secret, (String)oAuth1CredentialsInfo.getOAuthSecret());
        oauth1CredentialsStoreService.storePersonalOAuth1Credentials(RemoteSystemId, UpdatedToken, UpdatedSecret);
        OAuth1CredentialsInfo _oAuth1CredentialsInfo = oauth1CredentialsStoreService.getPersonalOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)UpdatedToken, (String)_oAuth1CredentialsInfo.getOAuthToken());
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)UpdatedSecret, (String)_oAuth1CredentialsInfo.getOAuthSecret());
    }

    @Test
    public void test2StoreSharedOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        oauth1CredentialsStoreService.storeSharedOAuth1Credentials(RemoteSystemId, Token, Secret);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = (OAuth1CredentialsInfo)sharedCredentials.get(0);
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)Token, (String)oAuth1CredentialsInfo.getOAuthToken());
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)Secret, (String)oAuth1CredentialsInfo.getOAuthSecret());
    }

    @Test(expected=AccessDeniedException.class)
    public void test3SecureUpdateSharedOAuth1CredentialsTestUpdateSharedOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = (OAuth1CredentialsInfo)sharedCredentials.get(0);
        oauth1CredentialsStoreService.updateSharedOAuth1Credentials(oAuth1CredentialsInfo, RemoteSystemId, UpdatedToken, UpdatedSecret);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        oAuth1CredentialsInfo = (OAuth1CredentialsInfo)sharedCredentials.get(0);
        OAuth1CredentialsInfo _oAuth1CredentialsInfo = oauth1CredentialsStoreService.updateSharedOAuth1Credentials(oAuth1CredentialsInfo, RemoteSystemId, UpdatedToken, UpdatedSecret);
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect that access tokens will match", (String)UpdatedToken, (String)_oAuth1CredentialsInfo.getOAuthToken());
        OAuth1CredentialsStoreServiceTest.assertEquals((String)"Expect the refresh token will match", (String)UpdatedSecret, (String)_oAuth1CredentialsInfo.getOAuthSecret());
    }

    @Test
    public void test4DeletePesonalOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        boolean deleted = oauth1CredentialsStoreService.deletePersonalOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsStoreServiceTest.assertTrue((boolean)deleted);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        boolean _deleted = oauth1CredentialsStoreService.deletePersonalOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsStoreServiceTest.assertFalse((boolean)_deleted);
    }

    @Test(expected=AccessDeniedException.class)
    public void test5SecureDeleteSharedOAuth1CredentialsTestDeleteSharedOAuth1Credentials() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_TWO);
        List sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        OAuth1CredentialsInfo oAuth1CredentialsInfo = (OAuth1CredentialsInfo)sharedCredentials.get(0);
        oauth1CredentialsStoreService.deleteSharedOAuth1Credentials(RemoteSystemId, oAuth1CredentialsInfo);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER_ONE);
        sharedCredentials = oauth1CredentialsStoreService.listSharedOAuth1Credentials(RemoteSystemId);
        oAuth1CredentialsInfo = (OAuth1CredentialsInfo)sharedCredentials.get(0);
        boolean deleted = oauth1CredentialsStoreService.deleteSharedOAuth1Credentials(RemoteSystemId, oAuth1CredentialsInfo);
        OAuth1CredentialsStoreServiceTest.assertTrue((boolean)deleted);
    }

    private static void createUser(final String userName) {
        transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (!authenticationService.authenticationExists(userName)) {
                    authenticationService.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!personService.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
                    ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                    ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                    ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
                    ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                    personService.createPerson((Map)ppOne);
                }
                return null;
            }
        });
    }
}

