/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.NewVirtualReferenceMethod;
import org.alfresco.repo.virtual.ref.ProtocolMethod;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.template.ApplyTemplateMethod;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LuceneTests.class})
public class ApplyTemplateMethodTest
extends VirtualizationIntegrationTest {
    @Category(value={RedundantTests.class})
    @Test
    public void testExecute_vanillaISO9075ActualPath() throws Exception {
        ChildAssociationRef iso9075FolderAssoc = this.createFolder(this.testRootFolder.getNodeRef(), "Acutal ISO9075 Node");
        NodeRef iso9075Folder = iso9075FolderAssoc.getChildRef();
        NewVirtualReferenceMethod newVirtualReferenceMethod = new NewVirtualReferenceMethod("C/org/alfresco/repo/virtual/template/testTemplate5.json", "/", iso9075Folder, "/org/alfresco/repo/virtual/node/vanilla.js");
        ApplyTemplateMethod applyTemplateMethod = new ApplyTemplateMethod(this.environment);
        Reference ref = (Reference)Protocols.VANILLA.protocol.dispatch((ProtocolMethod)newVirtualReferenceMethod, null);
        VirtualFolderDefinition structure = (VirtualFolderDefinition)ref.execute((ProtocolMethod)applyTemplateMethod);
        VirtualFolderDefinition sfp5 = structure.findChildByName("SpecialFilingPath5");
        VirtualQuery query = sfp5.getQuery();
        Assert.assertEquals((Object)"(PATH:'/app:company_home/cm:TestFolder/cm:Acutal_x0020_ISO9075_x0020_Node/cm:Space_x0020_Sub_x0020_Folder/*')  and =cm:description:'SpecialFilingPath_5'", (Object)query.getQueryString());
        ChildAssociationRef iso9075SubFolderAssoc = this.createFolder(iso9075Folder, "Space Sub Folder");
        ChildAssociationRef someContentAssoc = this.createContent(iso9075SubFolderAssoc.getChildRef(), "someContent");
        this.nodeService.setProperty(someContentAssoc.getChildRef(), ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"SpecialFilingPath_5"));
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setQuery(query.getQueryString());
        searchParameters.addStore(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        searchParameters.setLanguage(query.getLanguage());
    }

    @Test
    public void testExecute_virtualSysClasspath() throws Exception {
        ApplyTemplateMethod applyTemplateMethod = new ApplyTemplateMethod(this.environment);
        NewVirtualReferenceMethod newVirtualReferenceMethod = new NewVirtualReferenceMethod("C/org/alfresco/repo/virtual/template/testTemplate1.js", "/", this.rootNodeRef, null);
        Reference ref = (Reference)Protocols.VIRTUAL.protocol.dispatch((ProtocolMethod)newVirtualReferenceMethod, null);
        VirtualFolderDefinition structure = (VirtualFolderDefinition)ref.execute((ProtocolMethod)applyTemplateMethod);
        String templateName = structure.getName();
        Assert.assertEquals((Object)"template1_name", (Object)templateName);
        List children = structure.getChildren();
        Assert.assertEquals((long)3L, (long)children.size());
        VirtualFolderDefinition child1 = structure.findChildByName("My Documents");
        Assert.assertTrue((child1 != null ? 1 : 0) != 0);
        VirtualFolderDefinition child2 = structure.findChildByName("Recent Documents");
        Assert.assertTrue((child2 != null ? 1 : 0) != 0);
        VirtualFolderDefinition child3 = structure.findChildByName("Other Documents");
        Assert.assertTrue((child3 != null ? 1 : 0) != 0);
    }

    @Test
    public void testExecute_vanillaRepositoryJSON() throws Exception {
        ChildAssociationRef templateAssoc = this.createContent(this.testRootFolder.getNodeRef(), "template1.json", ApplyTemplateMethodTest.class.getResourceAsStream("testTemplate1.json"), "application/json", StandardCharsets.UTF_8.name());
        ApplyTemplateMethod applyTemplateMethod = new ApplyTemplateMethod(this.environment);
        NewVirtualReferenceMethod newVirtualReferenceMethod = new NewVirtualReferenceMethod(templateAssoc.getChildRef(), "/", this.virtualFolder1NodeRef, "/org/alfresco/repo/virtual/node/vanilla.js");
        Reference ref = (Reference)Protocols.VANILLA.protocol.dispatch((ProtocolMethod)newVirtualReferenceMethod, null);
        VirtualFolderDefinition structure = (VirtualFolderDefinition)ref.execute((ProtocolMethod)applyTemplateMethod);
        String templateName = structure.getName();
        Assert.assertEquals((Object)"Test", (Object)templateName);
        List children = structure.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        VirtualFolderDefinition child1 = structure.findChildByName("Node1");
        Assert.assertTrue((child1 != null ? 1 : 0) != 0);
        VirtualFolderDefinition child2 = structure.findChildByName("Node2");
        Assert.assertTrue((child2 != null ? 1 : 0) != 0);
    }

    @Category(value={RedundantTests.class})
    @Test
    public void testExecuteRepositoryJS() throws Exception {
    }
}

