/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.filestore;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.content.AbstractContentReader;
import org.alfresco.repo.content.AbstractContentStore;
import org.alfresco.repo.content.ContentStoreCreatedEvent;
import org.alfresco.repo.content.EmptyContentReader;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.content.filestore.FileContentUrlProvider;
import org.alfresco.repo.content.filestore.FileContentWriter;
import org.alfresco.repo.content.filestore.SpoofedTextContentReader;
import org.alfresco.repo.content.filestore.TimeBasedFileContentUrlProvider;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.util.Deleter;
import org.alfresco.util.Pair;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

@AlfrescoPublicApi
public class FileContentStore
extends AbstractContentStore
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    public static final String STORE_PROTOCOL = "store";
    public static final String SPOOF_PROTOCOL = "spoof";
    private static final Log logger = LogFactory.getLog(FileContentStore.class);
    private File rootDirectory;
    private String rootAbsolutePath;
    private boolean allowRandomAccess;
    private boolean readOnly;
    private ApplicationContext applicationContext;
    private boolean deleteEmptyDirs = true;
    private FileContentUrlProvider fileContentUrlProvider = new TimeBasedFileContentUrlProvider();

    FileContentStore(String rootDirectoryStr) {
        this(new File(rootDirectoryStr));
    }

    private FileContentStore(File rootDirectory) {
        if (!rootDirectory.exists() && !rootDirectory.mkdirs()) {
            throw new ContentIOException("Failed to create store root: " + String.valueOf(rootDirectory), null);
        }
        this.rootDirectory = rootDirectory.getAbsoluteFile();
        this.rootAbsolutePath = rootDirectory.getAbsolutePath();
        this.allowRandomAccess = true;
        this.readOnly = false;
    }

    public FileContentStore(ApplicationContext context, String rootDirectoryStr) {
        this(rootDirectoryStr);
        this.setApplicationContext(context);
        this.publishEvent(context, Collections.emptyMap());
    }

    public FileContentStore(ApplicationContext context, File rootDirectory) {
        this(rootDirectory);
        this.setApplicationContext(context);
        this.publishEvent(context, Collections.emptyMap());
    }

    public FileContentStore(ApplicationContext context, File rootDirectory, Map<String, Serializable> extendedEventParams) {
        this(rootDirectory);
        this.setApplicationContext(context);
        this.publishEvent(context, extendedEventParams);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(36);
        sb.append("FileContentStore").append("[ root=").append(this.rootDirectory).append(", allowRandomAccess=").append(this.allowRandomAccess).append(", readOnly=").append(this.readOnly).append("]");
        return sb.toString();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAllowRandomAccess(boolean allowRandomAccess) {
        this.allowRandomAccess = allowRandomAccess;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setFileContentUrlProvider(FileContentUrlProvider fileContentUrlProvider) {
        this.fileContentUrlProvider = fileContentUrlProvider;
    }

    File createNewFile() throws IOException {
        String contentUrl = this.fileContentUrlProvider.createNewFileStoreUrl();
        return this.createNewFile(contentUrl);
    }

    File createNewFile(String newContentUrl) throws IOException {
        boolean created;
        if (this.readOnly) {
            throw new UnsupportedOperationException("This store is currently read-only: " + String.valueOf(this));
        }
        File file = this.makeFile(newContentUrl);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            this.makeDirectory(dir);
        }
        if (!(created = file.createNewFile())) {
            throw new ContentIOException("When specifying a URL for new content, the URL may not be in use already. \n   store: " + String.valueOf(this) + "\n   new URL: " + newContentUrl);
        }
        return file;
    }

    private synchronized void makeDirectory(File dir) throws IOException {
        if (dir.exists()) {
            return;
        }
        int i = 0;
        while (i < 20) {
            boolean created = dir.mkdirs();
            if (created) {
                return;
            }
            try {
                this.wait(20L);
            }
            catch (InterruptedException interruptedException) {}
            if (dir.exists()) {
                return;
            }
            ++i;
        }
        throw new ContentIOException("Failed to create directory for file storage: " + String.valueOf(dir));
    }

    String makeContentUrl(File file) {
        String path = file.getAbsolutePath();
        if (!path.startsWith(this.rootAbsolutePath)) {
            throw new AlfrescoRuntimeException("File does not fall below the store's root: \n   file: " + String.valueOf(file) + "\n   store: " + String.valueOf(this));
        }
        int index = this.rootAbsolutePath.length();
        if (path.charAt(index) == File.separatorChar) {
            ++index;
        }
        Object url = "store://" + path.substring(index);
        url = ((String)url).replace('\\', '/');
        return url;
    }

    File makeFile(String contentUrl) {
        Pair<String, String> urlParts = super.getContentUrlParts(contentUrl);
        String protocol = (String)urlParts.getFirst();
        String relativePath = (String)urlParts.getSecond();
        if (!protocol.equals(STORE_PROTOCOL)) {
            throw new UnsupportedContentUrlException(this, protocol + "://" + relativePath);
        }
        File file = new File(this.rootDirectory, relativePath);
        this.ensureFileInContentStore(file);
        return file;
    }

    public boolean isWriteSupported() {
        return !this.readOnly;
    }

    @Override
    public boolean exists(String contentUrl) {
        if (contentUrl.startsWith(SPOOF_PROTOCOL)) {
            return true;
        }
        File file = this.makeFile(contentUrl);
        return file.exists();
    }

    @Override
    public long getSpaceFree() {
        return this.rootDirectory.getFreeSpace();
    }

    @Override
    public long getSpaceTotal() {
        return this.rootDirectory.getTotalSpace();
    }

    @Override
    public String getRootLocation() {
        try {
            return this.rootDirectory.getCanonicalPath();
        }
        catch (Throwable e) {
            logger.warn((Object)"Unabled to return root location", e);
            return super.getRootLocation();
        }
    }

    public ContentReader getReader(String contentUrl) {
        if (contentUrl.startsWith(SPOOF_PROTOCOL)) {
            return new SpoofedTextContentReader(contentUrl);
        }
        try {
            File file = this.makeFile(contentUrl);
            AbstractContentReader reader = null;
            if (file.exists()) {
                FileContentReader fileContentReader = new FileContentReader(file, contentUrl);
                fileContentReader.setAllowRandomAccess(this.allowRandomAccess);
                reader = fileContentReader;
            } else {
                reader = new EmptyContentReader(contentUrl);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created content reader: \n   url: " + contentUrl + "\n   file: " + String.valueOf(file) + "\n   reader: " + String.valueOf(reader)));
            }
            return reader;
        }
        catch (UnsupportedContentUrlException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ContentIOException("Failed to get reader for URL: " + contentUrl, e);
        }
    }

    @Override
    public ContentWriter getWriterInternal(ContentReader existingContentReader, String newContentUrl) {
        try {
            File file = null;
            String contentUrl = null;
            if (newContentUrl == null) {
                file = this.createNewFile();
                contentUrl = this.makeContentUrl(file);
            } else {
                file = this.createNewFile(newContentUrl);
                contentUrl = newContentUrl;
            }
            FileContentWriter writer = new FileContentWriter(file, contentUrl, existingContentReader);
            if (this.contentLimitProvider != null) {
                writer.setContentLimitProvider(this.contentLimitProvider);
            }
            writer.setAllowRandomAccess(this.allowRandomAccess);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created content writer: \n   writer: " + String.valueOf(writer)));
            }
            return writer;
        }
        catch (IOException e) {
            throw new ContentIOException("Failed to get writer", (Throwable)e);
        }
    }

    @Override
    public boolean delete(String contentUrl) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("This store is currently read-only: " + String.valueOf(this));
        }
        if (contentUrl.startsWith(SPOOF_PROTOCOL)) {
            return false;
        }
        File file = this.makeFile(contentUrl);
        boolean deleted = false;
        deleted = !file.exists() ? true : file.delete();
        if (this.deleteEmptyDirs && deleted) {
            Deleter.deleteEmptyParents((File)file, (String)this.getRootLocation());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Delete content directly: \n   store: " + String.valueOf(this) + "\n   url: " + contentUrl));
        }
        return deleted;
    }

    public static String createNewFileStoreUrl() {
        return TimeBasedFileContentUrlProvider.createNewFileStoreUrl(0);
    }

    private void publishEvent(ApplicationContext context, Map<String, Serializable> extendedEventParams) {
        context.publishEvent((ApplicationEvent)new ContentStoreCreatedEvent(this, extendedEventParams));
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent && event.getSource() == this.applicationContext) {
            this.publishEvent(((ContextRefreshedEvent)event).getApplicationContext(), Collections.emptyMap());
        }
    }

    public void setDeleteEmptyDirs(boolean deleteEmptyDirs) {
        this.deleteEmptyDirs = deleteEmptyDirs;
    }

    private void ensureFileInContentStore(File file) {
        String rootNormalizedAbsolutePath;
        String fileNormalizedAbsoultePath = FilenameUtils.normalize((String)file.getAbsolutePath());
        if (!fileNormalizedAbsoultePath.startsWith(rootNormalizedAbsolutePath = FilenameUtils.normalize((String)this.rootAbsolutePath))) {
            throw new ContentIOException("Access to files outside of content store root is not allowed: " + String.valueOf(file));
        }
    }
}

