/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.GetNodesWithAspectCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.AbstractCannedQueryPermissions;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetNodesWithAspectCannedQuery
extends AbstractCannedQueryPermissions<NodeRef> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private NodeDAO nodeDAO;
    private TenantService tenantService;

    public GetNodesWithAspectCannedQuery(NodeDAO nodeDAO, TenantService tenantService, MethodSecurityBean<NodeRef> methodSecurity, CannedQueryParameters params) {
        super(params, methodSecurity);
        this.nodeDAO = nodeDAO;
        this.tenantService = tenantService;
    }

    protected List<NodeRef> queryAndFilter(CannedQueryParameters parameters) {
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetNodesWithAspectCannedQueryParams paramBean = (GetNodesWithAspectCannedQueryParams)parameters.getParameterBean();
        final StoreRef storeRef = paramBean.getStoreRef();
        Set<QName> aspectQNames = paramBean.getAspectQNames();
        final ArrayList<NodeRef> result = new ArrayList<NodeRef>(100);
        this.nodeDAO.getNodesWithAspects(aspectQNames, Long.MIN_VALUE, Long.MAX_VALUE, new NodeDAO.NodeRefQueryCallback(){

            @Override
            public boolean handle(Pair<Long, NodeRef> nodePair) {
                NodeRef nodeRef = (NodeRef)nodePair.getSecond();
                if (storeRef == null || nodeRef.getStoreRef().equals((Object)storeRef)) {
                    result.add(nodeRef);
                }
                return true;
            }
        });
        if (start != null) {
            this.logger.debug((Object)("Base query: " + result.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        return result;
    }
}

