/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db.functions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.JoinType;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.ParentSupport;
import org.alfresco.repo.search.impl.querymodel.impl.db.PropertySupport;
import org.alfresco.repo.search.impl.querymodel.impl.db.TypeSupport;
import org.alfresco.repo.search.impl.querymodel.impl.db.UUIDSupport;
import org.alfresco.repo.search.impl.querymodel.impl.functions.Exists;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class DBExists
extends Exists
implements DBQueryBuilderComponent {
    DBQueryBuilderComponent builderSupport;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext, boolean supportBooleanFloatAndDouble) {
        PropertyArgument propertyArgument = (PropertyArgument)functionArgs.get("Property");
        Argument inverseArgument = functionArgs.get("Not");
        Boolean not = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)inverseArgument.getValue(functionContext));
        if (propertyArgument.getPropertyName().equals("cmis:parentId")) {
            ParentSupport parentSupport = new ParentSupport();
            if (not != null && not.equals(Boolean.TRUE)) {
                parentSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.NOTEXISTS);
                parentSupport.setLeftOuter(true);
            } else {
                parentSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EXISTS);
            }
            this.builderSupport = parentSupport;
        } else if (propertyArgument.getPropertyName().equals("cmis:objectId")) {
            UUIDSupport uuidSupport = new UUIDSupport();
            if (not != null && not.equals(Boolean.TRUE)) {
                uuidSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.NOTEXISTS);
                uuidSupport.setLeftOuter(true);
            } else {
                uuidSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EXISTS);
            }
            this.builderSupport = uuidSupport;
        } else if (propertyArgument.getPropertyName().equals("cmis:objectTypeId")) {
            TypeSupport typeSupport = new TypeSupport();
            if (not != null && not.equals(Boolean.TRUE)) {
                typeSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.NOTEXISTS);
                typeSupport.setJoinType(JoinType.LEFT);
            } else {
                typeSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EXISTS);
            }
            this.builderSupport = typeSupport;
        } else if (propertyArgument.getPropertyName().equals("cmis:baseTypeId")) {
            TypeSupport typeSupport = new TypeSupport();
            if (not != null && not.equals(Boolean.TRUE)) {
                typeSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.NOTEXISTS);
                typeSupport.setJoinType(JoinType.LEFT);
            } else {
                typeSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EXISTS);
            }
            this.builderSupport = typeSupport;
        } else if (propertyArgument.getPropertyName().equals("cmis:contentStreamMimeType")) {
            PropertySupport propertySupport = new PropertySupport();
            QName basePropertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(propertyArgument.getPropertyName()), (NamespacePrefixResolver)namespaceService));
            propertySupport.setPropertyQName(basePropertyQName);
            propertySupport.setPropertyDataType(DBQuery.getDataTypeDefinition(dictionaryService, basePropertyQName));
            propertySupport.setPair(qnameDAO.getQName(basePropertyQName));
            propertySupport.setJoinCommandType(DBQueryBuilderJoinCommandType.CONTENT_MIMETYPE);
            propertySupport.setFieldName("mimetype_str");
            if (not != null && not.equals(Boolean.TRUE)) {
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.NOTEXISTS);
                propertySupport.setLeftOuter(true);
            } else {
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EXISTS);
            }
            this.builderSupport = propertySupport;
        } else if (propertyArgument.getPropertyName().equals("cmis:contentStreamLength")) {
            PropertySupport propertySupport = new PropertySupport();
            QName basePropertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(propertyArgument.getPropertyName()), (NamespacePrefixResolver)namespaceService));
            propertySupport.setPropertyQName(basePropertyQName);
            propertySupport.setPropertyDataType(DBQuery.getDataTypeDefinition(dictionaryService, basePropertyQName));
            propertySupport.setPair(qnameDAO.getQName(basePropertyQName));
            propertySupport.setJoinCommandType(DBQueryBuilderJoinCommandType.CONTENT_URL);
            propertySupport.setFieldName("content_size");
            if (not != null && not.equals(Boolean.TRUE)) {
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.NOTEXISTS);
                propertySupport.setLeftOuter(true);
            } else {
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EXISTS);
            }
            this.builderSupport = propertySupport;
        } else {
            PropertySupport propertySupport = new PropertySupport();
            QName propertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(propertyArgument.getPropertyName()), (NamespacePrefixResolver)namespaceService));
            propertySupport.setPropertyQName(propertyQName);
            propertySupport.setPropertyDataType(DBQuery.getDataTypeDefinition(dictionaryService, propertyQName));
            propertySupport.setPair(qnameDAO.getQName(propertyQName));
            propertySupport.setJoinCommandType(DBQuery.getJoinCommandType(propertyQName));
            propertySupport.setFieldName(DBQuery.getFieldName(dictionaryService, propertyQName, supportBooleanFloatAndDouble));
            if (not != null && not.equals(Boolean.TRUE)) {
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.NOTEXISTS);
                propertySupport.setLeftOuter(true);
            } else {
                propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EXISTS);
            }
            this.builderSupport = propertySupport;
        }
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        this.builderSupport.buildJoins(singleJoins, multiJoins);
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        this.builderSupport.buildPredicateCommands(predicatePartCommands);
    }
}

