/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.regex.Pattern;
import org.alfresco.repo.virtual.ref.NodeIdHasher;
import org.alfresco.repo.virtual.ref.NodeRefHasher;
import org.alfresco.repo.virtual.ref.NotUuidNodeIdRadixHasher;
import org.alfresco.repo.virtual.ref.StoreRefHasher;
import org.alfresco.repo.virtual.ref.StoredStoreRefHasher;
import org.alfresco.repo.virtual.ref.UuidNodeIdRadixHasher;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.Pair;

class NodeRefRadixHasher
implements NodeRefHasher {
    public static final NodeRefRadixHasher RADIX_36_HASHER = new NodeRefRadixHasher(36);
    static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$");
    static final String NOT_UUID_FORMAT_MARKER = "X";
    private final StoreRefHasher storeRefHasher = new StoredStoreRefHasher();
    private final NodeIdHasher uuidNodeIdHasher;
    private final NodeIdHasher notUuidNodeIdHasher;

    public NodeRefRadixHasher() {
        this(16);
    }

    public NodeRefRadixHasher(int radix) {
        this.uuidNodeIdHasher = new UuidNodeIdRadixHasher(radix);
        this.notUuidNodeIdHasher = new NotUuidNodeIdRadixHasher(radix);
    }

    @Override
    public Pair<String, String> hash(NodeRef nodeRef) {
        StoreRef storeRef = nodeRef.getStoreRef();
        String storeHash = this.storeRefHasher.hash(storeRef);
        String id = nodeRef.getId();
        String idHash = this.idToIdHash(id);
        return new Pair((Object)storeHash, (Object)idHash);
    }

    private String idToIdHash(String id) {
        if (UUID_PATTERN.matcher(id).matches()) {
            return this.uuidNodeIdHasher.hash(id);
        }
        return NOT_UUID_FORMAT_MARKER + this.notUuidNodeIdHasher.hash(id);
    }

    @Override
    public NodeRef lookup(Pair<String, String> hash) {
        String storeHash = (String)hash.getFirst();
        StoreRef storeRef = this.storeRefHasher.lookup(storeHash);
        String hashId = (String)hash.getSecond();
        String id = this.hashIdToId(hashId);
        return new NodeRef(storeRef, id);
    }

    private String hashIdToId(String hashId) {
        if (hashId.startsWith(NOT_UUID_FORMAT_MARKER)) {
            String hashIdWithoutMarker = hashId.substring(NOT_UUID_FORMAT_MARKER.length());
            return this.notUuidNodeIdHasher.lookup(hashIdWithoutMarker);
        }
        return this.uuidNodeIdHasher.lookup(hashId);
    }
}

