/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.notification.NotificationContext;
import org.alfresco.service.cmr.notification.NotificationService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.namespace.QName;

public class WorkflowNotificationUtils {
    public static final String PROP_SEND_EMAIL_NOTIFICATIONS = "bpm_sendEMailNotifications";
    public static final String PROP_PACKAGE = "bpm_package";
    public static final String MSG_ASSIGNED_TASK = "assigned-task";
    public static final String MSG_NEW_POOLED_TASK = "new-pooled-task";
    public static final String ARG_WF_ID = "workflowId";
    public static final String ARG_WF_TITLE = "workflowTitle";
    public static final String ARG_WF_DESCRIPTION = "workflowDescription";
    public static final String ARG_WF_DUEDATE = "workflowDueDate";
    public static final String ARG_WF_PRIORITY = "workflowPriority";
    public static final String ARG_WF_POOLED = "workflowPooled";
    public static final String ARG_WF_DOCUMENTS = "workflowDocuments";
    public static final String ARG_WF_TENANT = "workflowTenant";
    public static String WF_ASSIGNED_TEMPLATE = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "wf-email-html-ftl").toString();
    private WorkflowService workflowService;
    private NodeService nodeService;
    private NotificationService notificationService;

    public void setWorkflowService(WorkflowService service) {
        this.workflowService = service;
    }

    public void setNodeService(NodeService service) {
        this.nodeService = service;
    }

    public void setNotificationService(NotificationService service) {
        this.notificationService = service;
    }

    public void sendWorkflowAssignedNotificationEMail(String taskId, String taskTitle, String description, Date dueDate, Integer priority, NodeRef workflowPackage, String[] assignedAuthorites, boolean pooled) {
        String tenant;
        NotificationContext notificationContext = new NotificationContext();
        String subject = null;
        subject = !pooled ? MSG_ASSIGNED_TASK : MSG_NEW_POOLED_TASK;
        notificationContext.setSubject(subject);
        notificationContext.setBodyTemplate(WF_ASSIGNED_TEMPLATE);
        HashMap<String, Serializable> templateArgs = new HashMap<String, Serializable>(7);
        templateArgs.put(ARG_WF_ID, (Serializable)((Object)taskId));
        templateArgs.put(ARG_WF_TITLE, (Serializable)((Object)taskTitle));
        templateArgs.put(ARG_WF_DESCRIPTION, (Serializable)((Object)description));
        if (dueDate != null) {
            templateArgs.put(ARG_WF_DUEDATE, dueDate);
        }
        if (priority != null) {
            templateArgs.put(ARG_WF_PRIORITY, priority);
        }
        templateArgs.put(ARG_WF_POOLED, Boolean.valueOf(pooled));
        if (workflowPackage != null) {
            List assocs = this.nodeService.getChildAssocs(workflowPackage);
            NodeRef[] docs = new NodeRef[assocs.size()];
            if (assocs.size() != 0) {
                int index = 0;
                for (ChildAssociationRef assoc : assocs) {
                    docs[index] = assoc.getChildRef();
                    ++index;
                }
                templateArgs.put(ARG_WF_DOCUMENTS, (Serializable)docs);
            }
        }
        if ((tenant = TenantUtil.getCurrentDomain()) != null) {
            templateArgs.put(ARG_WF_TENANT, (Serializable)((Object)tenant));
        }
        notificationContext.setTemplateArgs(templateArgs);
        String[] stringArray = assignedAuthorites;
        int n = assignedAuthorites.length;
        int n2 = 0;
        while (n2 < n) {
            Object assignedAuthority = stringArray[n2];
            notificationContext.addTo((String)assignedAuthority);
            ++n2;
        }
        notificationContext.setAsyncNotification(true);
        this.notificationService.sendNotification("email", notificationContext);
    }

    public void sendWorkflowAssignedNotificationEMail(String taskId, String taskType, String[] assignedAuthorites, boolean pooled) {
        WorkflowTask workflowTask = this.workflowService.getTaskById(taskId);
        Map<QName, Serializable> props = workflowTask.getProperties();
        Object title = taskType == null ? workflowTask.getTitle() : taskType + ".title";
        String description = (String)((Object)props.get(WorkflowModel.PROP_DESCRIPTION));
        Date dueDate = (Date)props.get(WorkflowModel.PROP_DUE_DATE);
        Integer priority = (Integer)props.get(WorkflowModel.PROP_PRIORITY);
        NodeRef workflowPackage = workflowTask.getPath().getInstance().getWorkflowPackage();
        this.sendWorkflowAssignedNotificationEMail(taskId, (String)title, description, dueDate, priority, workflowPackage, assignedAuthorites, pooled);
    }

    public void sendWorkflowAssignedNotificationEMail(String taskId, String taskType, String assignedAuthority, boolean pooled) {
        this.sendWorkflowAssignedNotificationEMail(taskId, taskType, new String[]{assignedAuthority}, pooled);
    }
}

