/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti;

import java.util.Collection;
import java.util.List;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.workflow.AbstractWorkflowNodeConverter;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNodeList;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;

public class ActivitiNodeConverter
extends AbstractWorkflowNodeConverter {
    private final ServiceRegistry serviceRegistry;

    public ActivitiNodeConverter(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public Object convertNode(NodeRef node) {
        return new ActivitiScriptNode(node, this.serviceRegistry);
    }

    @Override
    public List<? extends Object> convertNodes(Collection<NodeRef> values) {
        ActivitiScriptNodeList results = new ActivitiScriptNodeList();
        for (NodeRef node : values) {
            results.add(new ActivitiScriptNode(node, this.serviceRegistry));
        }
        return results;
    }

    @Override
    public NodeRef convertToNode(Object toConvert) {
        return ((ScriptNode)toConvert).getNodeRef();
    }

    @Override
    public boolean isSupported(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof ActivitiScriptNode) {
            return true;
        }
        return object instanceof ActivitiScriptNodeList;
    }
}

