/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.TransactionalCache;
import org.alfresco.repo.domain.contentdata.ContentUrlEntity;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeVersionKey;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.node.ContentPropertyRestrictionInterceptor;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.db.NodeHierarchyWalker;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DuplicateChildNodeNameException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={OwnJVMTestsCategory.class})
public class NodeServiceTest {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"multiprop");
    public static final QName PROP_QNAME_NAME = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"name");
    public static final QName ASSOC_QNAME_CHILDREN = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"child");
    public static ApplicationContextInit APP_CONTEXT_INIT = ApplicationContextInit.createStandardContextWithOverrides("classpath*:alfresco/ibatis/ibatis-test-context.xml");
    @ClassRule
    public static RuleChain staticRuleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT);
    private static Log logger = LogFactory.getLog(NodeServiceTest.class);
    private static ServiceRegistry serviceRegistry;
    private static NodeService nodeService;
    private static PersonService personService;
    private static ContentService contentService;
    private static PermissionService permissionService;
    private static NodeDAO nodeDAO;
    private static VersionService versionService;
    private static TransactionService txnService;
    private static PolicyComponent policyComponent;
    private static CannedQueryDAO cannedQueryDAOForTesting;
    private static SimpleCache<Serializable, TransactionalCache.ValueHolder<Serializable>> nodesCache;
    private static SimpleCache<Serializable, TransactionalCache.ValueHolder<Serializable>> propsCache;
    private static SimpleCache<Serializable, TransactionalCache.ValueHolder<Serializable>> aspectsCache;
    private static SimpleCache<Long, ContentUrlEntity> contentDataCache;
    private static SimpleCache<Long, ContentUrlEntity> contentUrlCache;
    private static Long deletedTypeQNameId;
    private static NodeRef rootNodeRef;
    private static final QName PROP_RESIDUAL;

    static {
        PROP_RESIDUAL = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)GUID.generate());
    }

    @BeforeClass
    public static void setup() throws Exception {
        I18NUtil.setLocale(null);
        serviceRegistry = (ServiceRegistry)APP_CONTEXT_INIT.getApplicationContext().getBean("ServiceRegistry");
        nodeService = serviceRegistry.getNodeService();
        personService = serviceRegistry.getPersonService();
        contentService = serviceRegistry.getContentService();
        permissionService = serviceRegistry.getPermissionService();
        nodeDAO = (NodeDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeDAO");
        versionService = serviceRegistry.getVersionService();
        txnService = serviceRegistry.getTransactionService();
        policyComponent = (PolicyComponent)APP_CONTEXT_INIT.getApplicationContext().getBean("policyComponent");
        cannedQueryDAOForTesting = (CannedQueryDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("cannedQueryDAOForTesting");
        nodesCache = (SimpleCache)APP_CONTEXT_INIT.getApplicationContext().getBean("node.nodesSharedCache");
        propsCache = (SimpleCache)APP_CONTEXT_INIT.getApplicationContext().getBean("node.propertiesSharedCache");
        aspectsCache = (SimpleCache)APP_CONTEXT_INIT.getApplicationContext().getBean("node.aspectsSharedCache");
        contentDataCache = (SimpleCache)APP_CONTEXT_INIT.getApplicationContext().getBean("contentDataCache");
        contentUrlCache = (SimpleCache)APP_CONTEXT_INIT.getApplicationContext().getBean("contentUrlCache");
        nodesCache.clear();
        propsCache.clear();
        aspectsCache.clear();
        contentDataCache.clear();
        contentUrlCache.clear();
        AuthenticationUtil.setRunAsUserSystem();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createStoreWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() {
                StoreRef storeRef = nodeService.createStore("workspace", "Test_" + System.nanoTime());
                return nodeService.getRootNode(storeRef);
            }
        };
        rootNodeRef = (NodeRef)txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createStoreWork);
        final QNameDAO qnameDAO = (QNameDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("qnameDAO");
        deletedTypeQNameId = (Long)txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                return (Long)qnameDAO.getOrCreateQName(ContentModel.TYPE_DELETED).getFirst();
            }
        });
    }

    @AfterClass
    public static void tearDown() {
        AuthenticationUtil.clearCurrentSecurityContext();
        I18NUtil.setLocale(null);
    }

    @Test
    public void testSetUp() throws Exception {
        Assert.assertNotNull((Object)rootNodeRef);
    }

    @Test
    public void testLocaleSupport() throws Exception {
        Locale locale = (Locale)nodeService.getProperty(rootNodeRef, ContentModel.PROP_LOCALE);
        Assert.assertNotNull((String)"Locale property must occur on every node", (Object)locale);
        Assert.assertEquals((String)"Expected default locale on the root node", (Object)I18NUtil.getLocale(), (Object)locale);
        Assert.assertTrue((String)"Every node must have sys:localized", (boolean)nodeService.hasAspect(rootNodeRef, ContentModel.ASPECT_LOCALIZED));
        I18NUtil.setLocale((Locale)Locale.CANADA_FRENCH);
        NodeRef nodeRef1 = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()), ContentModel.TYPE_CONTAINER, Collections.singletonMap(ContentModel.PROP_LOCALE, Locale.GERMAN)).getChildRef();
        Assert.assertTrue((String)"Every node must have sys:localized", (boolean)nodeService.hasAspect(nodeRef1, ContentModel.ASPECT_LOCALIZED));
        Assert.assertEquals((String)"Didn't set the explicit locale during create. ", (Object)Locale.GERMAN, (Object)nodeService.getProperty(nodeRef1, ContentModel.PROP_LOCALE));
        NodeRef nodeRef2 = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()), ContentModel.TYPE_CONTAINER).getChildRef();
        Assert.assertTrue((String)"Every node must have sys:localized", (boolean)nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_LOCALIZED));
        Assert.assertEquals((String)"Didn't set the locale during create. ", (Object)Locale.CANADA_FRENCH, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        I18NUtil.setLocale((Locale)Locale.CHINESE);
        nodeService.setProperty(nodeRef2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Chinese description"));
        I18NUtil.setLocale((Locale)Locale.FRENCH);
        nodeService.setProperty(nodeRef2, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"French description"));
        boolean wasMLAware = MLPropertyInterceptor.setMLAware((boolean)true);
        try {
            MLText checkDescription = (MLText)nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION);
            Assert.assertEquals((Object)"Chinese description", (Object)checkDescription.getValue(Locale.CHINESE));
            Assert.assertEquals((Object)"French description", (Object)checkDescription.getValue(Locale.FRENCH));
        }
        finally {
            MLPropertyInterceptor.setMLAware((boolean)wasMLAware);
        }
        Assert.assertEquals((String)"Node modification should not affect node locale. ", (Object)Locale.CANADA_FRENCH, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        nodeService.setProperty(nodeRef2, ContentModel.PROP_LOCALE, (Serializable)Locale.ITALY);
        Assert.assertEquals((String)"Node locale must be settable. ", (Object)Locale.ITALY, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        Assert.assertEquals((String)"Canada-French must be closest to French. ", (Object)"French description", (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION));
        nodeService.setProperty(nodeRef2, ContentModel.PROP_LOCALE, null);
        Assert.assertEquals((String)"Node locale set to 'null' does nothing. ", (Object)Locale.ITALY, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        nodeService.removeProperty(nodeRef2, ContentModel.PROP_LOCALE);
        Assert.assertEquals((String)"Node locale removal does nothing. ", (Object)Locale.ITALY, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
        Map props = nodeService.getProperties(nodeRef2);
        props.put(ContentModel.PROP_LOCALE, Locale.GERMAN);
        nodeService.setProperties(nodeRef2, props);
        Assert.assertEquals((String)"Node locale not set in setProperties(). ", (Object)Locale.GERMAN, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_LOCALE));
    }

    private void buildNodeHierarchy(final NodeRef workspaceRootNodeRef, final NodeRef[] liveNodeRefs) {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setupCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<QName, CallSite> props = new HashMap<QName, CallSite>(3);
                props.put(ContentModel.PROP_NAME, (CallSite)((Object)("depth-0-" + GUID.generate())));
                liveNodeRefs[0] = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)"depth-0"), ContentModel.TYPE_FOLDER, props).getChildRef();
                int i = 1;
                while (i < liveNodeRefs.length) {
                    props.put(ContentModel.PROP_NAME, (CallSite)((Object)("depth-" + i)));
                    liveNodeRefs[i] = nodeService.createNode(liveNodeRefs[i - 1], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)("depth-" + i)), ContentModel.TYPE_FOLDER, props).getChildRef();
                    ++i;
                }
                return null;
            }
        };
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCallback);
    }

    @Test
    public void testRootAspect() throws Exception {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef[] nodes = new NodeRef[6];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodes);
        Set allRootNodes = nodeService.getAllRootNodes(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        int initialNumRootNodes = allRootNodes.size();
        nodeService.addAspect(nodes[1], ContentModel.ASPECT_ROOT, null);
        nodeService.addAspect(nodes[3], ContentModel.ASPECT_ROOT, null);
        nodeService.addAspect(nodes[4], ContentModel.ASPECT_ROOT, null);
        allRootNodes = nodeService.getAllRootNodes(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        Assert.assertEquals((String)"", (long)3L, (long)(allRootNodes.size() - initialNumRootNodes));
        List paths = nodeService.getPaths(nodes[5], false);
        Assert.assertEquals((String)"", (long)4L, (long)paths.size());
        nodeService.removeAspect(nodes[3], ContentModel.ASPECT_ROOT);
        allRootNodes = nodeService.getAllRootNodes(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        Assert.assertEquals((String)"", (long)2L, (long)(allRootNodes.size() - initialNumRootNodes));
        paths = nodeService.getPaths(nodes[5], false);
        for (Path path : paths) {
            System.out.println("Path = " + path.toString());
        }
        Assert.assertEquals((String)"", (long)3L, (long)paths.size());
    }

    public void testConcurrentArchive() throws Exception {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef[] nodesPrimer = new NodeRef[2];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodesPrimer);
        final NodeRef[] nodesOne = new NodeRef[15];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodesOne);
        final NodeRef[] nodesTwo = new NodeRef[10];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodesTwo);
        nodeService.deleteNode(nodesPrimer[0]);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> outerCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Throwable t;
                nodeService.deleteNode(nodesOne[0]);
                class InnerThread
                extends Thread {
                    private Throwable error;
                    private final /* synthetic */ NodeRef[] val$nodesTwo;

                    public InnerThread(NodeRef[] nodeRefArray) {
                        this.val$nodesTwo = nodeRefArray;
                        this.setDaemon(true);
                    }

                    public Throwable getError() {
                        return this.error;
                    }

                    @Override
                    public void run() {
                        AuthenticationUtil.setRunAsUserSystem();
                        RetryingTransactionHelper.RetryingTransactionCallback<Void> innerCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                            public Void execute() throws Throwable {
                                try {
                                    nodeService.deleteNode(val$nodesTwo[0]);
                                    return null;
                                }
                                catch (Throwable t) {
                                    throw new InnerCallbackException(t);
                                }
                            }
                        };
                        try {
                            txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)innerCallback, false, true);
                        }
                        catch (InnerCallbackException e) {
                            this.error = e.getHiddenCause();
                        }
                    }
                }
                InnerThread innerThread = new InnerThread(nodesTwo);
                innerThread.start();
                innerThread.join(30000L);
                if (innerThread.isAlive()) {
                    innerThread.interrupt();
                    Assert.fail((String)"Transaction hung for 30 seconds. Test failed.");
                }
                if ((t = innerThread.getError()) != null) {
                    throw t;
                }
                return null;
            }
        };
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)outerCallback, false, true);
    }

    @Test
    public void testArchiveAndRestore() {
        NodeRef.Status archivedStatus;
        NodeRef.Status liveStatus;
        NodeRef[] liveNodeRefs = new NodeRef[10];
        NodeRef[] archivedNodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        NodeRef archiveRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_ARCHIVE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        Long txnIdCreate = null;
        int i = 0;
        while (i < liveNodeRefs.length) {
            StoreRef archivedStoreRef = archiveRootNodeRef.getStoreRef();
            archivedNodeRefs[i] = new NodeRef(archivedStoreRef, liveNodeRefs[i].getId());
            liveStatus = nodeService.getNodeStatus(liveNodeRefs[i]);
            archivedStatus = nodeService.getNodeStatus(archivedNodeRefs[i]);
            Assert.assertNotNull((String)("'Live' node " + i + " status does not exist."), (Object)liveStatus);
            Assert.assertFalse((String)("'Live' node " + i + " should be node be deleted"), (boolean)liveStatus.isDeleted());
            Assert.assertNull((String)("'Archived' node " + i + " should not (yet) exist."), (Object)archivedStatus);
            if (txnIdCreate == null) {
                txnIdCreate = liveStatus.getDbTxnId();
            } else {
                Assert.assertEquals((String)"DB TXN ID should have been the same for the hierarchy. ", (Object)txnIdCreate, (Object)liveStatus.getDbTxnId());
            }
            ++i;
        }
        nodeService.deleteNode(liveNodeRefs[0]);
        Long txnIdDelete = null;
        int i2 = 0;
        while (i2 < liveNodeRefs.length) {
            liveStatus = nodeService.getNodeStatus(liveNodeRefs[i2]);
            archivedStatus = nodeService.getNodeStatus(archivedNodeRefs[i2]);
            Assert.assertNotNull((String)("'Live' node " + i2 + " status does not exist."), (Object)liveStatus);
            Assert.assertTrue((String)("'Live' node " + i2 + " should be deleted (ghost entries)"), (boolean)liveStatus.isDeleted());
            Assert.assertNotNull((String)("'Archived' node " + i2 + " does not exist."), (Object)archivedStatus);
            Assert.assertFalse((String)("'Archived' node " + i2 + " should be undeleted"), (boolean)archivedStatus.isDeleted());
            if (txnIdDelete == null) {
                txnIdDelete = liveStatus.getDbTxnId();
            } else {
                Assert.assertEquals((String)"DB TXN ID should have been the same for the deleted (ghost) nodes. ", (Object)txnIdDelete, (Object)liveStatus.getDbTxnId());
            }
            Assert.assertEquals((String)"DB TXN ID should be the same for deletes across the hierarchy", (Object)txnIdDelete, (Object)archivedStatus.getDbTxnId());
            ++i2;
        }
        nodeService.restoreNode(archivedNodeRefs[0], workspaceRootNodeRef, null, null);
        Long txnIdRestore = null;
        int i3 = 0;
        while (i3 < liveNodeRefs.length) {
            NodeRef.Status liveStatus2 = nodeService.getNodeStatus(liveNodeRefs[i3]);
            StoreRef archivedStoreRef = archiveRootNodeRef.getStoreRef();
            archivedNodeRefs[i3] = new NodeRef(archivedStoreRef, liveNodeRefs[i3].getId());
            NodeRef.Status archivedStatus2 = nodeService.getNodeStatus(archivedNodeRefs[i3]);
            Assert.assertNotNull((String)("'Live' node " + i3 + " status does not exist."), (Object)liveStatus2);
            Assert.assertFalse((String)("'Live' node " + i3 + " should not be deleted"), (boolean)liveStatus2.isDeleted());
            Assert.assertNotNull((String)("'Archived' node " + i3 + " does not exist."), (Object)archivedStatus2);
            Assert.assertTrue((String)("'Archived' node " + i3 + " should be deleted (ghost entry)"), (boolean)archivedStatus2.isDeleted());
            if (txnIdRestore == null) {
                txnIdRestore = liveStatus2.getDbTxnId();
            } else {
                Assert.assertEquals((String)"DB TXN ID should have been the same for the restored nodes. ", (Object)txnIdRestore, (Object)liveStatus2.getDbTxnId());
            }
            Assert.assertEquals((String)"DB TXN ID should be the same for the ex-archived (now-ghost) nodes. ", (Object)txnIdRestore, (Object)archivedStatus2.getDbTxnId());
            ++i3;
        }
    }

    @Test
    public void testGetAssocById() {
        AssociationRef assocRef = nodeService.getAssoc(Long.valueOf(Long.MAX_VALUE));
        Assert.assertNull((String)"Should get null for missing ID of association. ", (Object)assocRef);
    }

    @Test
    public void testDuplicateChildNodeName() {
        final NodeRef[] liveNodeRefs = new NodeRef[3];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        final String lastName = (String)((Object)nodeService.getProperty(liveNodeRefs[2], ContentModel.PROP_NAME));
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> newNodeCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>(3);
                props.put(ContentModel.PROP_NAME, lastName);
                return nodeService.createNode(liveNodeRefs[1], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)"duplicate"), ContentModel.TYPE_FOLDER, props).getChildRef();
            }
        };
        try {
            txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)newNodeCallback);
            Assert.fail((String)"Duplicate child node name not detected.");
        }
        catch (DuplicateChildNodeNameException duplicateChildNodeNameException) {}
    }

    @Test
    public void testGetChildren_Limited() {
        List childAssocRefs;
        NodeRef[] liveNodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        int i = 2;
        while (i < liveNodeRefs.length) {
            nodeService.addChild(liveNodeRefs[0], liveNodeRefs[i], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"));
            ++i;
        }
        i = 1;
        while (i < liveNodeRefs.length) {
            childAssocRefs = nodeService.getChildAssocs(liveNodeRefs[0], null, null, i, true);
            Assert.assertEquals((String)"Expected exact number of child assocs", (long)i, (long)childAssocRefs.size());
            ++i;
        }
        i = 1;
        while (i < liveNodeRefs.length) {
            childAssocRefs = nodeService.getChildAssocs(liveNodeRefs[0], null, null, i, false);
            Assert.assertEquals((String)"Expected exact number of child assocs", (long)i, (long)childAssocRefs.size());
            ++i;
        }
    }

    @Test
    public void testGetChildren() {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        int numberOfReferences = 3;
        NodeRef childNodeRef = this.setupTestGetChildren(workspaceRootNodeRef, numberOfReferences);
        List childAssocRefs = nodeService.getChildAssocs(childNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL, false);
        Assert.assertEquals((String)"Expected exact number of reference assocs", (long)numberOfReferences, (long)childAssocRefs.size());
        childAssocRefs = nodeService.getChildAssocs(childNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)new RegexQNamePattern(NAMESPACE, "reference*"), false);
        Assert.assertEquals((String)"Expected exact number of reference assocs", (long)numberOfReferences, (long)childAssocRefs.size());
        childAssocRefs = nodeService.getChildAssocs(childNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL, true);
        Assert.assertEquals((String)"Expected exact number of reference assocs", (long)numberOfReferences, (long)childAssocRefs.size());
        childAssocRefs = nodeService.getChildAssocs(childNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)new RegexQNamePattern(NAMESPACE, "reference*"), true);
        Assert.assertEquals((String)"Expected exact number of reference assocs", (long)numberOfReferences, (long)childAssocRefs.size());
        childAssocRefs = nodeService.getChildAssocs(childNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, RegexQNamePattern.MATCH_ALL, 1, true);
        Assert.assertEquals((String)"Expected exact number of reference assocs", (long)1L, (long)childAssocRefs.size());
        childAssocRefs = nodeService.getChildAssocs(childNodeRef, (QNamePattern)ContentModel.ASSOC_CONTAINS, (QNamePattern)new RegexQNamePattern(NAMESPACE, "reference*"), 1, true);
        Assert.assertEquals((String)"Expected exact number of reference assocs", (long)1L, (long)childAssocRefs.size());
    }

    private NodeRef setupTestGetChildren(final NodeRef workspaceRootNodeRef, final int numberOfReferences) {
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> setupCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                NodeRef[] referenceNodeRefs = new NodeRef[numberOfReferences];
                HashMap<QName, CallSite> folderProps = new HashMap<QName, CallSite>(3);
                folderProps.put(ContentModel.PROP_NAME, (CallSite)((Object)("folder-" + GUID.generate())));
                NodeRef folderNodeRef = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)"folder"), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
                int i = 0;
                while (i < numberOfReferences) {
                    HashMap<QName, CallSite> props = new HashMap<QName, CallSite>(3);
                    props.put(ContentModel.PROP_NAME, (CallSite)((Object)("reference-" + GUID.generate())));
                    referenceNodeRefs[i] = nodeService.createNode(folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)NodeServiceTest.NAMESPACE, (String)"reference"), ContentModel.TYPE_RATING, props).getChildRef();
                    ++i;
                }
                return folderNodeRef;
            }
        };
        return (NodeRef)txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setupCallback);
    }

    @Test
    public void testCaches_DeleteNode() {
        NodeRef[] liveNodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, liveNodeRefs);
        nodeService.addAspect(liveNodeRefs[3], ContentModel.ASPECT_TEMPORARY, null);
        HashMap<QName, String> props = new HashMap<QName, String>(3);
        props.put(ContentModel.PROP_NAME, "Secondary");
        NodeRef secondaryNodeRef = nodeService.createNode(liveNodeRefs[2], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"), ContentModel.TYPE_FOLDER, props).getChildRef();
        nodeService.addChild(liveNodeRefs[3], secondaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"));
        nodeService.addChild(liveNodeRefs[4], secondaryNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)"secondary"));
        List parentAssocsPre = nodeService.getParentAssocs(secondaryNodeRef);
        Assert.assertEquals((String)"Incorrect number of parent assocs", (long)3L, (long)parentAssocsPre.size());
        nodeService.deleteNode(liveNodeRefs[3]);
        List parentAssocsPost = nodeService.getParentAssocs(secondaryNodeRef);
        Assert.assertEquals((String)"Incorrect number of parent assocs", (long)1L, (long)parentAssocsPost.size());
    }

    @Test
    public void testCaches_RenameNode() {
        NodeRef[] nodeRefs = new NodeRef[2];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        String name = (String)((Object)nodeService.getProperty(nodeRefs[1], ContentModel.PROP_NAME));
        NodeRef nodeRefCheck = nodeService.getChildByName(nodeRefs[0], ContentModel.ASSOC_CONTAINS, name);
        Assert.assertNotNull((String)"Did not find node by name", (Object)nodeRefCheck);
        Assert.assertEquals((String)"Node found was not correct", (Object)nodeRefs[1], (Object)nodeRefCheck);
        nodeService.setProperty(nodeRefs[1], ContentModel.PROP_NAME, (Serializable)((Object)"New Name"));
        nodeRefCheck = nodeService.getChildByName(nodeRefs[0], ContentModel.ASSOC_CONTAINS, name);
        Assert.assertNull((String)"Should not have found anything", (Object)nodeRefCheck);
        NodeRef newChildNodeRef = nodeService.createNode(nodeRefs[0], ContentModel.ASSOC_CONTAINS, QName.createQName((String)NAMESPACE, (String)name), ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, name)).getChildRef();
        nodeRefCheck = nodeService.getChildByName(nodeRefs[0], ContentModel.ASSOC_CONTAINS, name);
        Assert.assertNotNull((String)"Did not find node by name", (Object)nodeRefCheck);
        Assert.assertEquals((String)"Node found was not correct", (Object)newChildNodeRef, (Object)nodeRefCheck);
    }

    private Object findCacheValue(SimpleCache<Serializable, TransactionalCache.ValueHolder<Serializable>> cache, Serializable key) {
        Collection keys = cache.getKeys();
        for (Serializable keyInCache : keys) {
            String keyStr;
            String keyInCacheStr = keyInCache.toString();
            if (!keyInCacheStr.endsWith(keyStr = key.toString())) continue;
            Object value = TransactionalCache.getSharedCacheValue(cache, (Serializable)keyInCache);
            return value;
        }
        return null;
    }

    @Test
    public void testCaches_ImmutableNodeCaches() throws Exception {
        NodeRef[] nodeRefs = new NodeRef[2];
        final NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        final NodeRef nodeRef = nodeRefs[1];
        Long nodeId = (Long)this.findCacheValue(nodesCache, (Serializable)nodeRef);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeId);
        Node nodeOne = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeOne);
        NodeVersionKey nodeKeyOne = nodeOne.getNodeVersionKey();
        Map nodePropsOne = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyOne);
        Set nodeAspectsOne = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyOne);
        Assert.assertEquals((String)"The node version is incorrect", (Object)1L, (Object)nodeKeyOne.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsOne);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsOne);
        Assert.assertEquals((String)"Property count incorrect", (long)1L, (long)nodePropsOne.size());
        Assert.assertNotNull((String)"Expected a cm:name property", nodePropsOne.get(ContentModel.PROP_NAME));
        Assert.assertEquals((String)"Aspect count incorrect", (long)1L, (long)nodeAspectsOne.size());
        Assert.assertTrue((String)"Expected a cm:auditable aspect", (boolean)nodeAspectsOne.contains(ContentModel.ASPECT_AUDITABLE));
        nodeService.setProperty(nodeRef, PROP_RESIDUAL, (Serializable)((Object)GUID.generate()));
        Map nodePropsOneCheck = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyOne);
        Set nodeAspectsOneCheck = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyOne);
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodePropsOneCheck.equals(nodePropsOne));
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodeAspectsOneCheck.equals(nodeAspectsOne));
        Node nodeTwo = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeTwo);
        NodeVersionKey nodeKeyTwo = nodeTwo.getNodeVersionKey();
        Map nodePropsTwo = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyTwo);
        Set nodeAspectsTwo = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyTwo);
        Assert.assertEquals((String)"The node version is incorrect", (Object)2L, (Object)nodeKeyTwo.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsTwo);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsTwo);
        Assert.assertFalse((String)"Properties must have moved on", (boolean)nodePropsTwo.equals(nodePropsOne));
        Assert.assertEquals((String)"Property count incorrect", (long)2L, (long)nodePropsTwo.size());
        Assert.assertNotNull((String)"Expected a cm:name property", nodePropsTwo.get(ContentModel.PROP_NAME));
        Assert.assertNotNull((String)"Expected a residual property", nodePropsTwo.get(PROP_RESIDUAL));
        Assert.assertTrue((String)"Aspects must be carried", (boolean)nodeAspectsTwo.equals(nodeAspectsOne));
        nodeService.removeProperty(nodeRef, PROP_RESIDUAL);
        Map nodePropsTwoCheck = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyTwo);
        Set nodeAspectsTwoCheck = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyTwo);
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodePropsTwoCheck.equals(nodePropsTwo));
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodeAspectsTwoCheck.equals(nodeAspectsTwo));
        Node nodeThree = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeThree);
        NodeVersionKey nodeKeyThree = nodeThree.getNodeVersionKey();
        Map nodePropsThree = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyThree);
        Set nodeAspectsThree = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyThree);
        Assert.assertEquals((String)"The node version is incorrect", (Object)3L, (Object)nodeKeyThree.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsThree);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsThree);
        Assert.assertFalse((String)"Properties must have moved on", (boolean)nodePropsThree.equals(nodePropsTwo));
        Assert.assertEquals((String)"Property count incorrect", (long)1L, (long)nodePropsThree.size());
        Assert.assertNotNull((String)"Expected a cm:name property", nodePropsThree.get(ContentModel.PROP_NAME));
        Assert.assertNull((String)"Expected no residual property", nodePropsThree.get(PROP_RESIDUAL));
        Assert.assertTrue((String)"Aspects must be carried", (boolean)nodeAspectsThree.equals(nodeAspectsTwo));
        nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, null);
        Map nodePropsThreeCheck = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyThree);
        Set nodeAspectsThreeCheck = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyThree);
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodePropsThreeCheck.equals(nodePropsThree));
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodeAspectsThreeCheck.equals(nodeAspectsThree));
        Node nodeFour = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeFour);
        NodeVersionKey nodeKeyFour = nodeFour.getNodeVersionKey();
        Map nodePropsFour = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyFour);
        Set nodeAspectsFour = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyFour);
        Assert.assertEquals((String)"The node version is incorrect", (Object)4L, (Object)nodeKeyFour.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsFour);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsFour);
        Assert.assertTrue((String)"Properties must be carried", (boolean)nodePropsFour.equals(nodePropsThree));
        Assert.assertFalse((String)"Aspects must have moved on", (boolean)nodeAspectsFour.equals(nodeAspectsThree));
        Assert.assertTrue((String)"Expected cm:titled aspect", (boolean)nodeAspectsFour.contains(ContentModel.ASPECT_TITLED));
        nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TITLED);
        Map nodePropsFourCheck = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyFour);
        Set nodeAspectsFourCheck = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyFour);
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodePropsFourCheck.equals(nodePropsFour));
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodeAspectsFourCheck.equals(nodeAspectsFour));
        Node nodeFive = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeFive);
        NodeVersionKey nodeKeyFive = nodeFive.getNodeVersionKey();
        Map nodePropsFive = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyFive);
        Set nodeAspectsFive = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyFive);
        Assert.assertEquals((String)"The node version is incorrect", (Object)5L, (Object)nodeKeyFive.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsFive);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsFive);
        Assert.assertTrue((String)"Properties must be carried", (boolean)nodePropsFive.equals(nodePropsFour));
        Assert.assertFalse((String)"Aspects must have moved on", (boolean)nodeAspectsFive.equals(nodeAspectsFour));
        Assert.assertFalse((String)"Expected no cm:titled aspect ", (boolean)nodeAspectsFive.contains(ContentModel.ASPECT_TITLED));
        RetryingTransactionHelper.RetryingTransactionCallback<Void> nodeSixWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                HashMap<QName, String> props = new HashMap<QName, String>();
                props.put(ContentModel.PROP_TITLE, "some title");
                nodeService.addAspect(nodeRef, ContentModel.ASPECT_TITLED, props);
                nodeService.setProperty(nodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Some description"));
                return null;
            }
        };
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)nodeSixWork);
        Map nodePropsFiveCheck = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyFive);
        Set nodeAspectsFiveCheck = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyFive);
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodePropsFiveCheck.equals(nodePropsFive));
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodeAspectsFiveCheck.equals(nodeAspectsFive));
        Node nodeSix = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeSix);
        NodeVersionKey nodeKeySix = nodeSix.getNodeVersionKey();
        Map nodePropsSix = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeySix);
        Set nodeAspectsSix = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeySix);
        Assert.assertEquals((String)"The node version is incorrect", (Object)6L, (Object)nodeKeySix.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsSix);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsSix);
        Assert.assertFalse((String)"Properties must have moved on", (boolean)nodePropsSix.equals(nodePropsFive));
        Assert.assertEquals((String)"Property count incorrect", (long)3L, (long)nodePropsSix.size());
        Assert.assertNotNull((String)"Expected a cm:name property", nodePropsSix.get(ContentModel.PROP_NAME));
        Assert.assertNotNull((String)"Expected a cm:title property", nodePropsSix.get(ContentModel.PROP_TITLE));
        Assert.assertNotNull((String)"Expected a cm:description property", nodePropsSix.get(ContentModel.PROP_DESCRIPTION));
        Assert.assertFalse((String)"Aspects must have moved on", (boolean)nodeAspectsSix.equals(nodeAspectsFive));
        Assert.assertTrue((String)"Expected cm:titled aspect ", (boolean)nodeAspectsSix.contains(ContentModel.ASPECT_TITLED));
        RetryingTransactionHelper.RetryingTransactionCallback<Void> nodeSevenWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                nodeService.removeAspect(nodeRef, ContentModel.ASPECT_TITLED);
                nodeService.removeChild(workspaceRootNodeRef, nodeRef);
                return null;
            }
        };
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)nodeSevenWork);
        Map nodePropsSixCheck = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeySix);
        Set nodeAspectsSixCheck = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeySix);
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodePropsSixCheck.equals(nodePropsSix));
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodeAspectsSixCheck.equals(nodeAspectsSix));
        Node nodeSeven = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeSeven);
        NodeVersionKey nodeKeySeven = nodeSeven.getNodeVersionKey();
        Map nodePropsSeven = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeySeven);
        Set nodeAspectsSeven = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeySeven);
        Assert.assertEquals((String)"The node version is incorrect", (Object)7L, (Object)nodeKeySeven.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsSeven);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsSeven);
        Assert.assertFalse((String)"Properties must have moved on", (boolean)nodePropsSeven.equals(nodePropsSix));
        Assert.assertEquals((String)"Property count incorrect", (long)1L, (long)nodePropsSeven.size());
        Assert.assertNotNull((String)"Expected a cm:name property", nodePropsSeven.get(ContentModel.PROP_NAME));
        Assert.assertFalse((String)"Aspects must have moved on", (boolean)nodeAspectsSeven.equals(nodeAspectsSix));
        Assert.assertFalse((String)"Expected no cm:titled aspect ", (boolean)nodeAspectsSeven.contains(ContentModel.ASPECT_TITLED));
        RetryingTransactionHelper.RetryingTransactionCallback<Void> nodeEightWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                BehaviourFilter behaviourFilter = (BehaviourFilter)APP_CONTEXT_INIT.getApplicationContext().getBean("policyBehaviourFilter");
                behaviourFilter.disableBehaviour(nodeRef, ContentModel.ASPECT_AUDITABLE);
                nodeService.setProperty(nodeRef, ContentModel.PROP_MODIFIER, (Serializable)((Object)"Fred"));
                return null;
            }
        };
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)nodeEightWork);
        Map nodePropsSevenCheck = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeySeven);
        Set nodeAspectsSevenCheck = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeySeven);
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodePropsSevenCheck.equals(nodePropsSeven));
        Assert.assertTrue((String)"Previous cache entries must be left alone", (boolean)nodeAspectsSevenCheck.equals(nodeAspectsSeven));
        Node nodeEight = (Node)this.findCacheValue(nodesCache, nodeId);
        Assert.assertNotNull((String)"Node not found in cache", (Object)nodeEight);
        NodeVersionKey nodeKeyEight = nodeEight.getNodeVersionKey();
        Map nodePropsEight = (Map)this.findCacheValue(propsCache, (Serializable)nodeKeyEight);
        Set nodeAspectsEight = (Set)this.findCacheValue(aspectsCache, (Serializable)nodeKeyEight);
        Assert.assertEquals((String)"The node version is incorrect", (Object)8L, (Object)nodeKeyEight.getVersion());
        Assert.assertNotNull((String)"No cache entry for properties", (Object)nodePropsEight);
        Assert.assertNotNull((String)"No cache entry for aspects", (Object)nodeAspectsEight);
        Assert.assertEquals((String)"Expected change to cm:modifier", (Object)"Fred", (Object)nodeEight.getAuditableProperties().getAuditModifier());
        Assert.assertTrue((String)"Properties must be carried", (boolean)nodePropsEight.equals(nodePropsSeven));
        Assert.assertTrue((String)"Aspects be carried", (boolean)nodeAspectsEight.equals(nodeAspectsSeven));
    }

    @Test
    public void testCreateNodePolicies() {
        NodeServicePolicies.OnCreateNodePolicy onCreateNodePolicy = this.createClassPolicy(NodeServicePolicies.OnCreateNodePolicy.class, NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.BeforeCreateNodePolicy beforeCreateNodePolicy = this.createClassPolicy(NodeServicePolicies.BeforeCreateNodePolicy.class, NodeServicePolicies.BeforeCreateNodePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.OnCreateChildAssociationPolicy onCreateChildAssociationPolicy = this.createAssocPolicy(NodeServicePolicies.OnCreateChildAssociationPolicy.class, NodeServicePolicies.OnCreateChildAssociationPolicy.QNAME, ContentModel.TYPE_STOREROOT);
        NodeServicePolicies.OnUpdatePropertiesPolicy onUpdatePropertiesPolicy = this.createClassPolicy(NodeServicePolicies.OnUpdatePropertiesPolicy.class, NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeRef newNodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, PropertyMap.EMPTY_MAP).getChildRef();
        Map propsAfter = nodeService.getProperties(newNodeRef);
        ChildAssociationRef childAssocRef = nodeService.getPrimaryParent(newNodeRef);
        ((NodeServicePolicies.BeforeCreateNodePolicy)Mockito.verify((Object)beforeCreateNodePolicy)).beforeCreateNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT);
        ((NodeServicePolicies.OnCreateNodePolicy)Mockito.verify((Object)onCreateNodePolicy)).onCreateNode(childAssocRef);
        ((NodeServicePolicies.OnCreateChildAssociationPolicy)Mockito.verify((Object)onCreateChildAssociationPolicy)).onCreateChildAssociation(childAssocRef, true);
        ((NodeServicePolicies.OnUpdatePropertiesPolicy)Mockito.verify((Object)onUpdatePropertiesPolicy)).onUpdateProperties(newNodeRef, PropertyMap.EMPTY_MAP, propsAfter);
    }

    @Test
    public void testSetNodeTypePolicies() {
        NodeRef nodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_CONTENT, new HashMap(0)).getChildRef();
        NodeServicePolicies.BeforeUpdateNodePolicy beforeUpdatePolicy = this.createClassPolicy(NodeServicePolicies.BeforeUpdateNodePolicy.class, NodeServicePolicies.BeforeUpdateNodePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.OnUpdateNodePolicy onUpdatePolicy = this.createClassPolicy(NodeServicePolicies.OnUpdateNodePolicy.class, NodeServicePolicies.OnUpdateNodePolicy.QNAME, ContentModel.TYPE_FOLDER);
        NodeServicePolicies.BeforeSetNodeTypePolicy beforeSetNodeTypePolicy = this.createClassPolicy(NodeServicePolicies.BeforeSetNodeTypePolicy.class, NodeServicePolicies.BeforeSetNodeTypePolicy.QNAME, ContentModel.TYPE_CONTENT);
        NodeServicePolicies.OnSetNodeTypePolicy onSetNodeTypePolicy = this.createClassPolicy(NodeServicePolicies.OnSetNodeTypePolicy.class, NodeServicePolicies.OnSetNodeTypePolicy.QNAME, ContentModel.TYPE_FOLDER);
        nodeService.setType(nodeRef, ContentModel.TYPE_FOLDER);
        ((NodeServicePolicies.BeforeUpdateNodePolicy)Mockito.verify((Object)beforeUpdatePolicy)).beforeUpdateNode(nodeRef);
        ((NodeServicePolicies.OnUpdateNodePolicy)Mockito.verify((Object)onUpdatePolicy)).onUpdateNode(nodeRef);
        ((NodeServicePolicies.BeforeSetNodeTypePolicy)Mockito.verify((Object)beforeSetNodeTypePolicy)).beforeSetNodeType(nodeRef, ContentModel.TYPE_CONTENT, ContentModel.TYPE_FOLDER);
        ((NodeServicePolicies.OnSetNodeTypePolicy)Mockito.verify((Object)onSetNodeTypePolicy)).onSetNodeType(nodeRef, ContentModel.TYPE_CONTENT, ContentModel.TYPE_FOLDER);
    }

    private <T extends Policy> T createClassPolicy(Class<T> policyInterface, QName policyQName, QName triggerOnClass) {
        Policy policy = (Policy)Mockito.mock(policyInterface);
        policyComponent.bindClassBehaviour(policyQName, triggerOnClass, (Behaviour)new JavaBehaviour((Object)policy, policyQName.getLocalName()));
        return (T)policy;
    }

    private <T extends Policy> T createAssocPolicy(Class<T> policyInterface, QName policyQName, QName triggerOnClass) {
        Policy policy = (Policy)Mockito.mock(policyInterface);
        policyComponent.bindAssociationBehaviour(policyQName, triggerOnClass, (Behaviour)new JavaBehaviour((Object)policy, policyQName.getLocalName()));
        return (T)policy;
    }

    @Test
    public void testConcurrentLinkToDeletedNode() throws Throwable {
        NodeEntity params = new NodeEntity();
        params.setId(Long.valueOf(0L));
        params.setTypeQNameId(deletedTypeQNameId);
        List<Long> attachedToDeletedIdsBefore = this.getChildNodesWithDeletedParentNode(params, 0);
        logger.debug((Object)("Found child nodes with deleted parent node (before): " + String.valueOf(attachedToDeletedIdsBefore)));
        List<Long> orphanedNodeIdsBefore = this.getChildNodesWithNoParentNode(params, 0);
        logger.debug((Object)("Found child nodes without parent (before): " + String.valueOf(orphanedNodeIdsBefore)));
        final NodeRef[] nodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createChildCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                String randomName = this.getClass().getName() + "-" + GUID.generate();
                QName randomQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)randomName);
                HashMap<QName, CallSite> props = new HashMap<QName, CallSite>();
                props.put(ContentModel.PROP_NAME, (CallSite)((Object)randomName));
                int random = new Random().nextInt(10);
                return nodeService.createNode(nodeRefs[random], ContentModel.ASSOC_CONTAINS, randomQName, ContentModel.TYPE_CONTAINER, props).getChildRef();
            }
        };
        final Runnable[] runnables = new Runnable[20];
        List<NodeRef> nodesAtRisk = Collections.synchronizedList(new ArrayList(100));
        ArrayList<Thread> threads = new ArrayList<Thread>();
        int i = 0;
        while (i < runnables.length) {
            runnables[i] = new Runnable((RetryingTransactionHelper.RetryingTransactionCallback)createChildCallback, nodesAtRisk){
                private final /* synthetic */ RetryingTransactionHelper.RetryingTransactionCallback val$createChildCallback;
                private final /* synthetic */ List val$nodesAtRisk;
                {
                    this.val$createChildCallback = retryingTransactionCallback;
                    this.val$nodesAtRisk = list;
                }

                @Override
                public synchronized void run() {
                    AuthenticationUtil.setRunAsUserSystem();
                    try {
                        this.wait(1000L);
                        int i = 0;
                        while (i < 100) {
                            NodeRef nodeRef = (NodeRef)txnService.getRetryingTransactionHelper().doInTransaction(this.val$createChildCallback);
                            this.val$nodesAtRisk.add(nodeRef);
                            this.wait(1L);
                            ++i;
                        }
                    }
                    catch (Throwable e) {
                        logger.debug((Object)"Got exception adding child node: ", e);
                    }
                }
            };
            Thread thread = new Thread(runnables[i]);
            threads.add(thread);
            thread.start();
            ++i;
        }
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> deleteWithNestedCallback = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public NodeRef execute() throws Throwable {
                int i = 0;
                while (i < runnables.length) {
                    Object object = runnables[i];
                    synchronized (object) {
                        runnables[i].notify();
                    }
                    object = this;
                    synchronized (object) {
                        try {
                            this.wait(10L);
                        }
                        catch (Throwable throwable) {}
                    }
                    ++i;
                }
                nodeService.addAspect(nodeRefs[0], ContentModel.ASPECT_TEMPORARY, null);
                nodeService.deleteNode(nodeRefs[0]);
                return null;
            }
        };
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)deleteWithNestedCallback);
        for (Thread t : threads) {
            t.join();
        }
        logger.info((Object)"All threads should have finished");
        List<Long> attachedToDeletedIdsAfter = this.getChildNodesWithDeletedParentNode(params, attachedToDeletedIdsBefore.size());
        logger.debug((Object)("Found child nodes with deleted parent node (after): " + String.valueOf(attachedToDeletedIdsAfter)));
        List<Long> orphanedNodeIdsAfter = this.getChildNodesWithNoParentNode(params, orphanedNodeIdsBefore.size());
        logger.debug((Object)("Found child nodes without parent (after): " + String.valueOf(attachedToDeletedIdsAfter)));
        if (attachedToDeletedIdsAfter.isEmpty() && orphanedNodeIdsAfter.isEmpty()) {
            return;
        }
        for (final NodeRef nodeRef : nodesAtRisk) {
            txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    if (nodeService.exists(nodeRef)) {
                        nodeService.getPath(nodeRef);
                    }
                    return null;
                }
            });
        }
        List<Long> attachedToDeletedIdsCleaned = this.getChildNodesWithDeletedParentNode(params, attachedToDeletedIdsBefore.size());
        logger.debug((Object)("Found child nodes with deleted parent node (cleaned): " + String.valueOf(attachedToDeletedIdsAfter)));
        List<Long> orphanedNodeIdsCleaned = this.getChildNodesWithNoParentNode(params, orphanedNodeIdsBefore.size());
        logger.debug((Object)("Found child nodes without parent (cleaned): " + String.valueOf(attachedToDeletedIdsAfter)));
        Assert.assertTrue((String)("Expected full cleanup of nodes referencing deleted nodes: " + String.valueOf(attachedToDeletedIdsCleaned)), (boolean)attachedToDeletedIdsCleaned.isEmpty());
        Assert.assertTrue((String)("Expected full cleanup of nodes referencing without parents: " + String.valueOf(orphanedNodeIdsCleaned)), (boolean)orphanedNodeIdsCleaned.isEmpty());
        List<NodeRef> lostAndFoundNodeRefs = this.getLostAndFoundNodes();
        Assert.assertFalse((boolean)lostAndFoundNodeRefs.isEmpty());
        HashSet<Long> lostAndFoundNodeIds = new HashSet<Long>(lostAndFoundNodeRefs.size());
        for (NodeRef nodeRef : lostAndFoundNodeRefs) {
            lostAndFoundNodeIds.add((Long)nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
        }
        Assert.assertTrue((String)"Nodes linked to deleted parent nodes not handled.", (boolean)lostAndFoundNodeIds.containsAll(attachedToDeletedIdsAfter));
        Assert.assertTrue((String)"Orphaned nodes not all handled.", (boolean)lostAndFoundNodeIds.containsAll(orphanedNodeIdsAfter));
        Assert.fail((String)"We allowed orphaned nodes or nodes with deleted parents.");
    }

    @Test
    public void testLinkToDeletedNodeRecovery() throws Throwable {
        NodeEntity params = new NodeEntity();
        params.setId(Long.valueOf(0L));
        params.setTypeQNameId(deletedTypeQNameId);
        List<Long> nodesWithDeletedParents = this.getChildNodesWithDeletedParentNode(params, 0);
        List<Long> deletedChildren = this.getDeletedChildren(params, 0);
        List<Long> nodesWithNoParents = this.getChildNodesWithNoParentNode(params, 0);
        logger.debug((Object)("Found child nodes with deleted parent node (before): " + String.valueOf(nodesWithDeletedParents)));
        final NodeRef[] nodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        int cnt = 5;
        final ArrayList<NodeRef> childNodeRefs = new ArrayList<NodeRef>(cnt);
        final NodeDAO nodeDAO = (NodeDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeDAO");
        int i = 0;
        while (i < cnt) {
            String randomName = this.getClass().getName() + "-" + System.nanoTime();
            QName randomQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)randomName);
            Iterator props = new HashMap<QName, CallSite>();
            props.put(ContentModel.PROP_NAME, randomName);
            int random = new Random().nextInt(10);
            NodeRef parentNodeRef = nodeRefs[random];
            NodeRef childNodeRef = nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, randomQName, ContentModel.TYPE_THUMBNAIL, props).getChildRef();
            childNodeRefs.add(childNodeRef);
            ++i;
        }
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Long nodeId = (Long)nodeService.getProperty(nodeRefs[0], ContentModel.PROP_NODE_DBID);
                nodeDAO.updateNode(nodeId, ContentModel.TYPE_DELETED, null);
                nodeDAO.removeNodeAspects(nodeId);
                nodeDAO.removeNodeProperties(nodeId, nodeDAO.getNodeProperties(nodeId).keySet());
                nodeId = (Long)nodeService.getProperty(nodeRefs[2], ContentModel.PROP_NODE_DBID);
                nodeDAO.updateNode(nodeId, ContentModel.TYPE_DELETED, null);
                nodeDAO.removeNodeAspects(nodeId);
                nodeDAO.removeNodeProperties(nodeId, nodeDAO.getNodeProperties(nodeId).keySet());
                nodeId = (Long)nodeService.getProperty((NodeRef)childNodeRefs.get(childNodeRefs.size() - 1), ContentModel.PROP_NODE_DBID);
                nodeDAO.updateNode(nodeId, ContentModel.TYPE_DELETED, null);
                nodeDAO.removeNodeAspects(nodeId);
                nodeDAO.removeNodeProperties(nodeId, nodeDAO.getNodeProperties(nodeId).keySet());
                return null;
            }
        });
        List<Long> childNodeIds = this.getChildNodesWithDeletedParentNode(params, nodesWithDeletedParents.size());
        Assert.assertFalse((boolean)childNodeIds.isEmpty());
        logger.debug((Object)("Found child nodes with deleted parent node (after): " + String.valueOf(childNodeIds)));
        ArrayList<NodeRef> allNodeRefs = new ArrayList<NodeRef>(nodeRefs.length + childNodeRefs.size());
        allNodeRefs.addAll(Arrays.asList(nodeRefs));
        allNodeRefs.addAll(childNodeRefs);
        Collections.reverse(allNodeRefs);
        for (final NodeRef nodeRef : allNodeRefs) {
            txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    if (nodeService.exists(nodeRef)) {
                        try {
                            for (ChildAssociationRef parentRef : nodeService.getParentAssocs(nodeRef)) {
                                nodeService.getPath(parentRef.getParentRef());
                            }
                            nodeService.getPath(nodeRef);
                        }
                        catch (InvalidNodeRefException e) {
                            throw new ConcurrencyFailureException("Deleted node - should be healed on retry", (Throwable)e);
                        }
                    }
                    return null;
                }
            });
        }
        for (final NodeRef nodeRef : allNodeRefs) {
            txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    nodeDAO.getNodePair(nodeRef);
                    return null;
                }
            });
        }
        List<Long> nodeIds = this.getDeletedChildren(params, deletedChildren.size());
        Assert.assertTrue((String)("The following deleted nodes still have parents: " + String.valueOf(nodeIds)), (boolean)nodeIds.isEmpty());
        nodeIds = this.getChildNodesWithDeletedParentNode(params, nodesWithDeletedParents.size());
        Assert.assertTrue((String)("The following child nodes have deleted parent nodes: " + String.valueOf(nodeIds)), (boolean)nodeIds.isEmpty());
        nodeIds = this.getChildNodesWithNoParentNode(params, nodesWithNoParents.size());
        Assert.assertTrue((String)("The following child nodes have no parent node: " + String.valueOf(nodeIds)), (boolean)nodeIds.isEmpty());
        final List<NodeRef> lostAndFoundNodeRefs = this.getLostAndFoundNodes();
        Assert.assertFalse((boolean)lostAndFoundNodeRefs.isEmpty());
        final ArrayList lostAndFoundNodeIds = new ArrayList(lostAndFoundNodeRefs.size());
        txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                for (NodeRef nodeRef : lostAndFoundNodeRefs) {
                    Long nodeId = (Long)nodeDAO.getNodePair(nodeRef).getFirst();
                    lostAndFoundNodeIds.add(nodeId);
                }
                return null;
            }
        });
        for (final Long childNodeId : childNodeIds) {
            Boolean exists = (Boolean)txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Boolean>(){

                public Boolean execute() throws Throwable {
                    return nodeDAO.exists(childNodeId);
                }
            });
            Assert.assertTrue((String)("Not found: " + String.valueOf(childNodeId)), (lostAndFoundNodeIds.contains(childNodeId) || exists == false ? 1 : 0) != 0);
        }
    }

    @Test
    public void testForceNonRootNodeWithNoParentNode() throws Throwable {
        NodeEntity params = new NodeEntity();
        params.setId(Long.valueOf(0L));
        params.setTypeQNameId(deletedTypeQNameId);
        List<Long> ids = this.getChildNodesWithNoParentNode(params, 0);
        logger.debug((Object)("Found child nodes with deleted parent node (before): " + String.valueOf(ids)));
        int idsToSkip = ids.size();
        NodeRef[] nodeRefs = new NodeRef[10];
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        this.buildNodeHierarchy(workspaceRootNodeRef, nodeRefs);
        int cnt = 5;
        ArrayList<NodeRef> childNodeRefs = new ArrayList<NodeRef>(cnt);
        final NodeDAO nodeDAO = (NodeDAO)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeDAO");
        int i = 0;
        while (i < cnt) {
            String randomName = this.getClass().getName() + "-" + System.nanoTime();
            QName randomQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)randomName);
            HashMap<QName, CallSite> props = new HashMap<QName, CallSite>();
            props.put(ContentModel.PROP_NAME, (CallSite)((Object)randomName));
            int random = new Random().nextInt(10);
            NodeRef parentNodeRef = nodeRefs[random];
            NodeRef childNodeRef = nodeService.createNode(parentNodeRef, ContentModel.ASSOC_CONTAINS, randomQName, ContentModel.TYPE_THUMBNAIL, props).getChildRef();
            childNodeRefs.add(childNodeRef);
            final Long childNodeId = (Long)nodeService.getProperty(childNodeRef, ContentModel.PROP_NODE_DBID);
            txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    Pair assocPair = nodeDAO.getPrimaryParentAssoc(childNodeId);
                    nodeDAO.deleteChildAssoc((Long)assocPair.getFirst());
                    return null;
                }
            });
            ++i;
        }
        List<Long> childNodeIds = this.getChildNodesWithNoParentNode(params, idsToSkip);
        Assert.assertFalse((boolean)childNodeIds.isEmpty());
        logger.debug((Object)("Found child nodes with deleted parent node (after): " + String.valueOf(childNodeIds)));
        for (final NodeRef nodeRef : childNodeRefs) {
            txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    if (nodeService.exists(nodeRef)) {
                        nodeService.getPath(nodeRef);
                    }
                    return null;
                }
            });
        }
        ids = this.getChildNodesWithNoParentNode(params, idsToSkip);
        Assert.assertTrue((String)("The following child nodes have no parent node: " + String.valueOf(ids)), (boolean)ids.isEmpty());
        List<NodeRef> lostAndFoundNodeRefs = this.getLostAndFoundNodes();
        Assert.assertFalse((boolean)lostAndFoundNodeRefs.isEmpty());
        ArrayList<Long> lostAndFoundNodeIds = new ArrayList<Long>(lostAndFoundNodeRefs.size());
        for (NodeRef nodeRef : lostAndFoundNodeRefs) {
            lostAndFoundNodeIds.add((Long)nodeService.getProperty(nodeRef, ContentModel.PROP_NODE_DBID));
        }
        for (Long childNodeId : childNodeIds) {
            Assert.assertTrue((String)("Not found: " + String.valueOf(childNodeId)), (lostAndFoundNodeIds.contains(childNodeId) || !nodeDAO.exists(childNodeId) ? 1 : 0) != 0);
        }
    }

    private List<Long> getChildNodesWithDeletedParentNode(NodeEntity params, int idsToSkip) {
        return cannedQueryDAOForTesting.executeQuery("alfresco.query.test", "select_NodeServiceTest_testConcurrentLinkToDeletedNode_GetChildNodesWithDeletedParentNodeCannedQuery", (Object)params, idsToSkip, Integer.MAX_VALUE);
    }

    private List<Long> getChildNodesWithNoParentNode(NodeEntity params, int idsToSkip) {
        return cannedQueryDAOForTesting.executeQuery("alfresco.query.test", "select_NodeServiceTest_testForceNonRootNodeWithNoParentNode_GetChildNodesWithNoParentNodeCannedQuery", (Object)params, idsToSkip, Integer.MAX_VALUE);
    }

    private List<Long> getDeletedChildren(NodeEntity params, int idsToSkip) {
        return cannedQueryDAOForTesting.executeQuery("alfresco.query.test", "select_NodeServiceTest_testLinkToDeletedNodeRecovery_GetDeletedChildrenCannedQuery", (Object)params, idsToSkip, Integer.MAX_VALUE);
    }

    private List<NodeRef> getLostAndFoundNodes() {
        HashSet<QName> childNodeTypeQNames = new HashSet<QName>(1);
        childNodeTypeQNames.add(ContentModel.TYPE_LOST_AND_FOUND);
        List childAssocRefs = nodeService.getChildAssocs(nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), childNodeTypeQNames);
        List<NodeRef> lostNodeRefs = null;
        if (childAssocRefs.size() > 0) {
            List lostNodeChildAssocRefs = nodeService.getChildAssocs(((ChildAssociationRef)childAssocRefs.get(0)).getChildRef());
            lostNodeRefs = new ArrayList<NodeRef>(lostNodeChildAssocRefs.size());
            for (ChildAssociationRef lostNodeChildAssocRef : lostNodeChildAssocRefs) {
                lostNodeRefs.add(lostNodeChildAssocRef.getChildRef());
            }
        } else {
            lostNodeRefs = Collections.emptyList();
        }
        return lostNodeRefs;
    }

    @Test
    public void testNodeHierarchyWalker() throws Exception {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        final NodeRef[] nodes = new NodeRef[6];
        this.buildNodeHierarchy(workspaceRootNodeRef, nodes);
        nodeService.addAspect(nodes[1], ContentModel.ASPECT_COPIEDFROM, null);
        nodeService.createAssociation(nodes[1], nodes[0], ContentModel.ASSOC_ORIGINAL);
        nodeService.addChild(nodes[0], nodes[2], ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org", (String)"testNodeHierarchyWalker"));
        NodeHierarchyWalker walker = (NodeHierarchyWalker)txnService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeHierarchyWalker>(){

            public NodeHierarchyWalker execute() throws Throwable {
                Pair parentNodePair = nodeDAO.getNodePair(nodes[0]);
                Pair parentAssocPair = nodeDAO.getPrimaryParentAssoc((Long)parentNodePair.getFirst());
                NodeHierarchyWalker walker = new NodeHierarchyWalker(nodeDAO);
                walker.walkHierarchy(parentNodePair, parentAssocPair);
                return walker;
            }
        }, true);
        List nodesLeafFirst = walker.getNodes(true);
        Assert.assertEquals((String)"Unexpected number of nodes visited", (long)6L, (long)nodesLeafFirst.size());
        Assert.assertEquals((String)"Incorrect order ", (Object)((NodeHierarchyWalker.VisitedNode)nodesLeafFirst.get((int)0)).nodeRef, (Object)nodes[5]);
        Assert.assertEquals((String)"Incorrect order ", (Object)((NodeHierarchyWalker.VisitedNode)nodesLeafFirst.get((int)5)).nodeRef, (Object)nodes[0]);
        List nodesParentFirst = walker.getNodes(false);
        Assert.assertEquals((String)"Unexpected number of nodes visited", (long)6L, (long)nodesParentFirst.size());
        Assert.assertEquals((String)"Incorrect order ", (Object)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).nodeRef, (Object)nodes[0]);
        Assert.assertEquals((String)"Incorrect order ", (Object)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)5)).nodeRef, (Object)nodes[5]);
        Assert.assertEquals((Object)workspaceRootNodeRef, (Object)((ChildAssociationRef)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).primaryParentAssocPair.getSecond()).getParentRef());
        Assert.assertEquals((Object)nodes[0], (Object)((ChildAssociationRef)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)1)).primaryParentAssocPair.getSecond()).getParentRef());
        Assert.assertEquals((Object)nodes[4], (Object)((ChildAssociationRef)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)5)).primaryParentAssocPair.getSecond()).getParentRef());
        Assert.assertEquals((long)0L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).secondaryParentAssocs.size());
        Assert.assertEquals((Object)nodes[0], (Object)((ChildAssociationRef)((Pair)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)2)).secondaryParentAssocs.get(0)).getSecond()).getParentRef());
        Assert.assertEquals((long)0L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)1)).secondaryParentAssocs.size());
        Assert.assertEquals((long)1L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)2)).secondaryParentAssocs.size());
        Assert.assertEquals((long)0L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)3)).secondaryParentAssocs.size());
        Assert.assertEquals((long)1L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).secondaryChildAssocs.size());
        Assert.assertEquals((Object)nodes[2], (Object)((ChildAssociationRef)((Pair)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).secondaryChildAssocs.get(0)).getSecond()).getChildRef());
        Assert.assertEquals((long)0L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)1)).secondaryChildAssocs.size());
        Assert.assertEquals((long)0L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).targetAssocs.size());
        Assert.assertEquals((long)1L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)1)).targetAssocs.size());
        Assert.assertEquals((Object)nodes[0], (Object)((AssociationRef)((Pair)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)1)).targetAssocs.get(0)).getSecond()).getTargetRef());
        Assert.assertEquals((long)1L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).sourceAssocs.size());
        Assert.assertEquals((Object)nodes[1], (Object)((AssociationRef)((Pair)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)0)).sourceAssocs.get(0)).getSecond()).getSourceRef());
        Assert.assertEquals((long)0L, (long)((NodeHierarchyWalker.VisitedNode)nodesParentFirst.get((int)1)).sourceAssocs.size());
    }

    @Test
    public void testCascadeUpdate() {
        NodeRef nodeRef1 = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()), ContentModel.TYPE_CONTAINER).getChildRef();
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef1).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        HashMap aspectProps = new HashMap();
        ArrayList<NodeRef> cats = new ArrayList<NodeRef>();
        cats.add(nodeRef1);
        aspectProps.put(ContentModel.PROP_CATEGORIES, cats);
        nodeService.addAspect(nodeRef1, ContentModel.ASPECT_GEN_CLASSIFIABLE, aspectProps);
        Assert.assertTrue((boolean)nodeService.getAspects(nodeRef1).contains(ContentModel.ASPECT_GEN_CLASSIFIABLE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef1).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        NodeRef nodeRef2 = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef3 = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef4 = nodeService.createNode(nodeRef2, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()), ContentModel.TYPE_CONTAINER).getChildRef();
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef2).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef3).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef4).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        nodeService.moveNode(nodeRef4, nodeRef3, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef2).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef3).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertTrue((boolean)nodeService.getAspects(nodeRef4).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        NodeRef.Status status = nodeService.getNodeStatus(nodeRef4);
        Long lastCascadeTx = (Long)nodeService.getProperty(nodeRef4, ContentModel.PROP_CASCADE_TX);
        Assert.assertTrue((boolean)status.getDbTxnId().equals(lastCascadeTx));
        Assert.assertTrue((nodeService.getProperty(nodeRef4, ContentModel.PROP_CASCADE_CRC) != null ? 1 : 0) != 0);
        Long crcIn3 = (Long)nodeService.getProperty(nodeRef4, ContentModel.PROP_CASCADE_CRC);
        nodeService.moveNode(nodeRef4, nodeRef2, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()));
        Long crcIn2 = (Long)nodeService.getProperty(nodeRef4, ContentModel.PROP_CASCADE_CRC);
        Assert.assertFalse((boolean)crcIn2.equals(crcIn3));
        NodeRef nodeRef5 = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"5"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef6 = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"6"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef7 = nodeService.createNode(nodeRef5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"7"), ContentModel.TYPE_CONTAINER).getChildRef();
        NodeRef nodeRef8 = nodeService.createNode(nodeRef5, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"8"), ContentModel.TYPE_CONTAINER).getChildRef();
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef5).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef6).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef7).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef8).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        nodeService.addChild(nodeRef6, nodeRef7, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef5).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef6).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertTrue((boolean)nodeService.getAspects(nodeRef7).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Assert.assertFalse((boolean)nodeService.getAspects(nodeRef8).contains(ContentModel.ASPECT_CASCADE_UPDATE));
        Long doubleLinkCRC = (Long)nodeService.getProperty(nodeRef7, ContentModel.PROP_CASCADE_CRC);
        Assert.assertNotNull((Object)doubleLinkCRC);
        nodeService.removeChild(nodeRef6, nodeRef7);
        Long singleLinkCRC = (Long)nodeService.getProperty(nodeRef7, ContentModel.PROP_CASCADE_CRC);
        Assert.assertFalse((boolean)doubleLinkCRC.equals(singleLinkCRC));
        nodeService.addChild(nodeRef6, nodeRef7, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getName()));
        Long doubleLinkCRC2 = (Long)nodeService.getProperty(nodeRef7, ContentModel.PROP_CASCADE_CRC);
        Assert.assertFalse((boolean)singleLinkCRC.equals(doubleLinkCRC2));
        nodeService.removeChild(nodeRef6, nodeRef7);
        Long singleLinkCRC2 = (Long)nodeService.getProperty(nodeRef7, ContentModel.PROP_CASCADE_CRC);
        Assert.assertFalse((boolean)doubleLinkCRC2.equals(singleLinkCRC2));
    }

    @Test
    public void testUpdateContentPermissionWithoutRestrictions() {
        ContentPropertyRestrictionInterceptor contentPropertyRestrictionInterceptor = (ContentPropertyRestrictionInterceptor)APP_CONTEXT_INIT.getApplicationContext().getBean("contentPropertyRestrictionInterceptor");
        contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictions(false);
        try {
            this.updateContentPermissionCommonWork();
        }
        finally {
            contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictions(true);
        }
    }

    @Test
    public void testUpdateContentPermissionWithRestrictions() {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        String userName1 = GUID.generate();
        String userName2 = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName1);
        personService.createPerson(properties);
        properties.put(ContentModel.PROP_USERNAME, userName2);
        personService.createPerson(properties);
        HashMap<QName, String> props = new HashMap<QName, String>(3);
        props.put(ContentModel.PROP_NAME, GUID.generate());
        NodeRef folder1 = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
        props.put(ContentModel.PROP_NAME, GUID.generate());
        NodeRef folder2 = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
        permissionService.setPermission(folder1, userName1, "All", true);
        permissionService.setInheritParentPermissions(folder1, false);
        permissionService.setPermission(folder2, userName2, "All", true);
        permissionService.setInheritParentPermissions(folder2, false);
        ContentData contentProp1 = (ContentData)AuthenticationUtil.runAs(() -> {
            NodeRef nodeRef2 = this.createContentNode(folder1);
            this.addContentToNode(nodeRef2);
            try {
                AuthenticationUtil.runAs(() -> {
                    contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
                    Assert.fail((String)"The content of node1 should not be readable by user 2");
                    return null;
                }, (String)userName2);
            }
            catch (Exception e) {
                Assert.assertTrue((String)"The AccessDeniedException should be thrown.", (boolean)(e instanceof AccessDeniedException));
            }
            return (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
        }, (String)userName1);
        AuthenticationUtil.runAs(() -> {
            HashMap<QName, Serializable> testProps;
            NodeRef nodeRef2 = nodeService.createNode(folder2, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
            try {
                nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)contentProp1);
                Assert.fail((String)"Should not be possible to call setProperty directly to set content");
            }
            catch (InvalidTypeException invalidTypeException) {}
            try {
                testProps = new HashMap<QName, Serializable>();
                testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
                nodeService.setProperties(nodeRef2, testProps);
                Assert.fail((String)"Should not be possible to call setProperties directly to set content");
            }
            catch (InvalidTypeException invalidTypeException) {}
            try {
                testProps = new HashMap();
                testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
                nodeService.addProperties(nodeRef2, testProps);
                Assert.fail((String)"Should not be possible to call addProperties directly to set content");
            }
            catch (InvalidTypeException invalidTypeException) {}
            try {
                testProps = new HashMap();
                testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
                nodeService.addAspect(nodeRef2, ContentModel.ASPECT_OWNABLE, testProps);
                Assert.fail((String)"Should not be possible to call addAspect directly to set content");
            }
            catch (InvalidTypeException invalidTypeException) {}
            try {
                testProps = new HashMap();
                testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
                this.createContentNode(folder2, testProps);
                Assert.fail((String)"Should not be possible to call createNode directly to set content");
            }
            catch (InvalidTypeException invalidTypeException) {}
            ContentReader contentReader = contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertNull((String)"The second node should not have any content (all attempts should fail)", (Object)contentReader);
            return null;
        }, (String)userName2);
    }

    @Test
    public void testUpdateContentPermissionWithRestrictionsAndWhiteList() {
        ContentPropertyRestrictionInterceptor contentPropertyRestrictionInterceptor = (ContentPropertyRestrictionInterceptor)APP_CONTEXT_INIT.getApplicationContext().getBean("contentPropertyRestrictionInterceptor");
        contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList(this.getClass().getName());
        try {
            this.updateContentPermissionCommonWork();
        }
        finally {
            contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList("");
        }
    }

    private void updateContentPermissionCommonWork() {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        String content = "Some content";
        String userName1 = GUID.generate();
        String userName2 = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName1);
        personService.createPerson(properties);
        properties.put(ContentModel.PROP_USERNAME, userName2);
        personService.createPerson(properties);
        HashMap<QName, String> props = new HashMap<QName, String>(3);
        props.put(ContentModel.PROP_NAME, GUID.generate());
        NodeRef folder1 = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
        props.put(ContentModel.PROP_NAME, GUID.generate());
        NodeRef folder2 = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
        permissionService.setPermission(folder1, userName1, "All", true);
        permissionService.setInheritParentPermissions(folder1, false);
        permissionService.setPermission(folder2, userName2, "All", true);
        permissionService.setInheritParentPermissions(folder2, false);
        ContentData contentProp1 = (ContentData)AuthenticationUtil.runAs(() -> {
            NodeRef nodeRef2 = this.createContentNode(folder1);
            this.addContentToNode(nodeRef2);
            try {
                AuthenticationUtil.runAs(() -> {
                    contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
                    Assert.fail((String)"The content of node1 should not be readable by user 2");
                    return null;
                }, (String)userName2);
            }
            catch (Exception e) {
                Assert.assertTrue((String)"The AccessDeniedException should be thrown.", (boolean)(e instanceof AccessDeniedException));
            }
            return (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
        }, (String)userName1);
        AuthenticationUtil.runAs(() -> {
            NodeRef nodeRef2 = this.createContentNode(folder2);
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)contentProp1);
            ContentReader contentReader = contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertNotNull((String)"The node should have the content set", (Object)contentReader);
            Assert.assertEquals((String)"The property should be set successfully", (Object)content, (Object)contentReader.getContentString());
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, null);
            HashMap<QName, Serializable> testProps = new HashMap<QName, Serializable>();
            testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
            nodeService.setProperties(nodeRef2, testProps);
            contentReader = contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertNotNull((String)"The node should have the content set", (Object)contentReader);
            Assert.assertEquals((String)"The property should be set successfully", (Object)content, (Object)contentReader.getContentString());
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, null);
            testProps = new HashMap();
            testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
            nodeService.addAspect(nodeRef2, ContentModel.ASPECT_OWNABLE, testProps);
            contentReader = contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertNotNull((String)"The node should have the content set", (Object)contentReader);
            Assert.assertEquals((String)"The property should be set successfully", (Object)content, (Object)contentReader.getContentString());
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, null);
            testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
            nodeService.addProperties(nodeRef2, testProps);
            contentReader = contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertNotNull((String)"The node should have the content set", (Object)contentReader);
            Assert.assertEquals((String)"The property should be set successfully", (Object)content, (Object)contentReader.getContentString());
            testProps.put(ContentModel.PROP_CONTENT, (Serializable)contentProp1);
            NodeRef newNode = this.createContentNode(folder2, testProps);
            contentReader = contentService.getReader(newNode, ContentModel.PROP_CONTENT);
            Assert.assertNotNull((String)"The node should have the content set", (Object)contentReader);
            Assert.assertEquals((String)"The property should be set successfully", (Object)content, (Object)contentReader.getContentString());
            contentReader = contentService.getReader(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertNotNull((String)"The second node should not have any content (all attempts should fail)", (Object)contentReader);
            return null;
        }, (String)userName2);
    }

    @Test
    public void testSetContentPropertiesWithoutModification() {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        String userName1 = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName1);
        personService.createPerson(properties);
        HashMap<QName, String> props = new HashMap<QName, String>(3);
        props.put(ContentModel.PROP_NAME, GUID.generate());
        NodeRef folder1 = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
        permissionService.setPermission(folder1, userName1, "All", true);
        permissionService.setInheritParentPermissions(folder1, false);
        AuthenticationUtil.runAs(() -> {
            NodeRef nodeRef2 = this.createContentNode(folder1);
            this.addContentToNode(nodeRef2);
            Serializable contentProp = nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            HashMap<QName, String> existingProps = nodeService.getProperties(nodeRef2);
            String description = "Some description";
            existingProps.put(ContentModel.PROP_DESCRIPTION, description);
            nodeService.setProperties(nodeRef2, (Map)existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)description, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION));
            existingProps = new HashMap<QName, String>(2);
            existingProps.put(ContentModel.PROP_CONTENT, (String)((Object)contentProp));
            String title = "Some title";
            existingProps.put(ContentModel.PROP_TITLE, title);
            nodeService.addProperties(nodeRef2, existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)title, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_TITLE));
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, contentProp);
            HashMap<QName, Serializable> aspectProps = new HashMap<QName, Serializable>();
            aspectProps.put(ContentModel.PROP_CONTENT, contentProp);
            nodeService.addAspect(nodeRef2, ContentModel.ASPECT_OWNABLE, aspectProps);
            Assert.assertTrue((String)"Aspect should be added", (boolean)nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_OWNABLE));
            return null;
        }, (String)userName1);
    }

    @Test
    public void testSetContentPropertyToNull() {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        ContentData nullContentData = new ContentData(null, "text/plain", 0L, "UTF-8", Locale.ENGLISH);
        ContentData emptyContentData = new ContentData("", "text/plain", 0L, "UTF-8", Locale.ENGLISH);
        String userName1 = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName1);
        personService.createPerson(properties);
        HashMap<QName, String> props = new HashMap<QName, String>(3);
        props.put(ContentModel.PROP_NAME, GUID.generate());
        NodeRef folder1 = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
        permissionService.setPermission(folder1, userName1, "All", true);
        permissionService.setInheritParentPermissions(folder1, false);
        AuthenticationUtil.runAs(() -> {
            NodeRef nodeRef2 = this.createContentNode(folder1);
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)emptyContentData);
            Assert.assertEquals((String)"The content property was not correct.", (Object)emptyContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)nullContentData);
            Assert.assertEquals((String)"The content property was not correct.", (Object)nullContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, null);
            Assert.assertNull((String)"The content property was not correct.", (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            HashMap<QName, String> existingProps = nodeService.getProperties(nodeRef2);
            String description = "Some description 1";
            existingProps.put(ContentModel.PROP_DESCRIPTION, description);
            existingProps.put(ContentModel.PROP_CONTENT, (String)emptyContentData);
            nodeService.setProperties(nodeRef2, (Map)existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)description, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION));
            Assert.assertEquals((String)"The content property was not correct.", (Object)emptyContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            existingProps = nodeService.getProperties(nodeRef2);
            description = "Some description 2";
            existingProps.put(ContentModel.PROP_DESCRIPTION, description);
            existingProps.put(ContentModel.PROP_CONTENT, (String)nullContentData);
            nodeService.setProperties(nodeRef2, (Map)existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)description, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION));
            Assert.assertEquals((String)"The content property was not correct.", (Object)nullContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            existingProps = nodeService.getProperties(nodeRef2);
            description = "Some description 3";
            existingProps.put(ContentModel.PROP_DESCRIPTION, description);
            existingProps.put(ContentModel.PROP_CONTENT, null);
            nodeService.setProperties(nodeRef2, (Map)existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)description, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_DESCRIPTION));
            Assert.assertNull((String)"The content property was not correct.", (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            existingProps = new HashMap<QName, String>(2);
            existingProps.put(ContentModel.PROP_CONTENT, (String)emptyContentData);
            String title = "Some title 1";
            existingProps.put(ContentModel.PROP_TITLE, title);
            nodeService.addProperties(nodeRef2, existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)title, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_TITLE));
            Assert.assertEquals((String)"The content property was not correct.", (Object)emptyContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            existingProps = new HashMap(2);
            existingProps.put(ContentModel.PROP_CONTENT, (String)nullContentData);
            title = "Some title 2";
            existingProps.put(ContentModel.PROP_TITLE, title);
            nodeService.addProperties(nodeRef2, existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)title, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_TITLE));
            Assert.assertEquals((String)"The content property was not correct.", (Object)nullContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            existingProps = new HashMap(2);
            existingProps.put(ContentModel.PROP_CONTENT, null);
            title = "Some title 3";
            existingProps.put(ContentModel.PROP_TITLE, title);
            nodeService.addProperties(nodeRef2, existingProps);
            Assert.assertEquals((String)"Additional property should be set", (Object)title, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_TITLE));
            Assert.assertNull((String)"The content property was not correct.", (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            HashMap<QName, ContentData> aspectProps = new HashMap<QName, ContentData>();
            aspectProps.put(ContentModel.PROP_CONTENT, emptyContentData);
            nodeService.addAspect(nodeRef2, ContentModel.ASPECT_OWNABLE, aspectProps);
            Assert.assertTrue((String)"Aspect should be added", (boolean)nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_OWNABLE));
            Assert.assertEquals((String)"The content property was not correct.", (Object)emptyContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            aspectProps = new HashMap();
            aspectProps.put(ContentModel.PROP_CONTENT, nullContentData);
            nodeService.addAspect(nodeRef2, ContentModel.ASPECT_OWNABLE, aspectProps);
            Assert.assertTrue((String)"Aspect should be added", (boolean)nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_OWNABLE));
            Assert.assertEquals((String)"The content property was not correct.", (Object)nullContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            aspectProps = new HashMap();
            aspectProps.put(ContentModel.PROP_CONTENT, null);
            nodeService.addAspect(nodeRef2, ContentModel.ASPECT_OWNABLE, aspectProps);
            Assert.assertTrue((String)"Aspect should be added", (boolean)nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_OWNABLE));
            Assert.assertNull((String)"The content property was not correct.", (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            return null;
        }, (String)userName1);
    }

    @Test
    public void testChangeContentPropertyParameters() {
        NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
        String userName1 = GUID.generate();
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName1);
        personService.createPerson(properties);
        HashMap<QName, String> props = new HashMap<QName, String>(3);
        props.put(ContentModel.PROP_NAME, GUID.generate());
        NodeRef folder1 = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
        permissionService.setPermission(folder1, userName1, "All", true);
        permissionService.setInheritParentPermissions(folder1, false);
        AuthenticationUtil.runAs(() -> {
            NodeRef nodeRef2 = this.createContentNode(folder1);
            ContentData oldContentData = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            ContentData newContentData = new ContentData(oldContentData.getContentUrl(), "application/pdf", oldContentData.getSize(), oldContentData.getEncoding(), oldContentData.getLocale());
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)newContentData);
            Assert.assertEquals((String)"The content property was not correct.", (Object)newContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            oldContentData = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            newContentData = new ContentData(oldContentData.getContentUrl(), oldContentData.getMimetype(), oldContentData.getSize() + 1L, oldContentData.getEncoding(), oldContentData.getLocale());
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)newContentData);
            Assert.assertEquals((String)"The content property was not correct.", (Object)newContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            oldContentData = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            newContentData = new ContentData(oldContentData.getContentUrl(), oldContentData.getMimetype(), oldContentData.getSize(), "UTF-16", oldContentData.getLocale());
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)newContentData);
            Assert.assertEquals((String)"The content property was not correct.", (Object)newContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            nodeRef2 = this.createContentNode(folder1);
            oldContentData = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            newContentData = new ContentData(oldContentData.getContentUrl(), oldContentData.getMimetype(), oldContentData.getSize(), oldContentData.getEncoding(), Locale.GERMAN);
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)newContentData);
            Assert.assertEquals((String)"The content property was not correct.", (Object)newContentData, (Object)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT));
            try {
                nodeRef2 = this.createContentNode(folder1);
                oldContentData = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
                newContentData = new ContentData("fake://url/123", oldContentData.getMimetype(), oldContentData.getSize(), oldContentData.getEncoding(), oldContentData.getLocale());
                nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)newContentData);
                Assert.fail((String)"Should not be possible to change content URL");
            }
            catch (InvalidTypeException invalidTypeException) {}
            return null;
        }, (String)userName1);
    }

    @Test
    public void testChangeContentURLSameCRC() {
        ContentPropertyRestrictionInterceptor contentPropertyRestrictionInterceptor = (ContentPropertyRestrictionInterceptor)APP_CONTEXT_INIT.getApplicationContext().getBean("contentPropertyRestrictionInterceptor");
        contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList(this.getClass().getName());
        try {
            NodeRef workspaceRootNodeRef = nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
            HashMap<QName, String> props = new HashMap<QName, String>(3);
            props.put(ContentModel.PROP_NAME, GUID.generate());
            NodeRef testFolder = nodeService.createNode(workspaceRootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)NAMESPACE, (String)GUID.generate()), ContentModel.TYPE_FOLDER, props).getChildRef();
            NodeRef nodeRef1 = nodeService.createNode(testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"180225704974-DSA Correspondence 1"), ContentModel.TYPE_CONTENT).getChildRef();
            NodeRef nodeRef2 = nodeService.createNode(testFolder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"090502800600-General Correspondence 1"), ContentModel.TYPE_CONTENT).getChildRef();
            String contentURL1 = "s3v2://contentstore/1597325412593_1610985343942_3708/SLC/IC/DSA/2018/02/16/20/180225704974-DSA Correspondence 1";
            String contentURL2 = "s3v2://contentstore/1639588316822_1642775862393_49/SLC/IC/GENERAL/2009/05/27/16/090502800600-General Correspondence 1";
            String contentURL3 = "s3v2://contentstore/1639588316821_1642775862393_49/SLC/IC/GENERAL/2009/05/27/16/090502800600-General Correspondence 1";
            ContentData contentData1 = new ContentData(contentURL1, "application/pdf", 100L, "UTF-8");
            ContentData contentData2 = new ContentData(contentURL2, "application/pdf", 100L, "UTF-8");
            ContentData contentData3 = new ContentData(contentURL3, "application/pdf", 100L, "UTF-8");
            nodeService.setProperty(nodeRef1, ContentModel.PROP_CONTENT, (Serializable)contentData1);
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)contentData1);
            ContentData cdNode1Val0 = (ContentData)nodeService.getProperty(nodeRef1, ContentModel.PROP_CONTENT);
            ContentData cdNode2Val0 = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertEquals((String)"ContentURL for node1 should be contentURL1", (Object)contentURL1, (Object)cdNode1Val0.getContentUrl());
            Assert.assertEquals((String)"ContentURL for node2 should also be the same as node1", (Object)contentURL1, (Object)cdNode2Val0.getContentUrl());
            nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)contentData2);
            ContentData cdNode1Val1 = (ContentData)nodeService.getProperty(nodeRef1, ContentModel.PROP_CONTENT);
            ContentData cdNode2Val1 = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertEquals((String)"ContentURL for node1 should be contentURL1", (Object)contentURL1, (Object)cdNode1Val1.getContentUrl());
            Assert.assertEquals((String)"ContentURL for node2 should be contentURL2", (Object)contentURL2, (Object)cdNode2Val1.getContentUrl());
            try {
                nodeService.setProperty(nodeRef2, ContentModel.PROP_CONTENT, (Serializable)contentData3);
                Assert.fail((String)"Should not be possible to set a contentUrl with the same CRC and different value");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            ContentData cdNode1Val2 = (ContentData)nodeService.getProperty(nodeRef1, ContentModel.PROP_CONTENT);
            ContentData cdNode2Val2 = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertFalse((String)"Collision detected on node 1", (boolean)contentURL3.equals(cdNode1Val2.getContentUrl()));
            Assert.assertFalse((String)"Collision detected on node 2", (boolean)contentURL1.equals(cdNode2Val2.getContentUrl()));
            propsCache.clear();
            contentDataCache.clear();
            contentUrlCache.clear();
            ContentData cdNode1Val3 = (ContentData)nodeService.getProperty(nodeRef1, ContentModel.PROP_CONTENT);
            ContentData cdNode2Val3 = (ContentData)nodeService.getProperty(nodeRef2, ContentModel.PROP_CONTENT);
            Assert.assertFalse((String)"Collision detected on node 1 after clear caches", (boolean)contentURL3.equals(cdNode1Val3.getContentUrl()));
            Assert.assertFalse((String)"Collision detected on node 2 after clear caches", (boolean)contentURL1.equals(cdNode2Val3.getContentUrl()));
            Assert.assertEquals((String)"ContentURL for node1 should be contentURL1", (Object)contentURL1, (Object)cdNode1Val3.getContentUrl());
            Assert.assertEquals((String)"ContentURL for node2 should be contentURL2", (Object)contentURL2, (Object)cdNode2Val3.getContentUrl());
        }
        finally {
            contentPropertyRestrictionInterceptor.setGlobalContentPropertyRestrictionWhiteList("");
        }
    }

    private void addContentToNode(NodeRef nodeRef) {
        String content = "Some content";
        ContentWriter contentWriter = contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.setMimetype("text/plain");
        contentWriter.setEncoding("UTF-8");
        contentWriter.putContent(content);
    }

    private NodeRef createContentNode(NodeRef parentRef) {
        NodeRef nodeRef = nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT).getChildRef();
        this.addContentToNode(nodeRef);
        return nodeRef;
    }

    private NodeRef createContentNode(NodeRef parentRef, Map<QName, Serializable> properties) {
        return nodeService.createNode(parentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)GUID.generate()), ContentModel.TYPE_CONTENT, properties).getChildRef();
    }

    private static class InnerCallbackException
    extends RuntimeException {
        private static final long serialVersionUID = 4993673371982008186L;
        private final Throwable hiddenCause;

        public InnerCallbackException(Throwable hiddenCause) {
            super(hiddenCause.getMessage());
            this.hiddenCause = hiddenCause;
        }

        public Throwable getHiddenCause() {
            return this.hiddenCause;
        }
    }
}

