/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.repo.domain.propval.AbstractPropertyValueDAOImpl;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.DBTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class PropertyValueCleanupTest {
    private ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private AttributeService attributeService;
    private PropertyValueDAO propertyValueDAO;

    @Before
    public void setUp() throws Exception {
        this.transactionService = (TransactionService)this.ctx.getBean("TransactionService");
        this.attributeService = (AttributeService)this.ctx.getBean("AttributeService");
        this.propertyValueDAO = (PropertyValueDAO)this.ctx.getBean("propertyValueDAO");
        this.clearCaches();
    }

    private void clearCaches() {
        ((AbstractPropertyValueDAOImpl)this.propertyValueDAO).clearCaches();
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public synchronized void testRapidCreationDuringCleanup() throws Exception {
        toDeleteKey1 = "testRapidCreationDuringCleanup";
        toDeleteKey2 = UUID.randomUUID().toString();
        toDeleteProp = new String("Key is " + toDeleteKey2).getBytes("US-ASCII");
        Assert.assertNull((String)"Did not expect to find the attribute ", (Object)this.attributeService.getAttribute(new Serializable[]{toDeleteKey1, toDeleteKey2}));
        Assert.assertNull((String)"Key2 should be NOT present as a property value", (Object)this.propertyValueDAO.getPropertyStringValue(toDeleteKey2));
        this.attributeService.createAttribute((Serializable)toDeleteProp, new Serializable[]{toDeleteKey1, toDeleteKey2});
        Assert.assertNotNull((String)"Did not find the attribute ", (Object)this.attributeService.getAttribute(new Serializable[]{toDeleteKey1, toDeleteKey2}));
        Assert.assertNotNull((String)"Key2 should be present as a property value", (Object)this.propertyValueDAO.getPropertyStringValue(toDeleteKey2));
        this.attributeService.removeAttribute(new Serializable[]{toDeleteKey1, toDeleteKey2});
        Assert.assertNotNull((String)"Key2 should be present as a property value (even if unreferenced)", (Object)this.propertyValueDAO.getPropertyStringValue(toDeleteKey2));
        threadGroup = new ThreadGroup("testRapidCreationDuringCleanup");
        runnables = new InsertSerializableAttributes[2];
        try {
            i = 0;
            while (i < runnables.length) {
                runnables[i] = new InsertSerializableAttributes();
                threadName = "" + i;
                thread = new Thread(threadGroup, runnables[i], threadName);
                thread.setDaemon(true);
                thread.start();
                ++i;
            }
            this.wait(1000L);
            txnHelper = this.transactionService.getRetryingTransactionHelper();
            callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    PropertyValueCleanupTest.this.propertyValueDAO.cleanupUnusedValues();
                    return null;
                }
            };
            txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback);
        }
        finally {
            i = 0;
            ** while (i < runnables.length)
        }
lbl-1000:
        // 1 sources

        {
            runnables[i].running.set(false);
            ++i;
            continue;
        }
lbl35:
        // 1 sources

        this.clearCaches();
        Assert.assertNull((String)"Key2 should be NOT present as a property value (cleanup job)", (Object)this.propertyValueDAO.getPropertyStringValue(toDeleteKey2));
        i = 0;
        while (i < runnables.length) {
            key1 = runnables[i].key1;
            key2 = runnables[i].key2;
            key3s = new ArrayList<Integer>(runnables[i].key3s);
            for (Integer key3 : key3s) {
                propFetched = (byte[])this.attributeService.getAttribute(new Serializable[]{key1, key2, key3});
                if (propFetched == null) continue;
                Assert.assertTrue((String)("Arrays were not equal for " + key1 + ", " + key2 + ", " + String.valueOf(key3)), (boolean)Arrays.equals(runnables[i].prop, propFetched));
            }
            ++i;
        }
    }

    private class InsertSerializableAttributes
    implements Runnable {
        private final String key1;
        private final String key2;
        private List<Integer> key3s;
        private final byte[] prop;
        private AtomicBoolean running = new AtomicBoolean(true);
        private int counter = 0;

        private InsertSerializableAttributes() throws UnsupportedEncodingException {
            this.key1 = "PropertyValueCleanupTest";
            this.key2 = UUID.randomUUID().toString();
            this.key3s = Collections.synchronizedList(new ArrayList(200));
            this.prop = new String("Key is " + this.key2).getBytes("US-ASCII");
        }

        @Override
        public synchronized void run() {
            while (this.running.get()) {
                Integer key3 = this.counter;
                PropertyValueCleanupTest.this.attributeService.createAttribute((Serializable)this.prop, new Serializable[]{this.key1, this.key2, key3});
                this.key3s.add(key3);
                ++this.counter;
                try {
                    this.wait(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

