/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.util.schemacomp.SchemaCompTestingUtils;
import org.alfresco.util.schemacomp.SchemaToXML;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaToXMLTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void canTransformSchemaToXML() throws IOException {
        StringWriter writer = new StringWriter();
        StreamResult out = new StreamResult(writer);
        Schema schema = new Schema("alfresco", "my-prefix", 501, true);
        schema.add((DbObject)SchemaCompTestingUtils.table("node", SchemaCompTestingUtils.columns("id NUMBER(10)", "nodeRef VARCHAR2(200)", "name VARCHAR2(150)"), SchemaCompTestingUtils.pk("pk_node", "id"), SchemaCompTestingUtils.fkeys(SchemaCompTestingUtils.fk("fk_node_noderef", "nodeRef", "node", "nodeRef")), SchemaCompTestingUtils.indexes("idx_node_by_id id nodeRef")));
        schema.add((DbObject)SchemaCompTestingUtils.sequence("node_seq"));
        schema.add((DbObject)SchemaCompTestingUtils.sequence("content_seq"));
        SchemaToXML transformer = new SchemaToXML(schema, out);
        transformer.execute();
        System.out.println(((Object)writer).toString());
        BufferedReader reader = new BufferedReader(new StringReader(((Object)writer).toString()));
        String firstLine = reader.readLine();
        Assert.assertTrue((boolean)firstLine.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        String xsd = "xmlns=\"http://www.alfresco.org/repo/db-schema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.alfresco.org/repo/db-schema db-schema.xsd\"";
        Assert.assertTrue((boolean)firstLine.endsWith("<schema " + xsd + " name=\"alfresco\" dbprefix=\"my-prefix\" version=\"501\" tablecolumnorder=\"true\">"));
        Assert.assertEquals((Object)"  <validators>", (Object)reader.readLine());
    }
}

