/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.search.AbstractIndexFilter;
import org.alfresco.service.namespace.QName;

public class AspectIndexFilter
extends AbstractIndexFilter {
    private boolean ignorePathsForSpecificAspects = false;
    private Set<QName> aspectsForIgnoringPaths = new HashSet<QName>();
    private List<String> aspectsForIgnoringPathsString;

    public boolean isIgnorePathsForSpecificAspects() {
        return this.ignorePathsForSpecificAspects;
    }

    public void setIgnorePathsForSpecificAspects(boolean ignorePathsForSpecificAspects) {
        this.ignorePathsForSpecificAspects = ignorePathsForSpecificAspects;
    }

    public void setAspectsForIgnoringPaths(List<String> aspectsForIgnoringPaths) {
        this.aspectsForIgnoringPathsString = aspectsForIgnoringPaths;
    }

    @Override
    public void init() {
        super.init();
        this.initIgnoringPathsByCriterion(this.aspectsForIgnoringPathsString, this.aspectsForIgnoringPaths, new AbstractIndexFilter.DefinitionExistChecker(){

            @Override
            public boolean isDefinitionExists(QName qName) {
                return AspectIndexFilter.this.dictionaryService.getAspect(qName) != null;
            }
        });
    }

    public boolean shouldBeIgnored(Set<QName> aspects) {
        if (!this.ignorePathsForSpecificAspects) {
            return false;
        }
        if (aspects != null && !aspects.isEmpty()) {
            for (QName aspectForIgnoringPaths : this.aspectsForIgnoringPaths) {
                if (aspects.contains(aspectForIgnoringPaths)) {
                    return true;
                }
                for (QName nodeAspect : aspects) {
                    if (!this.dictionaryService.isSubClass(nodeAspect, aspectForIgnoringPaths)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

