/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.cmr.security.MutableAuthenticationService;

public class MutableAuthenticationServiceImpl
extends AuthenticationServiceImpl
implements MutableAuthenticationService {
    MutableAuthenticationDao authenticationDao;

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    @Override
    public void createAuthentication(String userName, char[] password) throws AuthenticationException {
        this.authenticationDao.createUser(userName, password);
    }

    @Override
    public void updateAuthentication(String userName, char[] oldPassword, char[] newPassword) throws AuthenticationException {
        String currentUser = AuthenticationUtil.getRunAsUser();
        try {
            this.authenticate(userName, oldPassword);
        }
        finally {
            AuthenticationUtil.setRunAsUser((String)currentUser);
        }
        this.authenticationDao.updateUser(userName, newPassword);
    }

    @Override
    public void setAuthentication(String userName, char[] newPassword) throws AuthenticationException {
        this.authenticationDao.updateUser(userName, newPassword);
    }

    @Override
    public void deleteAuthentication(String userName) throws AuthenticationException {
        this.authenticationDao.deleteUser(userName);
    }

    @Override
    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        return this.authenticationDao.getEnabled(userName);
    }

    @Override
    public void setAuthenticationEnabled(String userName, boolean enabled) throws AuthenticationException {
        this.authenticationDao.setEnabled(userName, enabled);
    }

    @Override
    public boolean authenticationExists(String userName) {
        return this.authenticationDao.userExists(userName);
    }

    @Override
    public boolean isAuthenticationMutable(String userName) {
        return this.authenticationExists(userName);
    }

    @Override
    public boolean isAuthenticationCreationAllowed() {
        return true;
    }
}

