/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.external;

import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultRemoteUserMapper
implements RemoteUserMapper,
ActivateableBean {
    private String proxyUserName = "alfresco-system";
    private String proxyHeader = "X-Alfresco-Remote-User";
    private boolean isEnabled;
    private Pattern userIdPattern;
    private PersonService personService;
    static Log logger = LogFactory.getLog(DefaultRemoteUserMapper.class);

    public void setProxyUserName(String proxyUserName) {
        this.proxyUserName = proxyUserName == null || proxyUserName.length() == 0 ? null : proxyUserName;
    }

    public void setProxyHeader(String proxyHeader) {
        this.proxyHeader = proxyHeader == null || proxyHeader.length() == 0 ? null : proxyHeader;
    }

    public void setActive(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setUserIdPattern(String userIdPattern) {
        this.userIdPattern = userIdPattern == null || userIdPattern.length() == 0 ? null : Pattern.compile(userIdPattern);
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    @Override
    public String getRemoteUser(HttpServletRequest request) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Getting RemoteUser from http request.");
        }
        if (!this.isEnabled) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"DefaultRemoteUserMapper is disabled, returning null.");
            }
            return null;
        }
        String remoteUserId = request.getRemoteUser();
        String headerUserId = this.extractUserFromProxyHeader(request);
        this.logUserInfoInRequest(remoteUserId, headerUserId);
        if (this.proxyUserName == null) {
            String normalizedUserId = this.normalizeUserId(headerUserId != null ? headerUserId : remoteUserId);
            this.logReturnedUser(normalizedUserId);
            return normalizedUserId;
        }
        if (remoteUserId == null) {
            String normalizedUserId = null;
            X509Certificate[] certs = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
            if (request.getScheme().toLowerCase().equals("https") && certs != null && certs.length > 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Checking SSL certificate subject DN to match " + this.proxyUserName));
                }
                int i = 0;
                while (i < certs.length) {
                    String subjectDN = certs[i].getSubjectX500Principal().getName();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Found subject DN " + subjectDN));
                    }
                    if (subjectDN.equals(this.proxyUserName)) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("The subject DN " + subjectDN + " matches " + this.proxyUserName));
                        }
                        remoteUserId = subjectDN;
                        normalizedUserId = this.normalizeUserId(headerUserId != null ? headerUserId : remoteUserId);
                        break;
                    }
                    ++i;
                }
            }
            this.logReturnedUser(normalizedUserId);
            return normalizedUserId;
        }
        String normalizedUserId = this.normalizeUserId(remoteUserId.equals(this.proxyUserName) ? headerUserId : remoteUserId);
        this.logReturnedUser(normalizedUserId);
        return normalizedUserId;
    }

    private void logUserInfoInRequest(String remoteUserId, String headerUserId) {
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("The remote user id is: " + remoteUserId + "\n");
            sb.append("The header user id is: " + headerUserId + "\n");
            sb.append("The proxy user name is: " + this.proxyUserName);
            logger.debug((Object)sb.toString());
        }
    }

    private void logReturnedUser(String userId) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Returning user:" + AuthenticationUtil.maskUsername((String)userId)));
        }
    }

    private String normalizeUserId(final String userId) {
        if (userId == null) {
            return null;
        }
        String normalized = (String)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                return DefaultRemoteUserMapper.this.personService.getUserIdentifier(userId);
            }
        }, (String)AuthenticationUtil.getSystemUserName());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("The normalized user name is: " + AuthenticationUtil.maskUsername((String)normalized) + " for user id " + AuthenticationUtil.maskUsername((String)userId)));
        }
        return normalized == null ? userId : normalized;
    }

    @Override
    public boolean isActive() {
        return this.isEnabled;
    }

    private String extractUserFromProxyHeader(HttpServletRequest request) {
        String userId;
        block12: {
            if (this.proxyHeader == null) {
                return null;
            }
            userId = request.getHeader(this.proxyHeader);
            if (userId == null) {
                return null;
            }
            boolean isEncode = Boolean.valueOf(request.getHeader("Remote-User-Encode"));
            try {
                if (userId != null && isEncode) {
                    userId = new String(Base64.decodeBase64((String)userId), "UTF-8");
                } else if (userId != null && !Base64.isBase64((String)userId)) {
                    userId = new String(userId.getBytes("ISO-8859-1"), "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!logger.isDebugEnabled()) break block12;
                logger.debug((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (this.userIdPattern == null) {
            userId = userId.trim();
        } else {
            Matcher matcher = this.userIdPattern.matcher(userId);
            if (matcher.matches()) {
                userId = matcher.group(1).trim();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("userId '" + AuthenticationUtil.maskUsername((String)userId) + "' did not match the userIdPattern '" + String.valueOf(this.userIdPattern) + "'. Returning null."));
                }
                return null;
            }
        }
        String userIdToReturn = userId.length() == 0 ? null : userId;
        this.logReturnedUser(userIdToReturn);
        return userIdToReturn;
    }
}

