/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.external.RemoteUserMapper;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceJITProvisioningHandler;
import org.alfresco.repo.security.authentication.identityservice.user.OIDCUserInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;

public class IdentityServiceRemoteUserMapper
implements RemoteUserMapper,
ActivateableBean {
    private static final Log LOGGER = LogFactory.getLog(IdentityServiceRemoteUserMapper.class);
    private boolean isEnabled;
    private boolean isValidationFailureSilent;
    private BearerTokenResolver bearerTokenResolver;
    private IdentityServiceJITProvisioningHandler jitProvisioningHandler;

    public void setActive(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setValidationFailureSilent(boolean silent) {
        this.isValidationFailureSilent = silent;
    }

    public void setBearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        this.bearerTokenResolver = bearerTokenResolver;
    }

    public void setJitProvisioningHandler(IdentityServiceJITProvisioningHandler jitProvisioningHandler) {
        this.jitProvisioningHandler = jitProvisioningHandler;
    }

    @Override
    public String getRemoteUser(HttpServletRequest request) {
        LOGGER.trace((Object)"Retrieving username from http request...");
        if (!this.isEnabled) {
            LOGGER.debug((Object)"IdentityServiceRemoteUserMapper is disabled, returning null.");
            return null;
        }
        try {
            String normalizedUserId = this.extractUserFromHeader(request);
            if (normalizedUserId != null) {
                LOGGER.trace((Object)("Returning userId: " + AuthenticationUtil.maskUsername((String)normalizedUserId)));
                return normalizedUserId;
            }
        }
        catch (IdentityServiceFacade.IdentityServiceFacadeException e) {
            if (!this.isValidationFailureSilent) {
                throw new AuthenticationException("Failed to extract username from token: " + e.getMessage(), (Throwable)e);
            }
            LOGGER.error((Object)("Failed to authenticate user using IdentityServiceRemoteUserMapper: " + e.getMessage()), (Throwable)e);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)("Failed to authenticate user using IdentityServiceRemoteUserMapper: " + e.getMessage()), (Throwable)e);
        }
        LOGGER.trace((Object)"Could not identify a userId. Returning null.");
        return null;
    }

    @Override
    public boolean isActive() {
        return this.isEnabled;
    }

    private String extractUserFromHeader(HttpServletRequest request) {
        String bearerToken;
        LOGGER.debug((Object)"Trying bearer token...");
        try {
            bearerToken = this.bearerTokenResolver.resolve(request);
        }
        catch (OAuth2AuthenticationException e) {
            LOGGER.debug((Object)"Failed to resolve Bearer token.", (Throwable)e);
            return null;
        }
        Optional<String> possibleUsername = this.jitProvisioningHandler.extractUserInfoAndCreateUserIfNeeded(bearerToken).map(OIDCUserInfo::username);
        if (possibleUsername.isEmpty()) {
            LOGGER.debug((Object)"User could not be authenticated by IdentityServiceRemoteUserMapper.");
            return null;
        }
        String normalizedUsername = possibleUsername.get();
        LOGGER.trace((Object)("Extracted username: " + AuthenticationUtil.maskUsername((String)normalizedUsername)));
        return normalizedUsername;
    }
}

