/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.cache.lookup;

import java.io.Serializable;
import java.sql.Savepoint;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.cache.MemoryCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.dao.DuplicateKeyException;

public class EntityLookupCacheTest
implements EntityLookupCache.EntityLookupCallbackDAO<Long, Object, String> {
    SimpleCache<Long, Object> cache;
    private EntityLookupCache<Long, Object, String> entityLookupCacheA;
    private EntityLookupCache<Long, Object, String> entityLookupCacheB;
    private TreeMap<Long, String> database;
    private ControlDAO controlDAO;

    @Before
    public void setUp() throws Exception {
        this.cache = new MemoryCache();
        this.entityLookupCacheA = new EntityLookupCache(this.cache, "A", (EntityLookupCache.EntityLookupCallbackDAO)this);
        this.entityLookupCacheB = new EntityLookupCache(this.cache, "B", (EntityLookupCache.EntityLookupCallbackDAO)this);
        this.database = new TreeMap();
        this.controlDAO = (ControlDAO)Mockito.mock(ControlDAO.class);
        Mockito.when((Object)this.controlDAO.createSavepoint(Mockito.anyString())).thenReturn((Object)((Savepoint)Mockito.mock(Savepoint.class)));
    }

    @Test(expected=AssertionError.class)
    public void testLookupsUsingIncorrectValue() throws Exception {
        this.entityLookupCacheA.getByValue((Object)this);
    }

    @Test
    public void testLookupAgainstEmpty() throws Exception {
        TestValue value = new TestValue("AAA");
        Pair entityPair = this.entityLookupCacheA.getByValue((Object)value);
        Assert.assertNull((Object)entityPair);
        Assert.assertTrue((boolean)this.database.isEmpty());
        entityPair = this.entityLookupCacheA.getOrCreateByValue((Object)value);
        Assert.assertNotNull((String)"Expected a value to be found", (Object)entityPair);
        Long entityId = (Long)entityPair.getFirst();
        Assert.assertTrue((String)"Database ID should have been created", (boolean)this.database.containsKey(entityId));
        Assert.assertEquals((String)"Database value incorrect", (Object)value.val, (Object)this.database.get(entityId));
        entityPair = this.entityLookupCacheA.getOrCreateByValue((Object)value);
        Assert.assertNotNull((String)"Expected a value to be found", (Object)entityPair);
        Assert.assertEquals((String)"Expected same entity ID", (Object)entityId, (Object)entityPair.getFirst());
        entityPair = this.entityLookupCacheA.getByValue((Object)value);
        Assert.assertNotNull((String)"Lookup after create should work", (Object)entityPair);
        entityPair = this.entityLookupCacheA.getByKey((Serializable)entityId);
        Assert.assertNotNull((String)"Lookup by key should work after create", (Object)entityPair);
        Assert.assertTrue((String)"Looked-up type incorrect", (boolean)(entityPair.getSecond() instanceof TestValue));
        Assert.assertEquals((String)"Looked-up type value incorrect", (Object)value, (Object)entityPair.getSecond());
    }

    @Test
    public void testLookupAgainstExisting() throws Exception {
        this.createValue(new TestValue("AAA"));
        this.createValue(new TestValue("BBB"));
        this.createValue(new TestValue("CCC"));
        Pair entityPair = this.entityLookupCacheA.getByValue((Object)new TestValue("AAA"));
        Assert.assertNotNull((String)"Expected value to be found", (Object)entityPair);
        Assert.assertEquals((String)"ID is incorrect", (Object)1L, (Object)entityPair.getFirst());
        entityPair = this.entityLookupCacheA.getByKey((Serializable)Long.valueOf(2L));
        Assert.assertNotNull((String)"Expected value to be found", (Object)entityPair);
        entityPair = this.entityLookupCacheA.getByValue((Object)new TestValue("CCC"));
        Assert.assertNotNull((String)"Expected value to be found", (Object)entityPair);
        Assert.assertEquals((String)"ID is incorrect", (Object)3L, (Object)entityPair.getFirst());
    }

    @Test
    public void testRegions() throws Exception {
        TestValue valueAAA = new TestValue("AAA");
        Pair entityPairAAA = this.entityLookupCacheA.getOrCreateByValue((Object)valueAAA);
        Assert.assertNotNull((Object)entityPairAAA);
        Assert.assertEquals((Object)"AAA", (Object)this.database.get(entityPairAAA.getFirst()));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        TestValue valueBBB = new TestValue("BBB");
        Pair entityPairBBB = this.entityLookupCacheB.getOrCreateByValue((Object)valueBBB);
        Assert.assertNotNull((Object)entityPairBBB);
        Assert.assertEquals((Object)"BBB", (Object)this.database.get(entityPairBBB.getFirst()));
        Assert.assertEquals((long)4L, (long)this.cache.getKeys().size());
        entityPairBBB = this.entityLookupCacheA.getByValue((Object)valueBBB);
        Assert.assertEquals((long)6L, (long)this.cache.getKeys().size());
        entityPairBBB = this.entityLookupCacheB.getByValue((Object)valueAAA);
        Assert.assertEquals((long)8L, (long)this.cache.getKeys().size());
    }

    @Test
    public void testNullLookups() throws Exception {
        Object valueNull = null;
        Pair entityPairNull = this.entityLookupCacheA.getOrCreateByValue(valueNull);
        Assert.assertNotNull((Object)entityPairNull);
        Assert.assertTrue((boolean)this.database.containsKey(entityPairNull.getFirst()));
        Assert.assertNull((Object)this.database.get(entityPairNull.getFirst()));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        Pair entityPairCheck = this.entityLookupCacheA.getOrCreateByValue(valueNull);
        Assert.assertNotNull((Object)entityPairNull);
        Assert.assertTrue((boolean)this.database.containsKey(entityPairNull.getFirst()));
        Assert.assertNull((Object)this.database.get(entityPairNull.getFirst()));
        Assert.assertEquals((Object)entityPairNull, (Object)entityPairCheck);
    }

    @Test
    public void testGetOrCreate() throws Exception {
        TestValue valueOne = new TestValue(this.getClass().getName() + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        Assert.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        Assert.assertEquals((Object)valueOne.val, (Object)this.database.get(id));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        Pair entityPairOneCheck = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        Assert.assertNotNull((Object)entityPairOneCheck);
        Assert.assertEquals((Object)id, (Object)entityPairOneCheck.getFirst());
    }

    @Test
    public void testCreateOrGet() throws Exception {
        TestValue valueOne = new TestValue(this.getClass().getName() + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.createOrGetByValue((Object)valueOne, this.controlDAO);
        Assert.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        Assert.assertEquals((Object)valueOne.val, (Object)this.database.get(id));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        Pair entityPairOneCheck = this.entityLookupCacheA.createOrGetByValue((Object)valueOne, this.controlDAO);
        Assert.assertNotNull((Object)entityPairOneCheck);
        Assert.assertEquals((Object)id, (Object)entityPairOneCheck.getFirst());
    }

    @Test
    public void testUpdate() throws Exception {
        TestValue valueOne = new TestValue(this.getClass().getName() + "-ONE");
        TestValue valueTwo = new TestValue(this.getClass().getName() + "-TWO");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        Assert.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        Assert.assertEquals((Object)valueOne.val, (Object)this.database.get(id));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        int updateCount = this.entityLookupCacheA.updateValue((Serializable)id, (Object)valueTwo);
        Assert.assertEquals((String)"Update count was incorrect.", (long)1L, (long)updateCount);
        Assert.assertEquals((Object)valueTwo.val, (Object)this.database.get(id));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
    }

    @Test
    public void testDeleteByKey() throws Exception {
        TestValue valueOne = new TestValue(this.getClass().getName() + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        Assert.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        Assert.assertEquals((Object)valueOne.val, (Object)this.database.get(id));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        int deleteCount = this.entityLookupCacheA.deleteByKey((Serializable)id);
        Assert.assertEquals((String)"Delete count was incorrect.", (long)1L, (long)deleteCount);
        Assert.assertNull((Object)this.database.get(id));
        Assert.assertEquals((long)0L, (long)this.cache.getKeys().size());
    }

    @Test
    public void testDeleteByValue() throws Exception {
        TestValue valueOne = new TestValue(this.getClass().getName() + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        Assert.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        Assert.assertEquals((Object)valueOne.val, (Object)this.database.get(id));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        int deleteCount = this.entityLookupCacheA.deleteByValue((Object)valueOne);
        Assert.assertEquals((String)"Delete count was incorrect.", (long)1L, (long)deleteCount);
        Assert.assertNull((Object)this.database.get(id));
        Assert.assertEquals((long)0L, (long)this.cache.getKeys().size());
    }

    @Test
    public void testClear() throws Exception {
        TestValue valueOne = new TestValue(this.getClass().getName() + "-ONE");
        Pair entityPairOne = this.entityLookupCacheA.getOrCreateByValue((Object)valueOne);
        Assert.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        Assert.assertEquals((Object)valueOne.val, (Object)this.database.get(id));
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        this.entityLookupCacheA.clear();
        Assert.assertEquals((Object)valueOne.val, (Object)this.database.get(id));
        Assert.assertEquals((long)0L, (long)this.cache.getKeys().size());
    }

    @Test
    public void testGetCachedValue() throws Exception {
        TestValue valueCached = new TestValue(this.getClass().getName() + "-CACHED");
        Pair entityPairOne = this.entityLookupCacheA.createOrGetByValue((Object)valueCached, this.controlDAO);
        Assert.assertNotNull((Object)entityPairOne);
        Long id = (Long)entityPairOne.getFirst();
        Assert.assertEquals((long)2L, (long)this.cache.getKeys().size());
        Pair entityPairCacheCheck = this.entityLookupCacheA.getCachedEntityByValue((Object)valueCached);
        Assert.assertNotNull((Object)entityPairCacheCheck);
        Assert.assertEquals((Object)id, (Object)entityPairCacheCheck.getFirst());
        this.entityLookupCacheA.clear();
        entityPairCacheCheck = this.entityLookupCacheA.getCachedEntityByValue((Object)valueCached);
        Assert.assertNull((Object)entityPairCacheCheck);
    }

    public String getValueKey(Object value) {
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof TestValue));
        String dbValue = ((TestValue)value).val;
        return dbValue;
    }

    public Pair<Long, Object> findByKey(Long key) {
        Assert.assertNotNull((Object)key);
        String dbValue = this.database.get(key);
        if (dbValue == null) {
            return null;
        }
        TestValue value = new TestValue(dbValue);
        return new Pair((Object)key, (Object)value);
    }

    public Pair<Long, Object> findByValue(Object value) {
        Assert.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        String dbValue = value == null ? null : ((TestValue)value).val;
        for (Map.Entry<Long, String> entry : this.database.entrySet()) {
            if (!EqualsHelper.nullSafeEquals((Object)entry.getValue(), (Object)dbValue)) continue;
            return new Pair((Object)entry.getKey(), (Object)entry.getValue());
        }
        return null;
    }

    public Pair<Long, Object> createValue(Object value) {
        String dbValue;
        Assert.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        String string = dbValue = value == null ? null : ((TestValue)value).val;
        if (this.database.containsValue(dbValue)) {
            throw new DuplicateKeyException("Value is duplicated: " + String.valueOf(value));
        }
        Long lastKey = this.database.isEmpty() ? null : this.database.lastKey();
        Long newKey = null;
        newKey = lastKey == null ? Long.valueOf(1L) : Long.valueOf(lastKey + 1L);
        this.database.put(newKey, dbValue);
        return new Pair((Object)newKey, value);
    }

    public int updateValue(Long key, Object value) {
        Assert.assertNotNull((Object)key);
        Assert.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        Pair<Long, Object> entityPair = this.findByKey(key);
        if (entityPair == null) {
            return 0;
        }
        this.database.put(key, ((TestValue)value).val);
        return 1;
    }

    public int deleteByKey(Long key) {
        Assert.assertNotNull((Object)key);
        if (this.database.containsKey(key)) {
            this.database.remove(key);
            return 1;
        }
        return 0;
    }

    public int deleteByValue(Object value) {
        Assert.assertTrue((value == null || value instanceof TestValue ? 1 : 0) != 0);
        Pair<Long, Object> entityPair = this.findByValue(value);
        if (entityPair == null) {
            return 0;
        }
        this.database.remove(entityPair.getFirst());
        return 1;
    }

    private static class TestValue {
        private final String val;

        private TestValue(String val) {
            this.val = val;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TestValue)) {
                return false;
            }
            return this.val.equals(((TestValue)obj).val);
        }

        public int hashCode() {
            return this.val.hashCode();
        }
    }
}

