/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.LogAdapter;
import org.apache.commons.logging.Log;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TransformerDebugTest {
    public static final String RENDITION_2B = "renditionName1";
    public static final String TRANSFORMER_A2B = "transformerA2B";
    public static final String TRANSFORMER_A2C = "transformerA2C";
    public static final String TRANSFORMER_C2B = "transformerC2B";
    private TransformerDebug transformerDebug;
    public static final String MIMETYPE_A = "mimetypeA";
    public static final String MIMETYPE_A_EXT = "a";
    public static final String MIMETYPE_B = "mimetypeB";
    public static final String MIMETYPE_B_EXT = "bbb";
    public static final String MIMETYPE_C = "mimetypeC";
    public static final String MIMETYPE_C_EXT = "ccc";
    public static final String MIMETYPE_DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String MIMETYPE_DOCX_EXT = "docx";
    public static final String MIMETYPE_LONGER = "mimetypeLonger";
    public static final String MIMETYPE_LONGER_EXT = "longer";
    private static final Map<String, String> testMimetypeService = ImmutableMap.of((Object)"mimetypeA", (Object)"a", (Object)"mimetypeB", (Object)"bbb", (Object)"mimetypeC", (Object)"ccc", (Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)"docx", (Object)"mimetypeLonger", (Object)"longer");
    private StringBuilder singleLine;
    private StringBuilder multiLine;
    private AtomicReference<LogLevel> singleLineLogLevel = new AtomicReference();
    private AtomicReference<LogLevel> multiLineLogLevel = new AtomicReference();
    private Map<String, String> options;
    @Mock
    private NodeService nodeService;
    private NodeRef sourceNodeRef = new NodeRef("workspace://SpacesStore/parent");

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        TransformerDebug.Frame.reset();
        this.singleLine = new StringBuilder();
        this.multiLine = new StringBuilder();
        this.singleLineLogLevel.set(LogLevel.DEBUG);
        this.multiLineLogLevel.set(LogLevel.DEBUG);
        this.transformerDebug = new TransformerDebug();
        this.transformerDebug.setExtensionLookup(mimetype -> testMimetypeService.get(mimetype));
        this.transformerDebug.setTransformerDebugLog((Log)new DummyLog(this.multiLine, this.multiLineLogLevel));
        this.transformerDebug.setTransformerLog((Log)new DummyLog(this.singleLine, this.singleLineLogLevel));
        this.transformerDebug.setNodeService(this.nodeService);
        this.options = ImmutableMap.of((Object)"option1", (Object)"value1", (Object)"option2", (Object)"value2");
        ((NodeService)Mockito.doReturn((Object)"filename1.a").when((Object)this.nodeService)).getProperty(this.sourceNodeRef, ContentModel.PROP_NAME);
    }

    private static String getSanitisedActual(StringBuilder debug) {
        return debug.toString().replaceAll(" [\\d,]+ ms", " nn ms");
    }

    @Test
    public void testSingleLevelTransformDebug() {
        String expectedSingleLine = "DEBUG 0 a    bbb  INFO filename1.a 1 KB nn ms transformerA2B -- renditionName1 -- ";
        String expectedMultiLine = "DEBUG 0               a    bbb  filename1.a 1 KB -- renditionName1 -- transformerA2B\nDEBUG 0                 option1=\"value1\"\nDEBUG 0                 option2=\"value2\"\nDEBUG 0               workspace://SpacesStore/parent\nDEBUG 0               Finished in nn ms\n";
        this.testSingleLevelTransform(expectedSingleLine, expectedMultiLine);
    }

    @Test
    public void testSingleLevelTransformTrace() {
        this.singleLineLogLevel.set(LogLevel.TRACE);
        this.multiLineLogLevel.set(LogLevel.TRACE);
        String expectedSingleLine = "DEBUG 0 a    bbb  INFO filename1.a 1 KB nn ms transformerA2B -- renditionName1 -- ";
        String expectedMultiLine = "TRACE 0               fromUrl1\nTRACE 0               mimetypeA mimetypeB\nDEBUG 0               a    bbb  filename1.a 1 KB -- renditionName1 -- transformerA2B\nDEBUG 0                 option1=\"value1\"\nDEBUG 0                 option2=\"value2\"\nDEBUG 0               workspace://SpacesStore/parent\nDEBUG 0               Finished in nn ms\n";
        this.testSingleLevelTransform(expectedSingleLine, expectedMultiLine);
    }

    @Test
    public void testSingleLevelTransformInfo() {
        this.singleLineLogLevel.set(LogLevel.INFO);
        this.multiLineLogLevel.set(LogLevel.INFO);
        String expectedSingleLine = "";
        String expectedMultiLine = "";
        this.testSingleLevelTransform(expectedSingleLine, expectedMultiLine);
    }

    private void testSingleLevelTransform(String expectedSingleLine, String expectedMultiLine) {
        this.transformerDebug.pushTransform(TRANSFORMER_A2B, "fromUrl1", MIMETYPE_A, MIMETYPE_B, 1024L, this.options, RENDITION_2B, this.sourceNodeRef);
        this.transformerDebug.popTransform();
        Assert.assertEquals((Object)expectedSingleLine, (Object)TransformerDebugTest.getSanitisedActual(this.singleLine));
        Assert.assertEquals((Object)expectedMultiLine, (Object)TransformerDebugTest.getSanitisedActual(this.multiLine));
    }

    @Test
    public void testMultiLevelTransformDebug() {
        String expectedSingleLine = "DEBUG 0 a    bbb  INFO filename1.a 1 KB nn ms transformerA2B -- renditionName1 -- ";
        String expectedMultiLine = "DEBUG 0               a    bbb  filename1.a 1 KB -- renditionName1 -- transformerA2B\nDEBUG 0                 option1=\"value1\"\nDEBUG 0                 option2=\"value2\"\nDEBUG 0               workspace://SpacesStore/parent\nDEBUG 0.1             a    ccc  filename1.a 1 KB transformerA2C\nDEBUG 0.2             ccc  bbb  filename1.a 1 KB transformerC2B\nDEBUG 0               Finished in nn ms\n";
        this.testMultiLevelTransform(expectedSingleLine, expectedMultiLine);
    }

    @Test
    public void testMultiLevelTransformTrace() {
        this.singleLineLogLevel.set(LogLevel.TRACE);
        this.multiLineLogLevel.set(LogLevel.TRACE);
        String expectedSingleLine = "TRACE 0.1             a    ccc  INFO filename1.a 1 KB nn ms transformerA2C -- renditionName1 -- \nTRACE 0.2             ccc  bbb  INFO filename1.a 1 KB nn ms transformerC2B -- renditionName1 -- \nDEBUG 0 a    bbb  INFO filename1.a 1 KB nn ms transformerA2B -- renditionName1 -- ";
        String expectedMultiLine = "TRACE 0               fromUrl1\nTRACE 0               mimetypeA mimetypeB\nDEBUG 0               a    bbb  filename1.a 1 KB -- renditionName1 -- transformerA2B\nDEBUG 0                 option1=\"value1\"\nDEBUG 0                 option2=\"value2\"\nDEBUG 0               workspace://SpacesStore/parent\nTRACE 0.1             fromUrl1\nTRACE 0.1             mimetypeA mimetypeC\nDEBUG 0.1             a    ccc  filename1.a 1 KB transformerA2C\nTRACE 0.1             Finished in nn ms\nTRACE 0.2             fromUrl1\nTRACE 0.2             mimetypeC mimetypeB\nDEBUG 0.2             ccc  bbb  filename1.a 1 KB transformerC2B\nTRACE 0.2             Finished in nn ms\nDEBUG 0               Finished in nn ms\n";
        this.testMultiLevelTransform(expectedSingleLine, expectedMultiLine);
    }

    @Test
    public void testMultiLevelTransformInfo() {
        this.singleLineLogLevel.set(LogLevel.INFO);
        this.multiLineLogLevel.set(LogLevel.INFO);
        String expectedSingleLine = "";
        String expectedMultiLine = "";
        this.testMultiLevelTransform(expectedSingleLine, expectedMultiLine);
    }

    private void testMultiLevelTransform(String expectedSingleLine, String expectedMultiLine) {
        this.transformerDebug.pushTransform(TRANSFORMER_A2B, "fromUrl1", MIMETYPE_A, MIMETYPE_B, 1024L, this.options, RENDITION_2B, this.sourceNodeRef);
        this.transformerDebug.pushTransform(TRANSFORMER_A2C, "fromUrl1", MIMETYPE_A, MIMETYPE_C, 1024L, this.options, RENDITION_2B, this.sourceNodeRef);
        this.transformerDebug.popTransform();
        this.transformerDebug.pushTransform(TRANSFORMER_C2B, "fromUrl1", MIMETYPE_C, MIMETYPE_B, 1024L, this.options, RENDITION_2B, this.sourceNodeRef);
        this.transformerDebug.popTransform();
        this.transformerDebug.popTransform();
        Assert.assertEquals((Object)expectedSingleLine, (Object)TransformerDebugTest.getSanitisedActual(this.singleLine));
        Assert.assertEquals((Object)expectedMultiLine, (Object)TransformerDebugTest.getSanitisedActual(this.multiLine));
    }

    @Test
    public void testReplaceWithMetadataExtensionIfEmbedOrExtract() {
        Assert.assertEquals((Object)"json", (Object)TransformerDebug.replaceWithMetadataExtensionIfEmbedOrExtract((String)"alfresco-metadata-extract", (String)"jpeg", (String)"targetExtension"));
        Assert.assertEquals((Object)"jpeg", (Object)TransformerDebug.replaceWithMetadataExtensionIfEmbedOrExtract((String)"alfresco-metadata-embed", (String)"jpeg", (String)"targetExtension"));
        Assert.assertEquals((Object)MIMETYPE_DOCX_EXT, (Object)TransformerDebug.replaceWithMetadataExtensionIfEmbedOrExtract((String)MIMETYPE_DOCX, (String)"jpeg", (String)MIMETYPE_DOCX_EXT));
    }

    @Test
    public void testGetMimetypeExt() {
        Assert.assertEquals((Object)"a    ", (Object)this.transformerDebug.getMimetypeExt(MIMETYPE_A));
        Assert.assertEquals((Object)"bbb  ", (Object)this.transformerDebug.getMimetypeExt(MIMETYPE_B));
        Assert.assertEquals((Object)"docx ", (Object)this.transformerDebug.getMimetypeExt(MIMETYPE_DOCX));
        Assert.assertEquals((Object)"longer ", (Object)this.transformerDebug.getMimetypeExt(MIMETYPE_LONGER));
        Assert.assertEquals((Object)"unknown ", (Object)this.transformerDebug.getMimetypeExt("unknown"));
        Assert.assertEquals((Object)"x ", (Object)this.transformerDebug.getMimetypeExt("x"));
    }

    @Test
    public void testSpaces() {
        Assert.assertEquals((Object)"", (Object)this.transformerDebug.spaces(-1));
        Assert.assertEquals((Object)"", (Object)this.transformerDebug.spaces(0));
        Assert.assertEquals((Object)" ", (Object)this.transformerDebug.spaces(1));
        Assert.assertEquals((Object)"   ", (Object)this.transformerDebug.spaces(3));
        Assert.assertEquals((Object)"     ", (Object)this.transformerDebug.spaces(5));
    }

    @Test
    public void testMs() {
        Assert.assertEquals((Object)"-1 ms", (Object)this.transformerDebug.ms(-1L));
        Assert.assertEquals((Object)"0 ms", (Object)this.transformerDebug.ms(0L));
        Assert.assertEquals((Object)"1 ms", (Object)this.transformerDebug.ms(1L));
        Assert.assertEquals((Object)"2 ms", (Object)this.transformerDebug.ms(2L));
        Assert.assertEquals((Object)"123 ms", (Object)this.transformerDebug.ms(123L));
        Assert.assertEquals((Object)"1,234 ms", (Object)this.transformerDebug.ms(1234L));
        Assert.assertEquals((Object)"3,600,000 ms", (Object)this.transformerDebug.ms(3600000L));
    }

    @Test
    public void testFileSize() {
        Assert.assertEquals((Object)"unlimited", (Object)this.transformerDebug.fileSize(-1L));
        Assert.assertEquals((Object)"0 bytes", (Object)this.transformerDebug.fileSize(0L));
        Assert.assertEquals((Object)"1 byte", (Object)this.transformerDebug.fileSize(1L));
        Assert.assertEquals((Object)"2 bytes", (Object)this.transformerDebug.fileSize(2L));
        Assert.assertEquals((Object)"2 KB", (Object)this.transformerDebug.fileSize(2048L));
        Assert.assertEquals((Object)"3 MB", (Object)this.transformerDebug.fileSize(0x300000L));
        Assert.assertEquals((Object)"4 GB", (Object)this.transformerDebug.fileSize(0x100000000L));
        Assert.assertEquals((Object)"5 TB", (Object)this.transformerDebug.fileSize(0x50000000000L));
        Assert.assertEquals((Object)"1.4 KB", (Object)this.transformerDebug.fileSize(1535L));
        Assert.assertEquals((Object)"1.5 KB", (Object)this.transformerDebug.fileSize(1536L));
        Assert.assertEquals((Object)"1.9 KB", (Object)this.transformerDebug.fileSize(2047L));
        Assert.assertEquals((Object)"2.9 MB", (Object)this.transformerDebug.fileSize(0x2FFFFFL));
        Assert.assertEquals((Object)"3.9 GB", (Object)this.transformerDebug.fileSize(0xFFFFFFFFL));
        Assert.assertEquals((Object)"4.9 TB", (Object)this.transformerDebug.fileSize(0x4FFFFFFFFFFL));
    }

    @Test
    public void testGetRenditionName() {
        Assert.assertEquals((Object)"", (Object)this.transformerDebug.getRenditionName(null));
        Assert.assertEquals((Object)"-- doclib -- ", (Object)this.transformerDebug.getRenditionName("doclib"));
        Assert.assertEquals((Object)"-- metadataExtract -- ", (Object)this.transformerDebug.getRenditionName("transform:alfresco-metadata-extract"));
        Assert.assertEquals((Object)"-- metadataEmbed -- ", (Object)this.transformerDebug.getRenditionName("transform:alfresco-metadata-embed"));
        Assert.assertEquals((Object)"-- transform:customTransform -- ", (Object)this.transformerDebug.getRenditionName("transform:customTransform"));
    }

    @Test
    public void testGetTransformName() {
        Assert.assertEquals(null, (Object)TransformerDebug.getTransformName(null));
        Assert.assertEquals(null, (Object)TransformerDebug.getTransformName((String)"doclib"));
        Assert.assertEquals((Object)"alfresco-metadata-extract", (Object)TransformerDebug.getTransformName((String)"transform:alfresco-metadata-extract"));
        Assert.assertEquals((Object)"alfresco-metadata-embed", (Object)TransformerDebug.getTransformName((String)"transform:alfresco-metadata-embed"));
        Assert.assertEquals((Object)"customTransform", (Object)TransformerDebug.getTransformName((String)"transform:customTransform"));
    }

    private class DummyLog
    extends LogAdapter {
        private final StringBuilder stringBuilder;
        private final AtomicReference<LogLevel> logLevel;

        public DummyLog(StringBuilder stringBuilder, AtomicReference<LogLevel> logLevel) {
            super(null);
            this.stringBuilder = stringBuilder;
            this.logLevel = logLevel;
        }

        public boolean isDebugEnabled() {
            return LogLevel.DEBUG.isSet(this.logLevel.get());
        }

        public boolean isTraceEnabled() {
            return LogLevel.TRACE.isSet(this.logLevel.get());
        }

        public void debug(Object message, Throwable throwable) {
            if (this.isDebugEnabled()) {
                this.append(message, throwable, "DEBUG ");
            }
        }

        public void trace(Object message, Throwable throwable) {
            if (this.isTraceEnabled()) {
                this.append(message, throwable, "TRACE ");
            }
        }

        private void append(Object message, Throwable throwable, String prefix) {
            if (this.stringBuilder.length() > 0) {
                this.stringBuilder.append('\n');
            }
            this.stringBuilder.append(prefix).append(message);
            if (throwable != null) {
                this.stringBuilder.append("\n      ").append(throwable.getMessage());
            }
        }
    }

    private static enum LogLevel {
        INFO,
        DEBUG,
        TRACE;


        boolean isSet(LogLevel levelSet) {
            return levelSet != null && this.compareTo(levelSet) <= 0;
        }
    }
}

