/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.bundle;

import java.util.HashMap;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.coci.CheckOutCheckInServiceImpl;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.surf.util.I18NUtil;

@Category(value={LuceneTests.class})
public class VirtualCheckOutCheckInServiceExtensionTest
extends VirtualizationIntegrationTest {
    private static final String PROP_VERSION_LABEL_3 = "1.0";
    private static final String PROP_VERSION_LABEL_2 = "0.2";
    private static final String PROP_VERSION_LABEL_1 = "0.1";
    private static final String PROP_VERSION_DESCRIPTION_3 = "dd2";
    private static final String PROP_VERSION_DESCRIPTION_2 = "dd1";
    private static final String PROP_VERSION_DESCRIPTION_1 = "dd";
    private static final String TEST_CONTENT_3 = "2";
    private static final String TEST_CONTENT_2 = "1";
    private static final String TEST_CONTENT_1 = "0";
    private static final String PROP_FILE_NAME = "originalFile";
    private String PROP_WORKING_COPY_NAME;
    private CheckOutCheckInService checkOutCheckInService;
    private VersionService versionService;
    private NodeRef originalContentNodeRef;
    private NodeRef node;
    private NodeRef physicalFileNodeRef;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.PROP_WORKING_COPY_NAME = CheckOutCheckInServiceImpl.createWorkingCopyName((String)PROP_FILE_NAME, (String)I18NUtil.getMessage((String)"coci_service.working_copy_label"));
        this.checkOutCheckInService = (CheckOutCheckInService)this.ctx.getBean("checkOutCheckInService", CheckOutCheckInService.class);
        this.versionService = (VersionService)this.ctx.getBean("versionService", VersionService.class);
        this.node = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, "Node1");
        this.originalContentNodeRef = this.createContent(this.node, PROP_FILE_NAME, TEST_CONTENT_1, "text/plain", "UTF-8").getChildRef();
        this.nodeService.addAspect(this.originalContentNodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.physicalFileNodeRef = this.nodeService.getChildByName(this.virtualFolder1NodeRef, ContentModel.ASSOC_CONTAINS, PROP_FILE_NAME);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testCheckOut() throws Exception {
        NodeRef workingCopy = this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        Assert.assertNotNull((Object)workingCopy);
        Assert.assertTrue((boolean)this.checkOutCheckInService.isCheckedOut(this.physicalFileNodeRef));
        Assert.assertEquals((Object)this.checkOutCheckInService.getWorkingCopy(this.originalContentNodeRef), (Object)workingCopy);
        this.checkOutCheckInService.cancelCheckout(workingCopy);
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(this.node);
        NodeRef workingCopy1 = this.checkOutCheckInService.checkout(this.originalContentNodeRef, childAssocRef.getParentRef(), childAssocRef.getTypeQName(), childAssocRef.getQName());
        Assert.assertNotNull((Object)workingCopy1);
        Assert.assertTrue((boolean)this.checkOutCheckInService.isCheckedOut(this.physicalFileNodeRef));
        Assert.assertEquals((Object)this.checkOutCheckInService.getWorkingCopy(this.physicalFileNodeRef), (Object)workingCopy1);
        this.checkOutCheckInService.cancelCheckout(workingCopy1);
    }

    @Test
    public void testCheckIn() throws Exception {
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        NodeRef workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        HashMap<String, String> versionProperties = new HashMap<String, String>();
        versionProperties.put("description", PROP_VERSION_DESCRIPTION_1);
        versionProperties.put("versionType", (String)VersionType.MINOR);
        NodeRef origNodeRef = this.checkOutCheckInService.checkin(workingCopyVirtualContext, versionProperties);
        Assert.assertNotNull((Object)origNodeRef);
        Assert.assertEquals((Object)this.originalContentNodeRef, (Object)origNodeRef);
        Assert.assertFalse((boolean)this.checkOutCheckInService.isCheckedOut(this.physicalFileNodeRef));
        Version version = this.versionService.getCurrentVersion(origNodeRef);
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)PROP_VERSION_DESCRIPTION_1, (Object)version.getDescription());
        Assert.assertEquals((Object)VersionType.MINOR, (Object)version.getVersionType());
        Assert.assertEquals((Object)PROP_VERSION_LABEL_1, (Object)version.getVersionLabel());
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        versionProperties = new HashMap();
        versionProperties.put("description", PROP_VERSION_DESCRIPTION_2);
        versionProperties.put("versionType", (String)VersionType.MINOR);
        ContentWriter tempWriter = this.contentService.getWriter(workingCopyVirtualContext, ContentModel.PROP_CONTENT, false);
        Assert.assertNotNull((Object)tempWriter);
        tempWriter.putContent(TEST_CONTENT_2);
        String contentUrl = tempWriter.getContentUrl();
        origNodeRef = this.checkOutCheckInService.checkin(workingCopyVirtualContext, versionProperties, contentUrl);
        Assert.assertNotNull((Object)origNodeRef);
        Assert.assertEquals((Object)this.originalContentNodeRef, (Object)origNodeRef);
        Assert.assertFalse((boolean)this.checkOutCheckInService.isCheckedOut(this.physicalFileNodeRef));
        ContentReader contentReader = this.contentService.getReader(origNodeRef, ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)TEST_CONTENT_2, (Object)contentReader.getContentString());
        version = this.versionService.getCurrentVersion(origNodeRef);
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)PROP_VERSION_DESCRIPTION_2, (Object)version.getDescription());
        Assert.assertEquals((Object)VersionType.MINOR, (Object)version.getVersionType());
        Assert.assertEquals((Object)PROP_VERSION_LABEL_2, (Object)version.getVersionLabel());
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        versionProperties = new HashMap();
        versionProperties.put("description", PROP_VERSION_DESCRIPTION_3);
        versionProperties.put("versionType", (String)VersionType.MAJOR);
        tempWriter = this.contentService.getWriter(workingCopyVirtualContext, ContentModel.PROP_CONTENT, false);
        Assert.assertNotNull((Object)tempWriter);
        tempWriter.putContent(TEST_CONTENT_3);
        contentUrl = tempWriter.getContentUrl();
        origNodeRef = this.checkOutCheckInService.checkin(workingCopyVirtualContext, versionProperties, contentUrl, false);
        Assert.assertNotNull((Object)origNodeRef);
        Assert.assertEquals((Object)this.originalContentNodeRef, (Object)origNodeRef);
        Assert.assertFalse((boolean)this.checkOutCheckInService.isCheckedOut(this.physicalFileNodeRef));
        contentReader = this.contentService.getReader(origNodeRef, ContentModel.PROP_CONTENT);
        Assert.assertNotNull((Object)contentReader);
        Assert.assertEquals((Object)TEST_CONTENT_3, (Object)contentReader.getContentString());
        version = this.versionService.getCurrentVersion(origNodeRef);
        Assert.assertNotNull((Object)version);
        Assert.assertEquals((Object)PROP_VERSION_DESCRIPTION_3, (Object)version.getDescription());
        Assert.assertEquals((Object)VersionType.MAJOR, (Object)version.getVersionType());
        Assert.assertEquals((Object)PROP_VERSION_LABEL_3, (Object)version.getVersionLabel());
    }

    @Test
    public void testCancelCheckout() throws Exception {
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        Assert.assertTrue((boolean)this.checkOutCheckInService.isCheckedOut(this.physicalFileNodeRef));
        NodeRef workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        Assert.assertNotNull((Object)workingCopyVirtualContext);
        this.checkOutCheckInService.cancelCheckout(workingCopyVirtualContext);
        Assert.assertFalse((boolean)this.checkOutCheckInService.isCheckedOut(this.physicalFileNodeRef));
        workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        Assert.assertNull((Object)workingCopyVirtualContext);
    }

    @Test
    public void testGetWorkingCopy() throws Exception {
        NodeRef checkedOut = this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        NodeRef workingCopy = this.checkOutCheckInService.getWorkingCopy(this.originalContentNodeRef);
        Assert.assertNotNull((Object)workingCopy);
        Assert.assertEquals((Object)checkedOut, (Object)workingCopy);
        this.checkOutCheckInService.cancelCheckout(workingCopy);
        workingCopy = this.checkOutCheckInService.getWorkingCopy(this.originalContentNodeRef);
        Assert.assertNull((Object)workingCopy);
        Assert.assertNull((Object)this.checkOutCheckInService.getWorkingCopy(this.physicalFileNodeRef));
    }

    @Test
    public void testGetCheckedOut() throws Exception {
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        NodeRef workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        Assert.assertNotNull((Object)workingCopyVirtualContext);
        NodeRef checkedOut = this.checkOutCheckInService.getCheckedOut(workingCopyVirtualContext);
        Assert.assertNotNull((Object)checkedOut);
        Assert.assertEquals((Object)this.originalContentNodeRef, (Object)checkedOut);
        this.checkOutCheckInService.cancelCheckout(workingCopyVirtualContext);
        NodeRef checkedOut2 = this.checkOutCheckInService.getCheckedOut(this.originalContentNodeRef);
        Assert.assertNull((Object)checkedOut2);
    }

    @Test
    public void testIsWorkingCopy() throws Exception {
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        NodeRef workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        Assert.assertNotNull((Object)workingCopyVirtualContext);
        Assert.assertTrue((boolean)this.checkOutCheckInService.isWorkingCopy(workingCopyVirtualContext));
        this.checkOutCheckInService.cancelCheckout(workingCopyVirtualContext);
    }

    @Test
    public void testIsCheckedOut() throws Exception {
        NodeRef workingCopy = this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        Assert.assertNotNull((Object)workingCopy);
        boolean checkedOut = this.checkOutCheckInService.isCheckedOut(this.originalContentNodeRef);
        Assert.assertTrue((boolean)checkedOut);
        this.checkOutCheckInService.cancelCheckout(workingCopy);
        checkedOut = this.checkOutCheckInService.isCheckedOut(this.originalContentNodeRef);
        Assert.assertFalse((boolean)checkedOut);
    }

    @Test
    public void testAssocsReferences() throws Exception {
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        NodeRef workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        List targetAssocs = this.nodeService.getTargetAssocs(this.originalContentNodeRef, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
        Assert.assertNotNull((Object)targetAssocs);
        Assert.assertEquals((long)1L, (long)targetAssocs.size());
        Assert.assertEquals((Object)workingCopyVirtualContext, (Object)((AssociationRef)targetAssocs.get(0)).getTargetRef());
        List sourceAssocs = this.nodeService.getSourceAssocs(workingCopyVirtualContext, (QNamePattern)ContentModel.ASSOC_WORKING_COPY_LINK);
        Assert.assertNotNull((Object)sourceAssocs);
        Assert.assertEquals((long)1L, (long)sourceAssocs.size());
        Assert.assertEquals((Object)this.originalContentNodeRef, (Object)((AssociationRef)sourceAssocs.get(0)).getSourceRef());
        this.checkOutCheckInService.cancelCheckout(workingCopyVirtualContext);
    }

    @Test
    public void test_ACE_4699() throws Exception {
        this.checkOutCheckInService.checkout(this.originalContentNodeRef);
        NodeRef workingCopyVirtualContext = this.nodeService.getChildByName(this.node, ContentModel.ASSOC_CONTAINS, this.PROP_WORKING_COPY_NAME);
        Assert.assertNotNull((Object)workingCopyVirtualContext);
        NodeRef cancelCheckoutNodeRef = this.checkOutCheckInService.cancelCheckout(workingCopyVirtualContext);
        Assert.assertEquals((Object)this.originalContentNodeRef, (Object)cancelCheckoutNodeRef);
    }
}

